/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.dropwizard.bundle.graphql;

import com.gs.fw.common.mithra.MithraList;
import com.gs.fw.common.mithra.finder.RelatedFinder;
import com.gs.fw.finder.DomainList;
import com.gs.fw.finder.Operation;
import cool.klass.data.store.reladomo.ReladomoDataStore;
import cool.klass.model.meta.domain.api.Classifier;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.reladomo.tree.ReladomoTreeNodeListener;
import cool.klass.model.reladomo.tree.ReladomoTreeNodeToManyAwareListener;
import cool.klass.model.reladomo.tree.RootReladomoTreeNode;
import cool.klass.model.reladomo.tree.converter.graphql.ReladomoTreeGraphqlConverter;
import cool.klass.reladomo.tree.deep.fetcher.ReladomoTreeNodeDeepFetcherListener;
import cool.klass.reladomo.tree.serializer.ReladomoTreeObjectToDTOSerializerListener;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import io.liftwizard.graphql.exception.LiftwizardGraphQLException;
import io.liftwizard.model.reladomo.operation.compiler.ReladomoOperationCompiler;
import java.util.Map;
import java.util.Objects;
import org.eclipse.collections.api.factory.Lists;

public class ByOperationDataFetcher
implements DataFetcher<Object> {
    private final Klass klass;
    private final ReladomoDataStore dataStore;
    private final ReladomoTreeGraphqlConverter reladomoTreeGraphqlConverter;
    private final RelatedFinder<?> finder;

    public ByOperationDataFetcher(Klass klass, ReladomoDataStore dataStore, ReladomoTreeGraphqlConverter reladomoTreeGraphqlConverter) {
        this.klass = Objects.requireNonNull(klass);
        this.dataStore = Objects.requireNonNull(dataStore);
        this.reladomoTreeGraphqlConverter = Objects.requireNonNull(reladomoTreeGraphqlConverter);
        this.finder = this.dataStore.getRelatedFinder((Classifier)klass);
    }

    public Object get(DataFetchingEnvironment environment) throws Exception {
        Map arguments = environment.getArguments();
        String inputOperation = (String)arguments.get("operation");
        com.gs.fw.common.mithra.finder.Operation operation = this.compileOperation(this.finder, inputOperation);
        MithraList result = this.finder.findMany((Operation)operation);
        DataFetchingFieldSelectionSet selectionSet = environment.getSelectionSet();
        RootReladomoTreeNode rootReladomoTreeNode = this.reladomoTreeGraphqlConverter.convert(this.klass, selectionSet);
        ReladomoTreeNodeDeepFetcherListener deepFetcherListener = new ReladomoTreeNodeDeepFetcherListener(this.dataStore, (DomainList)result, this.klass);
        rootReladomoTreeNode.walk((ReladomoTreeNodeListener)deepFetcherListener);
        ReladomoTreeObjectToDTOSerializerListener serializerVisitor = new ReladomoTreeObjectToDTOSerializerListener(this.dataStore, (DomainList)result, this.klass);
        rootReladomoTreeNode.toManyAwareWalk((ReladomoTreeNodeToManyAwareListener)serializerVisitor);
        return serializerVisitor.getResult();
    }

    private com.gs.fw.common.mithra.finder.Operation compileOperation(RelatedFinder<?> relatedFinder, String inputOperation) {
        try {
            ReladomoOperationCompiler compiler = new ReladomoOperationCompiler();
            return compiler.compile(relatedFinder, inputOperation);
        }
        catch (RuntimeException e) {
            throw new LiftwizardGraphQLException(e.getMessage(), Lists.immutable.with((Object)inputOperation), e);
        }
    }
}

