/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.dropwizard.bundle.graphql;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.CaseFormat;
import com.smoketurner.dropwizard.graphql.CachingPreparsedDocumentProvider;
import com.smoketurner.dropwizard.graphql.GraphQLBundle;
import com.smoketurner.dropwizard.graphql.GraphQLFactory;
import cool.klass.data.store.reladomo.ReladomoDataStore;
import cool.klass.dropwizard.bundle.graphql.AllDataFetcher;
import cool.klass.dropwizard.bundle.graphql.ByFinderDataFetcher;
import cool.klass.dropwizard.bundle.graphql.ByKeyDataFetcher;
import cool.klass.dropwizard.bundle.graphql.ByOperationDataFetcher;
import cool.klass.dropwizard.bundle.graphql.ConfiguredGraphQLHttpServlet;
import cool.klass.dropwizard.bundle.graphql.KlassGraphQLErrorHandler;
import cool.klass.dropwizard.bundle.graphql.KlassTypeResolver;
import cool.klass.dropwizard.configuration.data.store.DataStoreFactoryProvider;
import cool.klass.dropwizard.configuration.domain.model.loader.DomainModelFactoryProvider;
import cool.klass.model.meta.domain.api.Classifier;
import cool.klass.model.meta.domain.api.DomainModel;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.reladomo.tree.converter.graphql.ReladomoTreeGraphqlConverter;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.kickstart.execution.GraphQLQueryInvoker;
import graphql.kickstart.execution.error.GraphQLErrorHandler;
import graphql.kickstart.servlet.GraphQLConfiguration;
import graphql.scalars.java.JavaPrimitives;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLSchema;
import graphql.schema.TypeResolver;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.TypeRuntimeWiring;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.assets.AssetsBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.liftwizard.dropwizard.configuration.graphql.GraphQLFactoryProvider;
import io.liftwizard.graphql.instrumentation.logging.LiftwizardGraphQLLoggingInstrumentation;
import io.liftwizard.graphql.instrumentation.metrics.LiftwizardGraphQLMetricsInstrumentation;
import io.liftwizard.graphql.scalar.temporal.GraphQLLocalDateScalar;
import io.liftwizard.graphql.scalar.temporal.GraphQLTemporalScalar;
import java.io.Serializable;
import java.time.Clock;
import java.util.List;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletRegistration;
import org.atteo.evo.inflector.English;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.list.fixed.ArrayAdapter;
import org.slf4j.MDC;

public class KlassGraphQLBundle<T extends Configuration & DomainModelFactoryProvider>
extends GraphQLBundle<T> {
    private MetricRegistry metricRegistry;
    private Environment environment;

    public void initialize(@Nonnull Bootstrap<?> bootstrap) {
        try (MDC.MDCCloseable mdc = MDC.putCloseable((String)"liftwizard.bundle", (String)((Object)((Object)this)).getClass().getSimpleName());){
            this.initializeWithMdc(bootstrap);
        }
    }

    private void initializeWithMdc(@Nonnull Bootstrap<?> bootstrap) {
        this.metricRegistry = bootstrap.getMetricRegistry();
        bootstrap.addBundle((ConfiguredBundle)new AssetsBundle("/graphiql", "/graphiql", "index.htm", "graphiql"));
        bootstrap.addBundle((ConfiguredBundle)new AssetsBundle("/assets", "/graphql-playground", "index.htm", "graphql-playground"));
    }

    public void run(T configuration, Environment environment) throws Exception {
        this.environment = environment;
        GraphQLFactory factory = this.getGraphQLFactory(configuration);
        CachingPreparsedDocumentProvider provider = new CachingPreparsedDocumentProvider(factory.getQueryCache(), environment.metrics());
        GraphQLSchema schema = factory.build();
        GraphQLQueryInvoker queryInvoker = GraphQLQueryInvoker.newBuilder().withPreparsedDocumentProvider((PreparsedDocumentProvider)provider).withInstrumentation((Instrumentation)factory.getInstrumentations()).build();
        GraphQLObjectMapper graphQLObjectMapper = GraphQLObjectMapper.newBuilder().withGraphQLErrorHandler((GraphQLErrorHandler)new KlassGraphQLErrorHandler()).build();
        GraphQLConfiguration config = GraphQLConfiguration.with((GraphQLSchema)schema).with(queryInvoker).with(graphQLObjectMapper).build();
        ConfiguredGraphQLHttpServlet servlet = new ConfiguredGraphQLHttpServlet(config);
        ServletRegistration.Dynamic servletRegistration = environment.servlets().addServlet("graphql", (Servlet)servlet);
        servletRegistration.setAsyncSupported(false);
        servletRegistration.addMapping(new String[]{"/graphql", "/schema.json"});
    }

    @Nonnull
    public GraphQLFactory getGraphQLFactory(@Nonnull T configuration) {
        GraphQLFactory factory = ((GraphQLFactoryProvider)configuration).getGraphQLFactory();
        Clock clock = Clock.systemUTC();
        LiftwizardGraphQLMetricsInstrumentation metricsInstrumentation = new LiftwizardGraphQLMetricsInstrumentation(this.metricRegistry, clock);
        LiftwizardGraphQLLoggingInstrumentation loggingInstrumentation = new LiftwizardGraphQLLoggingInstrumentation();
        List<LiftwizardGraphQLLoggingInstrumentation> instrumentations = List.of(metricsInstrumentation, loggingInstrumentation);
        factory.setInstrumentations(instrumentations);
        ObjectMapper objectMapper = this.environment.getObjectMapper();
        DomainModel domainModel = ((DomainModelFactoryProvider)configuration).getDomainModelFactory().createDomainModel(objectMapper);
        ReladomoDataStore dataStore = (ReladomoDataStore)((DataStoreFactoryProvider)configuration).getDataStoreFactory().createDataStore();
        RuntimeWiring.Builder builder = RuntimeWiring.newRuntimeWiring();
        builder.scalar(GraphQLTemporalScalar.INSTANT_INSTANCE).scalar(GraphQLTemporalScalar.TEMPORAL_INSTANT_INSTANCE).scalar(GraphQLTemporalScalar.TEMPORAL_RANGE_INSTANCE).scalar(JavaPrimitives.GraphQLLong).scalar(GraphQLLocalDateScalar.INSTANCE);
        TypeRuntimeWiring.Builder queryTypeBuilder = this.getQueryTypeBuilder(domainModel, dataStore, new ReladomoTreeGraphqlConverter(domainModel));
        builder.type(queryTypeBuilder);
        domainModel.getClasses().select(Classifier::isAbstract).collect(this::getTypeResolver).each(arg_0 -> ((RuntimeWiring.Builder)builder).type(arg_0));
        RuntimeWiring runtimeWiring = builder.build();
        factory.setRuntimeWiring(runtimeWiring);
        return factory;
    }

    @Nonnull
    private TypeRuntimeWiring.Builder getQueryTypeBuilder(DomainModel domainModel, ReladomoDataStore dataStore, ReladomoTreeGraphqlConverter reladomoTreeGraphqlConverter) {
        TypeRuntimeWiring.Builder queryTypeBuilder = new TypeRuntimeWiring.Builder();
        queryTypeBuilder.typeName("Query");
        this.handleQueryAll(queryTypeBuilder, domainModel, dataStore, reladomoTreeGraphqlConverter);
        this.handleQueryByKey(queryTypeBuilder, domainModel, dataStore, reladomoTreeGraphqlConverter);
        this.handleQueryByOperation(queryTypeBuilder, domainModel, dataStore, reladomoTreeGraphqlConverter);
        this.handleQueryByFinder(queryTypeBuilder, domainModel, dataStore, reladomoTreeGraphqlConverter);
        return queryTypeBuilder;
    }

    private void handleQueryAll(TypeRuntimeWiring.Builder queryTypeBuilder, DomainModel domainModel, ReladomoDataStore dataStore, ReladomoTreeGraphqlConverter reladomoTreeGraphqlConverter) {
        domainModel.getClasses().each((Procedure & Serializable)eachKlass -> this.handleQueryAll(queryTypeBuilder, dataStore, reladomoTreeGraphqlConverter, (Klass)eachKlass));
    }

    private void handleQueryAll(TypeRuntimeWiring.Builder queryTypeBuilder, ReladomoDataStore dataStore, ReladomoTreeGraphqlConverter reladomoTreeGraphqlConverter, Klass klass) {
        String propertyName = this.getPropertyName((Classifier)klass);
        AllDataFetcher allDataFetcher = new AllDataFetcher(klass, dataStore, reladomoTreeGraphqlConverter);
        queryTypeBuilder.dataFetcher(propertyName, (DataFetcher)allDataFetcher);
    }

    private String getPropertyName(Classifier classifier) {
        String classifierName = classifier.getName();
        String lowerUnderscore = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, classifierName);
        ArrayAdapter splits = ArrayAdapter.adapt((Object[])lowerUnderscore.split("_"));
        return splits.collectWithIndex((arg_0, arg_1) -> this.lambda$getPropertyName$a692d3dd$1((MutableList)splits, arg_0, arg_1)).makeString("");
    }

    private String capitalizeSplit(String eachSplit, int index, int splitsSize) {
        return this.getCapitalized(index, this.getPluralized(index, splitsSize, eachSplit));
    }

    private String getPluralized(int index, int splitsSize, String eachSplit) {
        return index == splitsSize - 1 ? English.plural((String)eachSplit) : eachSplit;
    }

    private String getCapitalized(int index, String eachSplit) {
        return index != 0 ? CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, eachSplit) : eachSplit;
    }

    private void handleQueryByKey(TypeRuntimeWiring.Builder queryTypeBuilder, DomainModel domainModel, ReladomoDataStore dataStore, ReladomoTreeGraphqlConverter reladomoTreeGraphqlConverter) {
        domainModel.getClasses().each((Procedure & Serializable)eachKlass -> this.handleQueryByKey(queryTypeBuilder, dataStore, reladomoTreeGraphqlConverter, (Klass)eachKlass));
    }

    private void handleQueryByKey(TypeRuntimeWiring.Builder queryTypeBuilder, ReladomoDataStore dataStore, ReladomoTreeGraphqlConverter reladomoTreeGraphqlConverter, Klass klass) {
        String propertyName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, klass.getName());
        ByKeyDataFetcher byKeyDataFetcher = new ByKeyDataFetcher(klass, dataStore, reladomoTreeGraphqlConverter);
        queryTypeBuilder.dataFetcher(propertyName, (DataFetcher)byKeyDataFetcher);
    }

    private void handleQueryByOperation(TypeRuntimeWiring.Builder queryTypeBuilder, DomainModel domainModel, ReladomoDataStore dataStore, ReladomoTreeGraphqlConverter reladomoTreeGraphqlConverter) {
        domainModel.getClasses().each((Procedure & Serializable)eachKlass -> this.handleQueryByOperation(queryTypeBuilder, dataStore, reladomoTreeGraphqlConverter, (Klass)eachKlass));
    }

    private void handleQueryByOperation(TypeRuntimeWiring.Builder queryTypeBuilder, ReladomoDataStore dataStore, ReladomoTreeGraphqlConverter reladomoTreeGraphqlConverter, Klass klass) {
        String propertyName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, klass.getName()) + "ByOperation";
        ByOperationDataFetcher byOperationDataFetcher = new ByOperationDataFetcher(klass, dataStore, reladomoTreeGraphqlConverter);
        queryTypeBuilder.dataFetcher(propertyName, (DataFetcher)byOperationDataFetcher);
    }

    private void handleQueryByFinder(TypeRuntimeWiring.Builder queryTypeBuilder, DomainModel domainModel, ReladomoDataStore dataStore, ReladomoTreeGraphqlConverter reladomoTreeGraphqlConverter) {
        domainModel.getClasses().each((Procedure & Serializable)eachKlass -> this.handleQueryByFinder(queryTypeBuilder, dataStore, reladomoTreeGraphqlConverter, (Klass)eachKlass));
    }

    private void handleQueryByFinder(TypeRuntimeWiring.Builder queryTypeBuilder, ReladomoDataStore dataStore, ReladomoTreeGraphqlConverter reladomoTreeGraphqlConverter, Klass klass) {
        String propertyName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, klass.getName()) + "ByFinder";
        ByFinderDataFetcher byFinderDataFetcher = new ByFinderDataFetcher(klass, dataStore, reladomoTreeGraphqlConverter);
        queryTypeBuilder.dataFetcher(propertyName, (DataFetcher)byFinderDataFetcher);
    }

    private TypeRuntimeWiring.Builder getTypeResolver(Klass klass) {
        TypeRuntimeWiring.Builder typeBuilder = new TypeRuntimeWiring.Builder();
        typeBuilder.typeName(klass.getName());
        typeBuilder.typeResolver((TypeResolver)new KlassTypeResolver(klass));
        return typeBuilder;
    }

    private /* synthetic */ String lambda$getPropertyName$a692d3dd$1(MutableList splits, String eachSplit, int index) {
        return this.capitalizeSplit(eachSplit, index, splits.size());
    }
}

