/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.annotation;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.impl.list.fixed.ArrayAdapter;
import org.fusesource.jansi.Ansi;

public abstract class AbstractContextString {
    private final int line;
    @Nonnull
    private final String string;

    protected AbstractContextString(int line, @Nonnull String string) {
        this.line = line;
        this.string = Objects.requireNonNull(string);
    }

    private static String padLeft(String string, int width) {
        return String.format("%" + width + "s\u2551", string);
    }

    public int getLine() {
        return this.line;
    }

    public String toString(int lineNumberWidth) {
        ArrayAdapter strings = ArrayAdapter.adapt((Object[])this.string.split("\n"));
        return strings.collectWithIndex((ObjectIntToObjectFunction & Serializable)(string, index) -> this.toString((String)string, index, lineNumberWidth)).makeString("\n");
    }

    private String toString(String string, int offset, int lineNumberWidth) {
        String lineNumberString = this.getLineNumberString(this.line + offset);
        String paddedLineNumberString = AbstractContextString.padLeft(lineNumberString, lineNumberWidth);
        return Ansi.ansi().fgDefault().a(paddedLineNumberString).a(" ").a(string).toString();
    }

    public String toString() {
        return this.toString(4);
    }

    @Nonnull
    protected abstract String getLineNumberString(int var1);
}

