/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.annotation;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.annotation.AbstractCompilerAnnotation;
import cool.klass.model.converter.compiler.annotation.AnnotationSeverity;
import cool.klass.model.converter.compiler.annotation.CauseCompilerAnnotation;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.syntax.highlighter.ansi.AnsiTokenColorizer;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.tuple.Pair;
import org.fusesource.jansi.Ansi;

public class RootCompilerAnnotation
extends AbstractCompilerAnnotation
implements Comparable<RootCompilerAnnotation> {
    private static final Comparator<RootCompilerAnnotation> COMPILER_ANNOTATION_COMPARATOR = Comparator.comparing(AbstractCompilerAnnotation::getSeverity).thenComparingInt(each -> each.getCompilationUnit().getOrdinal()).thenComparingInt(AbstractCompilerAnnotation::getLine).thenComparingInt(AbstractCompilerAnnotation::getCharPositionInLine);
    @Nonnull
    private final String annotationCode;
    @Nonnull
    private final String message;

    public RootCompilerAnnotation(@Nonnull CompilationUnit compilationUnit, @Nonnull Optional<CauseCompilerAnnotation> macroCause, @Nonnull ImmutableList<ParserRuleContext> offendingContexts, @Nonnull ImmutableList<IAntlrElement> sourceContexts, @Nonnull String annotationCode, @Nonnull String message, @Nonnull AnsiTokenColorizer ansiTokenColorizer, @Nonnull AnnotationSeverity severity) {
        super(compilationUnit, macroCause, offendingContexts, sourceContexts, ansiTokenColorizer, severity);
        this.annotationCode = Objects.requireNonNull(annotationCode);
        this.message = Objects.requireNonNull(message);
    }

    @Nonnull
    public String getAnnotationCode() {
        return this.annotationCode;
    }

    @Override
    public int compareTo(@Nonnull RootCompilerAnnotation other) {
        return COMPILER_ANNOTATION_COMPARATOR.compare(this, other);
    }

    @Nonnull
    public String toString() {
        String contextString = this.getContextString();
        String locationMessage = this.getOptionalLocationMessage();
        String causeString = this.getCauseString();
        String severityColor = this.severity == AnnotationSeverity.ERROR ? "red" : "yellow";
        String severityName = this.severity == AnnotationSeverity.ERROR ? "Error" : "Warning";
        String format = "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 @|magenta %s|@ \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n@|%s %s: %s|@\n\nAt %s\n\n%s%s%s\n\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n";
        String ansi = String.format(format, this.annotationCode, severityColor, severityName, this.message, this.getShortLocationString(), contextString, locationMessage, causeString);
        return Ansi.ansi().render(ansi).toString();
    }

    @Override
    @Nonnull
    protected Ansi.Color getCaretColor() {
        return switch (this.severity) {
            default -> throw new IncompatibleClassChangeError();
            case AnnotationSeverity.ERROR -> Ansi.Color.RED;
            case AnnotationSeverity.WARNING -> Ansi.Color.YELLOW;
        };
    }

    @Override
    public String toGitHubAnnotation() {
        Pair<Token, Token> firstAndLastToken = this.getFirstAndLastToken();
        Token startToken = (Token)firstAndLastToken.getOne();
        Token endToken = (Token)firstAndLastToken.getTwo();
        String sourceName = this.compilationUnit.getSourceName();
        return "::%s file=%s,line=%d,endLine=%d,col=%d,endColumn=%d,title=%s::%s".formatted(this.getSeverityString(), sourceName, startToken.getLine(), endToken.getLine(), startToken.getCharPositionInLine(), endToken.getCharPositionInLine(), this.annotationCode, this.message);
    }

    @Nonnull
    protected String getSeverityString() {
        return switch (this.severity) {
            default -> throw new IncompatibleClassChangeError();
            case AnnotationSeverity.ERROR -> "error";
            case AnnotationSeverity.WARNING -> "warning";
        };
    }
}

