/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.phase;

import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.AntlrDomainModel;
import cool.klass.model.meta.grammar.KlassBaseListener;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class PossibleJoinCriteriaListener
extends KlassBaseListener {
    @Nonnull
    private final AntlrDomainModel domainModel;
    @Nonnull
    private final AntlrClass targetType;
    private boolean allEqualityOperators = true;
    private boolean allOperatorsCrossTypes = true;
    private boolean allMemberReferencesAreDirect = true;
    private boolean allTypeMembersMatch = true;
    private boolean allReferencesResolve = true;

    public PossibleJoinCriteriaListener(@Nonnull AntlrDomainModel domainModel, @Nonnull AntlrClass targetType) {
        this.domainModel = Objects.requireNonNull(domainModel);
        this.targetType = Objects.requireNonNull(targetType);
    }

    public boolean hasForeignKeys() {
        return this.allEqualityOperators && this.allOperatorsCrossTypes && this.allMemberReferencesAreDirect && this.allTypeMembersMatch && this.allReferencesResolve;
    }

    public void enterCriteriaEdgePoint(@Nonnull KlassParser.CriteriaEdgePointContext ctx) {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getSimpleName() + ".enterCriteriaEdgePoint() not implemented yet");
    }

    public void enterCriteriaNative(@Nonnull KlassParser.CriteriaNativeContext ctx) {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getSimpleName() + ".enterCriteriaNative() not implemented yet");
    }

    public void enterCriteriaAll(@Nonnull KlassParser.CriteriaAllContext ctx) {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getSimpleName() + ".enterCriteriaAll() not implemented yet");
    }

    public void enterCriteriaOperator(@Nonnull KlassParser.CriteriaOperatorContext ctx) {
        boolean noTypeReference;
        super.enterCriteriaOperator(ctx);
        if (ctx.operator().equalityOperator() == null) {
            this.allEqualityOperators = false;
        }
        KlassParser.ExpressionValueContext source = ctx.source;
        KlassParser.ExpressionValueContext target = ctx.target;
        boolean noThisReference = source.thisMemberReferencePath() == null && target.thisMemberReferencePath() == null;
        boolean bl = noTypeReference = source.typeMemberReferencePath() == null && target.typeMemberReferencePath() == null;
        if (noThisReference || noTypeReference) {
            this.allOperatorsCrossTypes = false;
        }
    }

    public void enterCriteriaExpressionOr(@Nonnull KlassParser.CriteriaExpressionOrContext ctx) {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getSimpleName() + ".enterCriteriaExpressionOr() not implemented yet");
    }

    public void enterTypeMemberReferencePath(@Nonnull KlassParser.TypeMemberReferencePathContext ctx) {
        super.enterTypeMemberReferencePath(ctx);
        KlassParser.ClassReferenceContext classReferenceContext = ctx.classReference();
        List associationEndReferenceContexts = ctx.associationEndReference();
        AntlrClass klass = this.domainModel.getClassByName(classReferenceContext.identifier().getText());
        if (!associationEndReferenceContexts.isEmpty()) {
            this.allMemberReferencesAreDirect = false;
        } else if (klass != this.targetType) {
            this.allTypeMembersMatch = false;
        } else if (klass == AntlrClass.NOT_FOUND || klass == AntlrClass.AMBIGUOUS) {
            this.allReferencesResolve = false;
        }
    }

    public void enterLiteral(@Nonnull KlassParser.LiteralContext ctx) {
        super.enterLiteral(ctx);
    }
}

