/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.phase;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import cool.klass.model.converter.compiler.CompilerState;
import cool.klass.model.converter.compiler.phase.AbstractCompilerPhase;
import cool.klass.model.converter.compiler.phase.RelationshipPhase;
import cool.klass.model.converter.compiler.state.AntlrAssociation;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.property.AntlrAssociationEnd;
import cool.klass.model.converter.compiler.state.property.AntlrDataTypeProperty;
import cool.klass.model.meta.grammar.KlassParser;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.list.ImmutableList;

public class RelationshipInferencePhase
extends AbstractCompilerPhase {
    private static final Converter<String, String> LOWER_CAMEL_TO_UPPER_CAMEL = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_CAMEL);
    private static final Converter<String, String> UPPER_TO_LOWER_CAMEL = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL);

    public RelationshipInferencePhase(@Nonnull CompilerState compilerState) {
        super(compilerState);
    }

    @Override
    @Nonnull
    public String getName() {
        return "Association relationship";
    }

    @Override
    public void exitAssociationBody(KlassParser.AssociationBodyContext ctx) {
        this.runCompilerMacro(ctx);
        super.exitAssociationBody(ctx);
    }

    private void runCompilerMacro(KlassParser.AssociationBodyContext inPlaceContext) {
        KlassParser.RelationshipContext relationship = inPlaceContext.relationship();
        if (relationship != null) {
            return;
        }
        AntlrAssociation association = this.compilerState.getCompilerWalk().getAssociation();
        if (association.isManyToMany()) {
            return;
        }
        AntlrAssociationEnd sourceEnd = association.getSourceEnd();
        AntlrAssociationEnd targetEnd = association.getTargetEnd();
        if (targetEnd.isToOne() && sourceEnd.isToMany()) {
            this.handleSourceAssociationEnd(inPlaceContext, sourceEnd);
        } else if (sourceEnd.isToOne() && targetEnd.isToMany()) {
            this.handleTargetAssociationEnd(inPlaceContext, targetEnd);
        } else if (sourceEnd.isToOneOptional() && targetEnd.isToOneRequired()) {
            this.handleSourceAssociationEnd(inPlaceContext, sourceEnd);
        } else if (targetEnd.isToOneOptional() && sourceEnd.isToOneRequired()) {
            this.handleTargetAssociationEnd(inPlaceContext, targetEnd);
        } else {
            throw new IllegalStateException("Unhandled association end combination: " + association);
        }
    }

    private void handleSourceAssociationEnd(KlassParser.AssociationBodyContext inPlaceContext, AntlrAssociationEnd associationEnd) {
        AntlrClass oppositeType = associationEnd.getOpposite().getType();
        ImmutableList<AntlrDataTypeProperty<?>> allKeyProperties = oppositeType.getAllKeyProperties();
        if (allKeyProperties.isEmpty()) {
            return;
        }
        String sourceCodeText = allKeyProperties.collect((Function & Serializable)each -> "this.%s%s == %s.%s".formatted(UPPER_TO_LOWER_CAMEL.convert((Object)oppositeType.getName()), LOWER_CAMEL_TO_UPPER_CAMEL.convert((Object)each.getName()), oppositeType.getName(), each.getName())).makeString("relationship ", " && ", "");
        this.runInPlaceCompilerMacro(inPlaceContext, sourceCodeText);
    }

    private void handleTargetAssociationEnd(KlassParser.AssociationBodyContext inPlaceContext, AntlrAssociationEnd associationEnd) {
        AntlrClass oppositeType = associationEnd.getOpposite().getType();
        ImmutableList<AntlrDataTypeProperty<?>> allKeyProperties = oppositeType.getAllKeyProperties();
        if (allKeyProperties.isEmpty()) {
            return;
        }
        String sourceCodeText = allKeyProperties.collect((Function & Serializable)each -> "this.%s == %s.%s%s".formatted(each.getName(), associationEnd.getType().getName(), UPPER_TO_LOWER_CAMEL.convert((Object)oppositeType.getName()), LOWER_CAMEL_TO_UPPER_CAMEL.convert((Object)each.getName()))).makeString("relationship ", " && ", "");
        this.runInPlaceCompilerMacro(inPlaceContext, sourceCodeText);
    }

    private void runInPlaceCompilerMacro(KlassParser.AssociationBodyContext inPlaceContext, @Nonnull String sourceCodeText) {
        AntlrAssociation association = this.compilerState.getCompilerWalk().getAssociation();
        RelationshipPhase compilerPhase = new RelationshipPhase(this.compilerState);
        this.compilerState.runInPlaceCompilerMacro(association, this, sourceCodeText, (Function<KlassParser, ? extends ParserRuleContext>)((Function & Serializable)KlassParser::relationship), (ParserRuleContext)inPlaceContext, new ParseTreeListener[]{compilerPhase});
    }
}

