/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.phase;

import cool.klass.model.converter.compiler.CompilerState;
import cool.klass.model.converter.compiler.phase.AbstractCompilerPhase;
import cool.klass.model.converter.compiler.phase.ServiceCriteriaPhase;
import cool.klass.model.converter.compiler.state.service.AntlrService;
import cool.klass.model.meta.domain.api.service.Verb;
import cool.klass.model.meta.grammar.KlassParser;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.eclipse.collections.api.block.function.Function;

public class ServiceCriteriaInferencePhase
extends AbstractCompilerPhase {
    public ServiceCriteriaInferencePhase(@Nonnull CompilerState compilerState) {
        super(compilerState);
    }

    @Override
    @Nonnull
    public String getName() {
        return "Service criteria";
    }

    @Override
    public void exitServiceBody(KlassParser.ServiceBodyContext ctx) {
        this.runCompilerMacro(ctx);
        super.exitServiceBody(ctx);
    }

    private void runCompilerMacro(KlassParser.ServiceBodyContext inPlaceContext) {
        AntlrService service = this.compilerState.getCompilerWalk().getService();
        if (service.getServiceCriterias().notEmpty() || service.getVerb().getVerb() != Verb.GET) {
            return;
        }
        String sourceCodeText = "            criteria    : all;\n";
        this.runCompilerMacro(inPlaceContext, sourceCodeText);
    }

    private void runCompilerMacro(KlassParser.ServiceBodyContext inPlaceContext, @Nonnull String sourceCodeText) {
        AntlrService service = this.compilerState.getCompilerWalk().getService();
        ServiceCriteriaPhase compilerPhase = new ServiceCriteriaPhase(this.compilerState);
        this.compilerState.runInPlaceCompilerMacro(service, this, sourceCodeText, (Function<KlassParser, ? extends ParserRuleContext>)((Function & Serializable)KlassParser::serviceCriteriaDeclaration), (ParserRuleContext)inPlaceContext, new ParseTreeListener[]{compilerPhase});
    }
}

