/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state;

import cool.klass.model.converter.compiler.annotation.AnnotationSeverity;
import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.state.AntlrClassifier;
import cool.klass.model.converter.compiler.state.AntlrCompilationUnit;
import cool.klass.model.converter.compiler.state.AntlrInterface;
import cool.klass.model.converter.compiler.state.AntlrNamedElement;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.property.AntlrAssociationEnd;
import cool.klass.model.converter.compiler.state.property.AntlrAssociationEndSignature;
import cool.klass.model.converter.compiler.state.property.AntlrDataTypeProperty;
import cool.klass.model.converter.compiler.state.property.AntlrEnumerationProperty;
import cool.klass.model.converter.compiler.state.property.AntlrModifier;
import cool.klass.model.converter.compiler.state.property.AntlrParameterizedProperty;
import cool.klass.model.converter.compiler.state.property.AntlrProperty;
import cool.klass.model.converter.compiler.state.property.AntlrReferenceProperty;
import cool.klass.model.meta.domain.KlassImpl;
import cool.klass.model.meta.grammar.KlassParser;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.factory.list.ImmutableListFactory;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableOrderedMap;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.map.ordered.mutable.OrderedMapAdapter;

public class AntlrClass
extends AntlrClassifier {
    public static final AntlrClass AMBIGUOUS = new AntlrClass(new KlassParser.ClassDeclarationContext(AMBIGUOUS_PARENT, -1), AntlrCompilationUnit.AMBIGUOUS, -1, AMBIGUOUS_IDENTIFIER_CONTEXT, false){

        @Override
        public String toString() {
            return AntlrClass.class.getSimpleName() + ".AMBIGUOUS";
        }

        @Override
        public void enterDataTypeProperty(@Nonnull AntlrDataTypeProperty<?> antlrDataTypeProperty) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".enterDataTypeProperty() not implemented yet");
        }

        @Override
        public void enterAssociationEnd(@Nonnull AntlrAssociationEnd antlrAssociationEnd) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".enterAssociationEnd() not implemented yet");
        }

        @Override
        public void enterParameterizedProperty(@Nonnull AntlrParameterizedProperty parameterizedProperty) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".enterParameterizedProperty() not implemented yet");
        }
    };
    public static final AntlrClass NOT_FOUND = new AntlrClass(new KlassParser.ClassDeclarationContext(NOT_FOUND_PARENT, -1), AntlrCompilationUnit.NOT_FOUND, -1, NOT_FOUND_IDENTIFIER_CONTEXT, false){

        @Override
        public String toString() {
            return AntlrClass.class.getSimpleName() + ".NOT_FOUND";
        }

        @Override
        public void enterDataTypeProperty(@Nonnull AntlrDataTypeProperty<?> antlrDataTypeProperty) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".enterDataTypeProperty() not implemented yet");
        }

        @Override
        public void enterAssociationEnd(@Nonnull AntlrAssociationEnd antlrAssociationEnd) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".enterAssociationEnd() not implemented yet");
        }

        @Override
        public void enterParameterizedProperty(@Nonnull AntlrParameterizedProperty parameterizedProperty) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".enterParameterizedProperty() not implemented yet");
        }
    };
    private final MutableList<AntlrAssociationEnd> declaredAssociationEnds = Lists.mutable.empty();
    private final MutableOrderedMap<String, AntlrAssociationEnd> declaredAssociationEndsByName = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableList<AntlrParameterizedProperty> declaredParameterizedProperties = Lists.mutable.empty();
    private final MutableOrderedMap<String, AntlrParameterizedProperty> declaredParameterizedPropertiesByName = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableOrderedMap<KlassParser.ParameterizedPropertyContext, AntlrParameterizedProperty> declaredParameterizedPropertiesByContext = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final boolean isUser;
    private boolean isAbstract;
    private KlassImpl.KlassBuilder klassBuilder;
    @Nonnull
    private Optional<AntlrClass> superClass = Optional.empty();
    @Nonnull
    private final MutableList<AntlrClass> subClasses = Lists.mutable.empty();

    public AntlrClass(@Nonnull KlassParser.ClassDeclarationContext elementContext, @Nonnull AntlrCompilationUnit compilationUnitState, int ordinal, @Nonnull KlassParser.IdentifierContext nameContext, boolean isUser) {
        super((ParserRuleContext)elementContext, compilationUnitState, ordinal, nameContext);
        this.isUser = isUser;
    }

    public boolean isUser() {
        return this.isUser;
    }

    public ListIterable<AntlrAssociationEnd> getDeclaredAssociationEnds() {
        return this.declaredAssociationEnds.asUnmodifiable();
    }

    @Override
    protected ImmutableList<AntlrProperty> getInheritedProperties(@Nonnull MutableList<AntlrClassifier> visited) {
        ImmutableList superClassProperties = this.superClass.map(antlrClass -> antlrClass.getAllProperties(visited)).orElseGet(() -> ((ImmutableListFactory)Lists.immutable).empty());
        ImmutableList interfaceProperties = this.declaredInterfaces.flatCollectWith(AntlrClassifier::getAllProperties, visited).toImmutable();
        return superClassProperties.newWithAll((Iterable)interfaceProperties).distinctBy(AntlrNamedElement::getName);
    }

    @Override
    protected ImmutableList<AntlrDataTypeProperty<?>> getInheritedDataTypeProperties(@Nonnull MutableList<AntlrClassifier> visited) {
        ImmutableList superClassProperties = this.superClass.map(antlrClass -> antlrClass.getAllDataTypeProperties(visited)).orElseGet(() -> ((ImmutableListFactory)Lists.immutable).empty());
        ImmutableList interfaceProperties = this.declaredInterfaces.flatCollectWith(AntlrClassifier::getAllDataTypeProperties, visited).toImmutable();
        return superClassProperties.newWithAll((Iterable)interfaceProperties).distinctBy(AntlrNamedElement::getName);
    }

    @Override
    protected ImmutableList<AntlrModifier> getInheritedModifiers(@Nonnull MutableList<AntlrClassifier> visited) {
        ImmutableList superClassModifiers = this.superClass.map(antlrClass -> antlrClass.getAllModifiers(visited)).orElseGet(() -> ((ImmutableListFactory)Lists.immutable).empty());
        ImmutableList interfaceModifiers = this.declaredInterfaces.flatCollectWith(AntlrClassifier::getAllModifiers, visited).toImmutable();
        return superClassModifiers.newWithAll((Iterable)interfaceModifiers).distinctBy(AntlrModifier::getKeyword);
    }

    @Override
    public AntlrReferenceProperty<?> getReferencePropertyByName(@Nonnull String name) {
        AntlrReferenceProperty declaredProperty = (AntlrReferenceProperty)this.declaredReferencePropertiesByName.get((Object)name);
        if (declaredProperty != null) {
            return declaredProperty;
        }
        Optional<AntlrReferenceProperty> superClassProperty = this.superClass.map(superClass -> superClass.getReferencePropertyByName(name));
        if (superClassProperty.isPresent()) {
            return superClassProperty.get();
        }
        return (AntlrReferenceProperty)this.declaredInterfaces.asLazy().collectWith(AntlrInterface::getReferencePropertyByName, (Object)name).detectIfNone(Objects::nonNull, (Function0 & Serializable)() -> AntlrReferenceProperty.NOT_FOUND);
    }

    public void enterAssociationEnd(@Nonnull AntlrAssociationEnd antlrAssociationEnd) {
        this.declaredProperties.add((Object)antlrAssociationEnd);
        this.declaredAssociationEnds.add((Object)antlrAssociationEnd);
        this.declaredAssociationEndsByName.compute((Object)antlrAssociationEnd.getName(), (name, builder) -> builder == null ? antlrAssociationEnd : AntlrAssociationEnd.AMBIGUOUS);
        this.declaredReferenceProperties.add((Object)antlrAssociationEnd);
        this.declaredReferencePropertiesByName.compute((Object)antlrAssociationEnd.getName(), (name, builder) -> builder == null ? antlrAssociationEnd : AntlrAssociationEnd.AMBIGUOUS);
        AntlrReferenceProperty duplicate2 = (AntlrReferenceProperty)this.declaredReferencePropertiesByContext.put((Object)antlrAssociationEnd.getElementContext(), (Object)antlrAssociationEnd);
        if (duplicate2 != null) {
            throw new AssertionError();
        }
    }

    public void enterParameterizedProperty(@Nonnull AntlrParameterizedProperty parameterizedProperty) {
        this.declaredParameterizedProperties.add((Object)parameterizedProperty);
        this.declaredParameterizedPropertiesByName.compute((Object)parameterizedProperty.getName(), (name, builder) -> builder == null ? parameterizedProperty : AntlrParameterizedProperty.AMBIGUOUS);
        AntlrParameterizedProperty duplicate1 = (AntlrParameterizedProperty)this.declaredParameterizedPropertiesByContext.put((Object)parameterizedProperty.getElementContext(), (Object)parameterizedProperty);
        if (duplicate1 != null) {
            throw new AssertionError();
        }
    }

    public AntlrParameterizedProperty getParameterizedPropertyByContext(KlassParser.ParameterizedPropertyContext ctx) {
        return (AntlrParameterizedProperty)this.declaredParameterizedPropertiesByContext.get((Object)ctx);
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void enterExtendsDeclaration(@Nonnull AntlrClass superClass) {
        if (this.superClass.isPresent()) {
            throw new AssertionError();
        }
        this.superClass = Optional.of(superClass);
        superClass.subClasses.add((Object)this);
    }

    @Nonnull
    public KlassImpl.KlassBuilder getElementBuilder() {
        return Objects.requireNonNull(this.klassBuilder);
    }

    @Override
    public boolean implementsInterface(AntlrInterface iface) {
        if (super.implementsInterface(iface)) {
            return true;
        }
        return this.superClass.map(klass -> klass.implementsInterface(iface)).orElse(false);
    }

    public KlassImpl.KlassBuilder build1() {
        if (this.klassBuilder != null) {
            throw new IllegalStateException();
        }
        this.klassBuilder = new KlassImpl.KlassBuilder((KlassParser.ClassDeclarationContext)this.elementContext, this.getMacroElementBuilder(), this.getSourceCodeBuilder(), this.ordinal, this.getNameContext(), this.getPackageName(), this.isAbstract, this.isUser, this.isTransient());
        ImmutableList declaredModifiers = this.declaredModifiers.collect(AntlrModifier::build).toImmutable();
        this.klassBuilder.setDeclaredModifiers(declaredModifiers);
        ImmutableList declaredDataTypeProperties = this.declaredDataTypeProperties.collect(AntlrDataTypeProperty::build).toImmutable();
        this.klassBuilder.setDeclaredDataTypeProperties(declaredDataTypeProperties);
        return this.klassBuilder;
    }

    public void build2() {
        if (this.klassBuilder == null) {
            throw new IllegalStateException();
        }
        ImmutableList declaredAssociationEnds = this.declaredAssociationEnds.collect(AntlrAssociationEnd::getElementBuilder).toImmutable();
        this.klassBuilder.setDeclaredAssociationEnds(declaredAssociationEnds);
        ImmutableList declaredAssociationEndSignatures = this.declaredAssociationEndSignatures.collect(AntlrAssociationEndSignature::build).toImmutable();
        this.klassBuilder.setDeclaredAssociationEndSignatures(declaredAssociationEndSignatures);
        ImmutableList declaredReferenceProperties = this.declaredReferenceProperties.collect(AntlrReferenceProperty::getElementBuilder).toImmutable();
        this.klassBuilder.setDeclaredReferenceProperties(declaredReferenceProperties);
        ImmutableList declaredProperties = this.declaredProperties.collect(AntlrProperty::getElementBuilder).toImmutable();
        this.klassBuilder.setDeclaredProperties(declaredProperties);
        this.declaredDataTypeProperties.each(AntlrDataTypeProperty::build2);
        ImmutableList declaredInterfaces = this.declaredInterfaces.collect(AntlrInterface::getElementBuilder).toImmutable();
        this.klassBuilder.setDeclaredInterfaces(declaredInterfaces);
        Optional<KlassImpl.KlassBuilder> superClass = this.superClass.map(AntlrClass::getElementBuilder);
        this.klassBuilder.setSuperClass(superClass);
        ImmutableList subClasses = this.subClasses.collect(AntlrClass::getElementBuilder).toImmutable();
        this.klassBuilder.setSubClassBuilders(subClasses);
    }

    @Override
    public void reportNameErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        super.reportNameErrors(compilerAnnotationHolder);
        this.reportKeywordCollision(compilerAnnotationHolder);
        if (RELADOMO_TYPES.contains((Object)this.getName())) {
            String message = String.format("'%s' is a Reladomo type.", this.getName());
            compilerAnnotationHolder.add("ERR_REL_NME", message, this);
        }
        this.declaredDataTypeProperties.forEachWith(AntlrNamedElement::reportNameErrors, (Object)compilerAnnotationHolder);
        this.declaredParameterizedProperties.forEachWith(AntlrNamedElement::reportNameErrors, (Object)compilerAnnotationHolder);
        this.declaredAssociationEnds.forEachWith(AntlrNamedElement::reportNameErrors, (Object)compilerAnnotationHolder);
        this.declaredAssociationEndSignatures.forEachWith(AntlrNamedElement::reportNameErrors, (Object)compilerAnnotationHolder);
    }

    @Override
    public void reportErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        super.reportErrors(compilerAnnotationHolder);
        if (this.isUser) {
            this.reportMultiplePropertiesWithModifiers(compilerAnnotationHolder, this.declaredDataTypeProperties, "key", "userId");
        }
        this.reportMissingKeyProperty(compilerAnnotationHolder);
        this.reportSuperClassNotFound(compilerAnnotationHolder);
        this.reportExtendsConcrete(compilerAnnotationHolder);
        this.reportMultipleOppositesWithModifier(compilerAnnotationHolder, "version", AnnotationSeverity.ERROR);
        this.reportMultipleOppositesWithModifier(compilerAnnotationHolder, "owned", AnnotationSeverity.WARNING);
        this.reportVersionErrors(compilerAnnotationHolder);
        this.reportTransientInheritance(compilerAnnotationHolder);
        this.reportTransientIdProperties(compilerAnnotationHolder);
    }

    private void reportMultipleOppositesWithModifier(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder, @Nonnull String modifier, @Nonnull AnnotationSeverity severity) {
        MutableList associationEnds = this.declaredAssociationEnds.select((Predicate & Serializable)associationEnd -> associationEnd.getOpposite().getModifiers().anySatisfyWith(AntlrModifier::is, (Object)modifier));
        if (associationEnds.size() <= 1) {
            return;
        }
        for (AntlrAssociationEnd associationEnd2 : associationEnds) {
            associationEnd2.getOpposite().reportDuplicateOppositeWithModifier(compilerAnnotationHolder, this, modifier, severity);
        }
    }

    private void reportVersionErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        if (this.declaredReferenceProperties.anySatisfy(AntlrProperty::isVersion) && this.declaredAssociationEnds.anySatisfy(AntlrAssociationEnd::isVersioned)) {
            String message = String.format("Class '%s' is a version and has a version.", this.getName());
            compilerAnnotationHolder.add("ERR_VER_VER", message, this);
        }
    }

    private void reportMissingKeyProperty(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        if (!this.hasKeyProperty() && !this.hasIDProperty()) {
            String message = String.format("Class '%s' must have at least one key property.", this.getName());
            compilerAnnotationHolder.add("ERR_CLS_KEY", message, this);
        }
    }

    public void reportDuplicateUserClass(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        String message = String.format("Only one 'user' class is allowed. Found '%s'.", this.getName());
        compilerAnnotationHolder.add("ERR_DUP_USR", message, (IAntlrElement)this, this.nameContext);
    }

    private void reportSuperClassNotFound(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        if (this.superClass.equals(Optional.of(NOT_FOUND))) {
            KlassParser.ClassReferenceContext offendingToken = this.getElementContext().classHeader().extendsDeclaration().classReference();
            String message = String.format("Cannot find class '%s'.", offendingToken.getText());
            compilerAnnotationHolder.add("ERR_EXT_CLS", message, (IAntlrElement)this, (ParserRuleContext)offendingToken);
        }
    }

    private void reportExtendsConcrete(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        if (this.superClass.isEmpty() || this.superClass.equals(Optional.of(NOT_FOUND)) || this.superClass.equals(Optional.of(AMBIGUOUS))) {
            return;
        }
        if (!this.superClass.get().isAbstract) {
            KlassParser.ClassReferenceContext offendingToken = this.getElementContext().classHeader().extendsDeclaration().classReference();
            String message = String.format("Superclass must be abstract '%s'.", offendingToken.getText());
            compilerAnnotationHolder.add("ERR_EXT_CCT", message, (IAntlrElement)this, (ParserRuleContext)offendingToken);
        }
    }

    private void reportTransientInheritance(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        if (this.isTransient() || this.superClass.isEmpty() || !this.superClass.get().isTransient()) {
            return;
        }
        KlassParser.ClassReferenceContext offendingToken = this.getElementContext().classHeader().extendsDeclaration().classReference();
        String message = String.format("Must be transient to inherit from transient superclass '%s'.", offendingToken.getText());
        compilerAnnotationHolder.add("ERR_EXT_TNS", message, (IAntlrElement)this, (ParserRuleContext)offendingToken);
    }

    private void reportTransientIdProperties(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        if (!this.isTransient()) {
            return;
        }
        this.declaredDataTypeProperties.select(AntlrDataTypeProperty::isId).forEachWith(AntlrDataTypeProperty::reportTransientIdProperties, (Object)compilerAnnotationHolder);
    }

    @Override
    protected void reportCircularInheritance(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        if (this.hasCircularInheritance()) {
            KlassParser.ClassReferenceContext offendingToken = this.getElementContext().classHeader().extendsDeclaration().classReference();
            String message = String.format("Circular inheritance '%s'.", offendingToken.getText());
            compilerAnnotationHolder.add("ERR_EXT_SLF", message, (IAntlrElement)this, (ParserRuleContext)offendingToken);
        } else {
            this.reportForwardReference(compilerAnnotationHolder);
        }
    }

    @Override
    protected void reportForwardReference(CompilerAnnotationHolder compilerAnnotationHolder) {
        super.reportForwardReference(compilerAnnotationHolder);
        if (this.superClass.isEmpty()) {
            return;
        }
        AntlrClass klass = this.superClass.get();
        if (this.isForwardReference(klass)) {
            String message = String.format("Class '%s' is declared on line %d and has a forward reference to super class '%s' which is declared later in the source file '%s' on line %d.", this.getName(), this.getElementContext().getStart().getLine(), klass.getName(), this.getCompilationUnit().get().getSourceName(), klass.getElementContext().getStart().getLine());
            compilerAnnotationHolder.add("ERR_FWD_REF", message, (IAntlrElement)this, (ParserRuleContext)this.getElementContext().classHeader().extendsDeclaration().classReference());
        }
    }

    private boolean hasIDProperty() {
        return this.getAllDataTypeProperties().anySatisfy(AntlrDataTypeProperty::isId);
    }

    private boolean hasKeyProperty() {
        return this.getAllDataTypeProperties().anySatisfy(AntlrDataTypeProperty::isKey);
    }

    private boolean hasCircularInheritance() {
        return this.superClass.isPresent() && this.superClass.get().extendsClass(this, (MutableSet<AntlrClass>)Sets.mutable.empty());
    }

    private boolean extendsClass(@Nonnull AntlrClass antlrClass, @Nonnull MutableSet<AntlrClass> visitedClasses) {
        if (this.superClass.isEmpty()) {
            return false;
        }
        if (this.superClass.equals(Optional.of(antlrClass))) {
            return true;
        }
        if (visitedClasses.contains((Object)this)) {
            return false;
        }
        visitedClasses.add((Object)this);
        return this.superClass.get().extendsClass(antlrClass, visitedClasses);
    }

    @Override
    protected boolean isInterfaceRedundant(int index, @Nonnull AntlrInterface iface) {
        return this.superClass.isPresent() && this.superClass.get().implementsInterface(iface) || this.interfaceNotAtIndexImplements(index, iface);
    }

    @Override
    protected KlassParser.InterfaceReferenceContext getOffendingInterfaceReference(int index) {
        return (KlassParser.InterfaceReferenceContext)this.getElementContext().classHeader().implementsDeclaration().interfaceReference().get(index);
    }

    @Override
    public ImmutableBag<String> getDuplicateMemberNames() {
        return this.getDeclaredMemberNames().toBag().selectByOccurrences((IntPredicate & Serializable)occurrences -> occurrences > 1).toImmutable();
    }

    private ImmutableList<String> getDeclaredMemberNames() {
        MutableList topLevelNames = Lists.mutable.empty();
        this.getAllDataTypeProperties().collect(AntlrNamedElement::getName, (Collection)topLevelNames);
        this.declaredParameterizedProperties.collect(AntlrNamedElement::getName, (Collection)topLevelNames);
        this.declaredAssociationEnds.collect(AntlrNamedElement::getName, (Collection)topLevelNames);
        this.declaredAssociationEndSignatures.collect(AntlrNamedElement::getName, (Collection)topLevelNames);
        return topLevelNames.toImmutable();
    }

    public boolean isSubClassOf(AntlrClass klass) {
        if (this == klass) {
            return false;
        }
        if (this.superClass.isEmpty()) {
            return false;
        }
        AntlrClass superClass = this.superClass.get();
        if (superClass == klass) {
            return true;
        }
        return superClass.isSubClassOf(klass);
    }

    @Override
    public Optional<AntlrClass> getSuperClass() {
        return this.superClass;
    }

    @Nonnull
    public KlassParser.ClassDeclarationContext getElementContext() {
        return (KlassParser.ClassDeclarationContext)super.getElementContext();
    }

    public KlassParser.ClassBlockContext getBlockContext() {
        return this.getElementContext().classBlock();
    }

    @Override
    public AntlrDataTypeProperty<?> getDataTypePropertyByName(String name) {
        AntlrDataTypeProperty<?> superClassProperty;
        if (this.declaredDataTypePropertiesByName.containsKey((Object)name)) {
            return (AntlrDataTypeProperty)this.declaredDataTypePropertiesByName.get((Object)name);
        }
        if (this.superClass.isPresent() && (superClassProperty = this.superClass.get().getDataTypePropertyByName(name)) != AntlrEnumerationProperty.NOT_FOUND) {
            return superClassProperty;
        }
        return this.getInterfaceDataTypePropertyByName(name);
    }

    public AntlrAssociationEnd getAssociationEndByName(String name) {
        if (this.declaredAssociationEndsByName.containsKey((Object)name)) {
            return (AntlrAssociationEnd)this.declaredAssociationEndsByName.get((Object)name);
        }
        return this.superClass.map(superClass -> superClass.getAssociationEndByName(name)).orElse(AntlrAssociationEnd.NOT_FOUND);
    }

    public AntlrModifier getModifierByName(String name) {
        AntlrModifier superClassProperty;
        if (this.declaredModifiersByName.containsKey((Object)name)) {
            return (AntlrModifier)this.declaredModifiersByName.get((Object)name);
        }
        if (this.superClass.isPresent() && (superClassProperty = this.superClass.get().getModifierByName(name)) != AntlrModifier.NOT_FOUND) {
            return superClassProperty;
        }
        return this.getInterfaceClassifierModifierByName(name);
    }

    @Nonnull
    public KlassImpl.KlassBuilder getTypeGetter() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getTypeBuilder() not implemented yet");
    }

    public boolean isVersion() {
        return this.declaredDataTypeProperties.anySatisfy(AntlrProperty::isVersion);
    }
}

