/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.parser.AntlrUtils;
import cool.klass.model.converter.compiler.state.AntlrAssociation;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.AntlrClassifier;
import cool.klass.model.converter.compiler.state.AntlrCompilationUnit;
import cool.klass.model.converter.compiler.state.AntlrEnumeration;
import cool.klass.model.converter.compiler.state.AntlrInterface;
import cool.klass.model.converter.compiler.state.AntlrPrimitiveType;
import cool.klass.model.converter.compiler.state.AntlrTopLevelElement;
import cool.klass.model.converter.compiler.state.UnreferencedPrivatePropertiesCriteriaVisitor;
import cool.klass.model.converter.compiler.state.criteria.AntlrCriteria;
import cool.klass.model.converter.compiler.state.criteria.AntlrCriteriaVisitor;
import cool.klass.model.converter.compiler.state.projection.AntlrProjection;
import cool.klass.model.converter.compiler.state.property.AntlrAssociationEnd;
import cool.klass.model.converter.compiler.state.property.AntlrDataTypeProperty;
import cool.klass.model.converter.compiler.state.property.AntlrParameterizedProperty;
import cool.klass.model.converter.compiler.state.property.AntlrProperty;
import cool.klass.model.converter.compiler.state.service.AntlrService;
import cool.klass.model.converter.compiler.state.service.AntlrServiceCriteria;
import cool.klass.model.converter.compiler.state.service.AntlrServiceGroup;
import cool.klass.model.converter.compiler.state.service.url.AntlrUrl;
import cool.klass.model.meta.domain.DomainModelImpl;
import cool.klass.model.meta.grammar.KlassParser;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableOrderedMap;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.map.ordered.mutable.OrderedMapAdapter;

public class AntlrDomainModel {
    private final MutableList<AntlrCompilationUnit> compilationUnits = Lists.mutable.empty();
    private final MutableList<AntlrTopLevelElement> topLevelElements = Lists.mutable.empty();
    private final MutableList<AntlrEnumeration> enumerations = Lists.mutable.empty();
    private final MutableList<AntlrClassifier> classifiers = Lists.mutable.empty();
    private final MutableList<AntlrInterface> interfaces = Lists.mutable.empty();
    private final MutableList<AntlrClass> klasses = Lists.mutable.empty();
    private final MutableList<AntlrClass> userClasses = Lists.mutable.empty();
    private final MutableList<AntlrAssociation> associations = Lists.mutable.empty();
    private final MutableList<AntlrProjection> projections = Lists.mutable.empty();
    private final MutableList<AntlrServiceGroup> serviceGroups = Lists.mutable.empty();
    private final MutableOrderedMap<KlassParser.CompilationUnitContext, AntlrCompilationUnit> compilationUnitsByContext = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableOrderedMap<KlassParser.TopLevelDeclarationContext, AntlrTopLevelElement> topLevelElementsByContext = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableOrderedMap<KlassParser.TopLevelDeclarationContext, Integer> topLevelElementOrdinalsByContext = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableOrderedMap<KlassParser.EnumerationDeclarationContext, AntlrEnumeration> enumerationsByContext = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableOrderedMap<ParserRuleContext, AntlrClassifier> classifiersByContext = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableOrderedMap<KlassParser.InterfaceDeclarationContext, AntlrInterface> interfacesByContext = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableOrderedMap<KlassParser.ClassDeclarationContext, AntlrClass> classesByContext = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableOrderedMap<KlassParser.AssociationDeclarationContext, AntlrAssociation> associationsByContext = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableOrderedMap<KlassParser.ProjectionDeclarationContext, AntlrProjection> projectionsByContext = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableOrderedMap<KlassParser.ServiceGroupDeclarationContext, AntlrServiceGroup> serviceGroupsByContext = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableOrderedMap<String, AntlrEnumeration> enumerationsByName = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableOrderedMap<String, AntlrClassifier> classifiersByName = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableOrderedMap<String, AntlrInterface> interfacesByName = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableOrderedMap<String, AntlrClass> classesByName = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableOrderedMap<String, AntlrAssociation> associationsByName = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableOrderedMap<String, AntlrProjection> projectionsByName = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableOrderedMap<AntlrClass, AntlrServiceGroup> serviceGroupsByClass = OrderedMapAdapter.adapt(new LinkedHashMap());

    public Optional<AntlrClass> getUserClass() {
        return this.userClasses.size() == 1 ? this.userClasses.getFirstOptional() : Optional.empty();
    }

    public void enterTopLevelDeclaration(KlassParser.TopLevelDeclarationContext ctx) {
        Integer duplicate = (Integer)this.topLevelElementOrdinalsByContext.put((Object)ctx, (Object)(this.topLevelElementOrdinalsByContext.size() + 1));
        if (duplicate != null) {
            throw new AssertionError();
        }
    }

    public void exitCompilationUnit(@Nonnull AntlrCompilationUnit compilationUnit) {
        this.compilationUnits.add((Object)compilationUnit);
        AntlrCompilationUnit duplicateCompilationUnit = (AntlrCompilationUnit)this.compilationUnitsByContext.put((Object)compilationUnit.getElementContext(), (Object)compilationUnit);
        if (duplicateCompilationUnit != null) {
            throw new AssertionError();
        }
    }

    public void exitEnumerationDeclaration(@Nonnull AntlrEnumeration enumeration) {
        this.topLevelElements.add((Object)enumeration);
        this.enumerations.add((Object)enumeration);
        this.enumerationsByName.compute((Object)enumeration.getName(), (name, builder) -> builder == null ? enumeration : AntlrEnumeration.AMBIGUOUS);
        AntlrEnumeration duplicateEnumeration = (AntlrEnumeration)this.enumerationsByContext.put((Object)enumeration.getElementContext(), (Object)enumeration);
        if (duplicateEnumeration != null) {
            throw new AssertionError();
        }
        KlassParser.TopLevelDeclarationContext topLevelDeclarationContext = AntlrUtils.getParentOfType((ParserRuleContext)enumeration.getElementContext(), KlassParser.TopLevelDeclarationContext.class);
        AntlrTopLevelElement duplicateTopLevelElement = (AntlrTopLevelElement)this.topLevelElementsByContext.put((Object)topLevelDeclarationContext, (Object)enumeration);
        if (duplicateTopLevelElement != null) {
            throw new AssertionError();
        }
    }

    public void exitInterfaceDeclaration(@Nonnull AntlrInterface iface) {
        this.topLevelElements.add((Object)iface);
        this.classifiers.add((Object)iface);
        this.interfaces.add((Object)iface);
        this.classifiersByName.compute((Object)iface.getName(), (name, builder) -> builder == null ? iface : AntlrClassifier.AMBIGUOUS);
        this.interfacesByName.compute((Object)iface.getName(), (name, builder) -> builder == null ? iface : AntlrInterface.AMBIGUOUS);
        AntlrClassifier duplicateClassifier = (AntlrClassifier)this.classifiersByContext.put((Object)iface.getElementContext(), (Object)iface);
        if (duplicateClassifier != null) {
            throw new AssertionError();
        }
        AntlrInterface duplicateInterface = (AntlrInterface)this.interfacesByContext.put((Object)iface.getElementContext(), (Object)iface);
        if (duplicateInterface != null) {
            throw new AssertionError();
        }
        KlassParser.TopLevelDeclarationContext topLevelDeclarationContext = AntlrUtils.getParentOfType((ParserRuleContext)iface.getElementContext(), KlassParser.TopLevelDeclarationContext.class);
        AntlrTopLevelElement duplicateTopLevelElement = (AntlrTopLevelElement)this.topLevelElementsByContext.put((Object)topLevelDeclarationContext, (Object)iface);
        if (duplicateTopLevelElement != null) {
            throw new AssertionError();
        }
    }

    public void exitClassDeclaration(@Nonnull AntlrClass klass) {
        this.topLevelElements.add((Object)klass);
        this.classifiers.add((Object)klass);
        this.klasses.add((Object)klass);
        if (klass.isUser()) {
            this.userClasses.add((Object)klass);
        }
        this.classifiersByName.compute((Object)klass.getName(), (name, builder) -> builder == null ? klass : AntlrClassifier.AMBIGUOUS);
        this.classesByName.compute((Object)klass.getName(), (name, builder) -> builder == null ? klass : AntlrClass.AMBIGUOUS);
        AntlrClassifier duplicateClassifier = (AntlrClassifier)this.classifiersByContext.put((Object)klass.getElementContext(), (Object)klass);
        if (duplicateClassifier != null) {
            throw new AssertionError();
        }
        AntlrClass duplicateClass = (AntlrClass)this.classesByContext.put((Object)klass.getElementContext(), (Object)klass);
        if (duplicateClass != null) {
            throw new AssertionError();
        }
        KlassParser.TopLevelDeclarationContext topLevelDeclarationContext = AntlrUtils.getParentOfType((ParserRuleContext)klass.getElementContext(), KlassParser.TopLevelDeclarationContext.class);
        AntlrTopLevelElement duplicateTopLevelElement = (AntlrTopLevelElement)this.topLevelElementsByContext.put((Object)topLevelDeclarationContext, (Object)klass);
        if (duplicateTopLevelElement != null) {
            throw new AssertionError();
        }
    }

    public void exitAssociationDeclaration(@Nonnull AntlrAssociation association) {
        this.topLevelElements.add((Object)association);
        this.associations.add((Object)association);
        this.associationsByName.compute((Object)association.getName(), (name, builder) -> builder == null ? association : AntlrAssociation.AMBIGUOUS);
        AntlrAssociation duplicateAssociation = (AntlrAssociation)this.associationsByContext.put((Object)association.getElementContext(), (Object)association);
        if (duplicateAssociation != null) {
            throw new AssertionError();
        }
        KlassParser.TopLevelDeclarationContext topLevelDeclarationContext = AntlrUtils.getParentOfType((ParserRuleContext)association.getElementContext(), KlassParser.TopLevelDeclarationContext.class);
        AntlrTopLevelElement duplicateTopLevelElement = (AntlrTopLevelElement)this.topLevelElementsByContext.put((Object)topLevelDeclarationContext, (Object)association);
        if (duplicateTopLevelElement != null) {
            throw new AssertionError();
        }
    }

    public void exitProjectionDeclaration(@Nonnull AntlrProjection projection) {
        this.topLevelElements.add((Object)projection);
        this.projections.add((Object)projection);
        this.projectionsByName.compute((Object)projection.getName(), (name, builder) -> builder == null ? projection : AntlrProjection.AMBIGUOUS);
        AntlrProjection duplicateProjection = (AntlrProjection)this.projectionsByContext.put((Object)projection.getElementContext(), (Object)projection);
        if (duplicateProjection != null) {
            throw new AssertionError();
        }
        KlassParser.TopLevelDeclarationContext topLevelDeclarationContext = AntlrUtils.getParentOfType((ParserRuleContext)projection.getElementContext(), KlassParser.TopLevelDeclarationContext.class);
        AntlrTopLevelElement duplicateTopLevelElement = (AntlrTopLevelElement)this.topLevelElementsByContext.put((Object)topLevelDeclarationContext, (Object)projection);
        if (duplicateTopLevelElement != null) {
            throw new AssertionError();
        }
    }

    public void exitServiceGroupDeclaration(@Nonnull AntlrServiceGroup serviceGroup) {
        this.topLevelElements.add((Object)serviceGroup);
        this.serviceGroups.add((Object)serviceGroup);
        this.serviceGroupsByClass.compute((Object)serviceGroup.getKlass(), (name, builder) -> builder == null ? serviceGroup : AntlrServiceGroup.AMBIGUOUS);
        AntlrServiceGroup duplicateServiceGroup = (AntlrServiceGroup)this.serviceGroupsByContext.put((Object)serviceGroup.getElementContext(), (Object)serviceGroup);
        if (duplicateServiceGroup != null) {
            throw new AssertionError();
        }
        KlassParser.TopLevelDeclarationContext topLevelDeclarationContext = AntlrUtils.getParentOfType((ParserRuleContext)serviceGroup.getElementContext(), KlassParser.TopLevelDeclarationContext.class);
        AntlrTopLevelElement duplicateTopLevelElement = (AntlrTopLevelElement)this.topLevelElementsByContext.put((Object)topLevelDeclarationContext, (Object)serviceGroup);
        if (duplicateTopLevelElement != null) {
            throw new AssertionError();
        }
    }

    public AntlrEnumeration getEnumerationByName(String enumerationName) {
        return (AntlrEnumeration)this.enumerationsByName.getIfAbsentValue((Object)enumerationName, (Object)AntlrEnumeration.NOT_FOUND);
    }

    public AntlrClassifier getClassifierByName(String classifierName) {
        return (AntlrClassifier)this.classifiersByName.getIfAbsentValue((Object)classifierName, (Object)AntlrClassifier.NOT_FOUND);
    }

    public AntlrInterface getInterfaceByName(String interfaceName) {
        return (AntlrInterface)this.interfacesByName.getIfAbsentValue((Object)interfaceName, (Object)AntlrInterface.NOT_FOUND);
    }

    public AntlrClass getClassByName(String className) {
        return (AntlrClass)this.classesByName.getIfAbsentValue((Object)className, (Object)AntlrClass.NOT_FOUND);
    }

    public AntlrProjection getProjectionByName(String projectionName) {
        return (AntlrProjection)this.projectionsByName.getIfAbsentValue((Object)projectionName, (Object)AntlrProjection.NOT_FOUND);
    }

    public AntlrCompilationUnit getCompilationUnitByContext(KlassParser.CompilationUnitContext context) {
        return (AntlrCompilationUnit)this.compilationUnitsByContext.get((Object)context);
    }

    public AntlrTopLevelElement getTopLevelElementByContext(KlassParser.TopLevelDeclarationContext context) {
        return (AntlrTopLevelElement)this.topLevelElementsByContext.get((Object)context);
    }

    public Integer getTopLevelElementOrdinalByContext(KlassParser.TopLevelDeclarationContext context) {
        return (Integer)this.topLevelElementOrdinalsByContext.get((Object)context);
    }

    public AntlrEnumeration getEnumerationByContext(KlassParser.EnumerationDeclarationContext context) {
        return (AntlrEnumeration)this.enumerationsByContext.get((Object)context);
    }

    public AntlrClassifier getClassifierByContext(ParserRuleContext context) {
        return (AntlrClassifier)this.classifiersByContext.get((Object)context);
    }

    public AntlrInterface getInterfaceByContext(KlassParser.InterfaceDeclarationContext context) {
        return (AntlrInterface)this.interfacesByContext.get((Object)context);
    }

    public AntlrClass getClassByContext(KlassParser.ClassDeclarationContext context) {
        return (AntlrClass)this.classesByContext.get((Object)context);
    }

    public AntlrAssociation getAssociationByContext(KlassParser.AssociationDeclarationContext context) {
        return (AntlrAssociation)this.associationsByContext.get((Object)context);
    }

    public AntlrProjection getProjectionByContext(KlassParser.ProjectionDeclarationContext context) {
        return (AntlrProjection)this.projectionsByContext.get((Object)context);
    }

    public AntlrServiceGroup getServiceGroupByContext(KlassParser.ServiceGroupDeclarationContext context) {
        return (AntlrServiceGroup)this.serviceGroupsByContext.get((Object)context);
    }

    public void reportErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        for (AntlrClass userClass : this.userClasses) {
            if (this.userClasses.size() <= 1) continue;
            userClass.reportDuplicateUserClass(compilerAnnotationHolder);
        }
        this.reportDuplicateTopLevelNames(compilerAnnotationHolder);
        for (AntlrCompilationUnit compilationUnitState : this.compilationUnits) {
            compilationUnitState.reportNameErrors(compilerAnnotationHolder);
        }
        for (AntlrTopLevelElement topLevelElement : this.topLevelElements) {
            topLevelElement.reportNameErrors(compilerAnnotationHolder);
            topLevelElement.reportErrors(compilerAnnotationHolder);
        }
        for (AntlrClassifier classifier : this.classifiers) {
            if (!this.userClasses.isEmpty()) continue;
            classifier.reportAuditErrors(compilerAnnotationHolder);
        }
        ImmutableBag<AntlrClass> duplicateServiceGroupKlasses = this.getDuplicateServiceGroupClasses();
        for (AntlrServiceGroup serviceGroup : this.serviceGroups) {
            if (!duplicateServiceGroupKlasses.contains((Object)serviceGroup.getKlass())) continue;
            serviceGroup.reportDuplicateServiceGroupClass(compilerAnnotationHolder);
        }
        this.reportUnreferencedPrivateProperties(compilerAnnotationHolder);
    }

    private void reportDuplicateTopLevelNames(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        ImmutableList topLevelNames = this.topLevelElements.collect(AntlrTopLevelElement::getName).toImmutable();
        ImmutableBag duplicateTopLevelNames = topLevelNames.toBag().selectByOccurrences((IntPredicate & Serializable)occurrences -> occurrences > 1).toImmutable();
        this.topLevelElements.select((Predicate & Serializable)topLevelElement -> duplicateTopLevelNames.contains((Object)topLevelElement.getName())).forEachWith(AntlrTopLevelElement::reportDuplicateTopLevelName, (Object)compilerAnnotationHolder);
    }

    private ImmutableBag<AntlrClass> getDuplicateServiceGroupClasses() {
        return this.serviceGroups.collect(AntlrServiceGroup::getKlass).toBag().selectByOccurrences((IntPredicate & Serializable)occurrences -> occurrences > 1).reject(AntlrClass.AMBIGUOUS::equals).reject(AntlrClass.NOT_FOUND::equals).toImmutable();
    }

    private void reportUnreferencedPrivateProperties(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        UnreferencedPrivatePropertiesCriteriaVisitor criteriaVisitor = new UnreferencedPrivatePropertiesCriteriaVisitor();
        this.visitCriteria(criteriaVisitor);
        this.reportUnreferencedPrivateProperty(compilerAnnotationHolder, criteriaVisitor.getDataTypePropertiesReferencedByCriteria(), criteriaVisitor.getAssociationEndsReferencedByCriteria());
    }

    private void visitCriteria(AntlrCriteriaVisitor criteriaVisitor) {
        for (AntlrClassifier classifier : this.classifiers) {
            for (AntlrProperty property : classifier.getAllProperties()) {
                if (!(property instanceof AntlrParameterizedProperty)) continue;
                AntlrParameterizedProperty parameterizedProperty = (AntlrParameterizedProperty)property;
                AntlrCriteria criteria = parameterizedProperty.getCriteria();
                criteria.visit(criteriaVisitor);
            }
        }
        for (AntlrAssociation association : this.associations) {
            association.visitCriteria(criteriaVisitor);
        }
        for (AntlrServiceGroup serviceGroup : this.serviceGroups) {
            for (AntlrUrl url : serviceGroup.getUrls()) {
                for (AntlrService service : url.getServices()) {
                    for (AntlrServiceCriteria serviceCriteria : service.getServiceCriterias()) {
                        serviceCriteria.getCriteria().visit(criteriaVisitor);
                    }
                }
            }
        }
    }

    private void reportUnreferencedPrivateProperty(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder, @Nonnull Set<AntlrDataTypeProperty<?>> dataTypePropertiesReferencedByCriteria, @Nonnull Set<AntlrAssociationEnd> associationEndsReferencedByCriteria) {
        for (AntlrClassifier classifier : this.classifiers) {
            for (AntlrDataTypeProperty dataTypeProperty : classifier.getAllDataTypeProperties()) {
                ImmutableList<AntlrDataTypeProperty<?>> overriddenProperties = dataTypeProperty.getOverriddenProperties();
                if (!dataTypeProperty.isPrivate() || dataTypeProperty.getType() == AntlrPrimitiveType.TEMPORAL_RANGE) continue;
                if (!overriddenProperties.noneSatisfy(dataTypePropertiesReferencedByCriteria::contains)) continue;
                dataTypeProperty.reportUnreferencedPrivateProperty(compilerAnnotationHolder);
            }
        }
        for (AntlrClass klass : this.klasses) {
            for (AntlrAssociationEnd associationEnds : klass.getDeclaredAssociationEnds()) {
                if (!associationEnds.isPrivate() || associationEndsReferencedByCriteria.contains(associationEnds) || associationEndsReferencedByCriteria.contains(associationEnds.getOpposite())) continue;
                associationEnds.reportUnreferencedPrivateProperty(compilerAnnotationHolder);
            }
        }
    }

    @Nonnull
    public DomainModelImpl.DomainModelBuilder build(ImmutableList<CompilationUnit> compilationUnits) {
        ImmutableList sourceCodeBuilders = compilationUnits.collect(CompilationUnit::build);
        ImmutableList enumerationBuilders = this.enumerations.collect(AntlrEnumeration::build).toImmutable();
        ImmutableList interfaceBuilders = this.interfaces.collect(AntlrInterface::build1).toImmutable();
        ImmutableList classBuilders = this.klasses.collect(AntlrClass::build1).toImmutable();
        ImmutableList classifierBuilders = this.classifiers.collect(AntlrClassifier::getElementBuilder).toImmutable();
        ImmutableList associationBuilders = this.associations.collect(AntlrAssociation::build).toImmutable();
        this.interfaces.each(AntlrInterface::build2);
        this.klasses.each(AntlrClass::build2);
        ImmutableList projectionBuilders = this.projections.collect(AntlrProjection::build).toImmutable();
        this.projections.each(AntlrProjection::build2);
        ImmutableList serviceGroupBuilders = this.serviceGroups.collect(AntlrServiceGroup::build).toImmutable();
        ImmutableList topLevelElementBuilders = this.topLevelElements.collect(AntlrTopLevelElement::getElementBuilder).toImmutable();
        compilationUnits.each(CompilationUnit::build2);
        return new DomainModelImpl.DomainModelBuilder(sourceCodeBuilders, topLevelElementBuilders, enumerationBuilders, classifierBuilders, interfaceBuilders, classBuilders, associationBuilders, projectionBuilders, serviceGroupBuilders);
    }
}

