/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state.projection;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.AntlrClassifier;
import cool.klass.model.converter.compiler.state.AntlrCompilationUnit;
import cool.klass.model.converter.compiler.state.AntlrInterface;
import cool.klass.model.converter.compiler.state.AntlrTopLevelElement;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.projection.AntlrProjectionChild;
import cool.klass.model.converter.compiler.state.projection.AntlrProjectionElement;
import cool.klass.model.converter.compiler.state.projection.AntlrProjectionParent;
import cool.klass.model.meta.domain.projection.ProjectionImpl;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.tuple.Tuples;

public class AntlrProjection
extends AntlrProjectionParent
implements AntlrTopLevelElement {
    public static final AntlrProjection AMBIGUOUS = new AntlrProjection(new KlassParser.ProjectionDeclarationContext(AMBIGUOUS_PARENT, -1), Optional.empty(), -1, AMBIGUOUS_IDENTIFIER_CONTEXT, AntlrCompilationUnit.AMBIGUOUS, AntlrClassifier.AMBIGUOUS, "ambiguous"){

        @Override
        public String toString() {
            return AntlrProjection.class + ".AMBIGUOUS";
        }
    };
    public static final AntlrProjection NOT_FOUND = new AntlrProjection(new KlassParser.ProjectionDeclarationContext(NOT_FOUND_PARENT, -1), Optional.empty(), -1, NOT_FOUND_IDENTIFIER_CONTEXT, AntlrCompilationUnit.NOT_FOUND, AntlrClassifier.NOT_FOUND, "not found"){

        @Override
        public String toString() {
            return AntlrProjection.class + ".NOT_FOUND";
        }
    };
    @Nonnull
    private final AntlrCompilationUnit compilationUnitState;
    private final String packageName;
    private ProjectionImpl.ProjectionBuilder projectionBuilder;

    public AntlrProjection(@Nonnull KlassParser.ProjectionDeclarationContext elementContext, @Nonnull Optional<CompilationUnit> compilationUnit, int ordinal, @Nonnull KlassParser.IdentifierContext nameContext, @Nonnull AntlrCompilationUnit compilationUnitState, @Nonnull AntlrClassifier classifier, String packageName) {
        super((ParserRuleContext)elementContext, compilationUnit, ordinal, nameContext, classifier);
        this.compilationUnitState = Objects.requireNonNull(compilationUnitState);
        this.packageName = Objects.requireNonNull(packageName);
    }

    @Override
    @Nonnull
    public Optional<IAntlrElement> getSurroundingElement() {
        return Optional.of(this.compilationUnitState);
    }

    @Override
    public Pair<Token, Token> getContextBefore() {
        return Tuples.pair((Object)this.getElementContext().getStart(), (Object)this.getElementContext().projectionBlock().getStart());
    }

    @Nonnull
    public KlassParser.ProjectionDeclarationContext getElementContext() {
        return (KlassParser.ProjectionDeclarationContext)super.getElementContext();
    }

    @Override
    protected Pattern getNamePattern() {
        return TYPE_NAME_PATTERN;
    }

    public ProjectionImpl.ProjectionBuilder build() {
        if (this.projectionBuilder != null) {
            throw new IllegalStateException();
        }
        this.projectionBuilder = new ProjectionImpl.ProjectionBuilder((KlassParser.ProjectionDeclarationContext)this.elementContext, this.getMacroElementBuilder(), this.getSourceCodeBuilder(), this.ordinal, this.getNameContext(), this.packageName, this.classifier.getElementBuilder());
        ImmutableList children = this.children.collect(AntlrProjectionChild::build).toImmutable();
        this.projectionBuilder.setChildBuilders(children);
        return this.projectionBuilder;
    }

    public void build2() {
        this.children.each(AntlrProjectionElement::build2);
    }

    @Nonnull
    public ProjectionImpl.ProjectionBuilder getElementBuilder() {
        return this.projectionBuilder;
    }

    @Override
    public void reportErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        super.reportErrors(compilerAnnotationHolder);
        if (this.classifier == AntlrClassifier.NOT_FOUND || this.classifier == AntlrClass.NOT_FOUND || this.classifier == AntlrInterface.NOT_FOUND) {
            String message = "Projection type not found " + this.getElementContext().classifierReference().getText();
            compilerAnnotationHolder.add("ERR_PRJ_NFD", message, (IAntlrElement)this, (ParserRuleContext)this.getElementContext().classifierReference());
            return;
        }
        if (this.classifier == AntlrClassifier.AMBIGUOUS || this.classifier == AntlrClass.AMBIGUOUS || this.classifier == AntlrInterface.AMBIGUOUS) {
            return;
        }
        this.reportForwardReference(compilerAnnotationHolder);
        for (AntlrProjectionChild child : this.children) {
            child.reportErrors(compilerAnnotationHolder);
        }
    }

    protected void reportForwardReference(CompilerAnnotationHolder compilerAnnotationHolder) {
        if (this.isForwardReference(this.classifier)) {
            String message = String.format("Projection '%s' is declared on line %d and has a forward reference to classifier '%s' which is declared later in the source file '%s' on line %d.", this.getName(), this.getElementContext().getStart().getLine(), this.classifier.getName(), this.getCompilationUnit().get().getSourceName(), this.classifier.getElementContext().getStart().getLine());
            compilerAnnotationHolder.add("ERR_FWD_REF", message, (IAntlrElement)this, (ParserRuleContext)this.getElementContext().classifierReference());
        }
    }
}

