/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state.property;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.annotation.AnnotationSeverity;
import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.state.AntlrClassifier;
import cool.klass.model.converter.compiler.state.AntlrElement;
import cool.klass.model.converter.compiler.state.AntlrEnumeration;
import cool.klass.model.converter.compiler.state.AntlrPrimitiveType;
import cool.klass.model.converter.compiler.state.AntlrType;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.property.AntlrAssociationEnd;
import cool.klass.model.converter.compiler.state.property.AntlrModifier;
import cool.klass.model.converter.compiler.state.property.AntlrProperty;
import cool.klass.model.converter.compiler.state.property.validation.AbstractAntlrPropertyValidation;
import cool.klass.model.converter.compiler.state.property.validation.AntlrMaxLengthPropertyValidation;
import cool.klass.model.converter.compiler.state.property.validation.AntlrMaxPropertyValidation;
import cool.klass.model.converter.compiler.state.property.validation.AntlrMinLengthPropertyValidation;
import cool.klass.model.converter.compiler.state.property.validation.AntlrMinPropertyValidation;
import cool.klass.model.meta.domain.api.DataType;
import cool.klass.model.meta.domain.api.PrimitiveType;
import cool.klass.model.meta.domain.property.AbstractDataTypeProperty;
import cool.klass.model.meta.grammar.KlassParser;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableOrderedMap;
import org.eclipse.collections.api.map.OrderedMap;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.map.ordered.mutable.OrderedMapAdapter;
import org.eclipse.collections.impl.tuple.Tuples;

public abstract class AntlrDataTypeProperty<T extends DataType>
extends AntlrProperty {
    public static final AntlrDataTypeProperty AMBIGUOUS = new AntlrDataTypeProperty((ParserRuleContext)new KlassParser.ClassDeclarationContext(AMBIGUOUS_PARENT, -1), Optional.empty(), -1, AMBIGUOUS_IDENTIFIER_CONTEXT, AntlrClassifier.AMBIGUOUS, false){

        @Override
        protected ParserRuleContext getTypeParserRuleContext() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getTypeParserRuleContext() not implemented yet");
        }

        @Override
        @Nonnull
        public AntlrType getType() {
            return AntlrEnumeration.AMBIGUOUS;
        }

        @Nonnull
        public AbstractDataTypeProperty.DataTypePropertyBuilder build() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".build() not implemented yet");
        }

        @Nonnull
        public AbstractDataTypeProperty.DataTypePropertyBuilder getElementBuilder() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getElementBuilder() not implemented yet");
        }

        @Override
        public String getTypeName() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getTypeName() not implemented yet");
        }

        @Override
        protected void reportInvalidIdProperties(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".reportInvalidIdProperties() not implemented yet");
        }
    };
    public static final AntlrDataTypeProperty NOT_FOUND = new AntlrDataTypeProperty((ParserRuleContext)new KlassParser.ClassDeclarationContext(NOT_FOUND_PARENT, -1), Optional.empty(), -1, NOT_FOUND_IDENTIFIER_CONTEXT, AntlrClassifier.NOT_FOUND, false){

        @Override
        protected ParserRuleContext getTypeParserRuleContext() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getTypeParserRuleContext() not implemented yet");
        }

        @Override
        @Nonnull
        public AntlrType getType() {
            return AntlrEnumeration.NOT_FOUND;
        }

        @Nonnull
        public AbstractDataTypeProperty.DataTypePropertyBuilder build() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".build() not implemented yet");
        }

        @Nonnull
        public AbstractDataTypeProperty.DataTypePropertyBuilder getElementBuilder() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getElementBuilder() not implemented yet");
        }

        @Override
        public String getTypeName() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getTypeName() not implemented yet");
        }

        @Override
        protected void reportInvalidIdProperties(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".reportInvalidIdProperties() not implemented yet");
        }
    };
    private static final ImmutableList<PrimitiveType> ALLOWED_VERSION_TYPES = Lists.immutable.with((Object)PrimitiveType.INTEGER, (Object)PrimitiveType.LONG);
    protected final boolean isOptional;
    @Nonnull
    protected final AntlrClassifier owningClassifier;
    protected final MutableList<AbstractAntlrPropertyValidation> validations = Lists.mutable.empty();
    protected final MutableList<AntlrMinLengthPropertyValidation> minLengthValidations = Lists.mutable.empty();
    protected final MutableList<AntlrMaxLengthPropertyValidation> maxLengthValidations = Lists.mutable.empty();
    protected final MutableList<AntlrMinPropertyValidation> minValidations = Lists.mutable.empty();
    protected final MutableList<AntlrMaxPropertyValidation> maxValidations = Lists.mutable.empty();
    private final MutableOrderedMap<AntlrAssociationEnd, MutableList<AntlrDataTypeProperty<?>>> keysMatchingThisForeignKey = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableOrderedMap<AntlrAssociationEnd, MutableList<AntlrDataTypeProperty<?>>> foreignKeysMatchingThisKey = OrderedMapAdapter.adapt(new LinkedHashMap());

    protected AntlrDataTypeProperty(@Nonnull ParserRuleContext elementContext, @Nonnull Optional<CompilationUnit> compilationUnit, int ordinal, @Nonnull KlassParser.IdentifierContext nameContext, @Nonnull AntlrClassifier owningClassifier, boolean isOptional) {
        super(elementContext, compilationUnit, ordinal, nameContext);
        this.isOptional = isOptional;
        this.owningClassifier = Objects.requireNonNull(owningClassifier);
    }

    @Override
    @Nonnull
    public Optional<IAntlrElement> getSurroundingElement() {
        return Optional.of(this.owningClassifier);
    }

    protected abstract ParserRuleContext getTypeParserRuleContext();

    public boolean isKey() {
        return this.getModifiers().anySatisfy(AntlrModifier::isKey);
    }

    public boolean isId() {
        return this.getModifiers().anySatisfy(AntlrModifier::isId);
    }

    public boolean isUserId() {
        return this.getModifiers().anySatisfy(AntlrModifier::isUserId);
    }

    public boolean isAudit() {
        return this.getModifiers().anySatisfy(AntlrModifier::isAudit);
    }

    public boolean isCreatedOn() {
        return this.getModifiers().anySatisfy(AntlrModifier::isCreatedOn);
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isSystem() {
        return this.getModifiers().anySatisfy(AntlrModifier::isSystem);
    }

    public boolean isValid() {
        return this.getModifiers().anySatisfy(AntlrModifier::isValid);
    }

    public boolean isValidRange() {
        return this.isValid() && !this.isFrom() && !this.isTo();
    }

    public boolean isValidFrom() {
        return this.isValid() && this.isFrom();
    }

    public boolean isValidTo() {
        return this.isValid() && this.isTo();
    }

    public boolean isSystemRange() {
        return this.isSystem() && !this.isFrom() && !this.isTo();
    }

    public boolean isSystemFrom() {
        return this.isSystem() && this.isFrom();
    }

    public boolean isSystemTo() {
        return this.isSystem() && this.isTo();
    }

    public boolean isFrom() {
        return this.getModifiers().anySatisfy(AntlrModifier::isFrom);
    }

    public boolean isTo() {
        return this.getModifiers().anySatisfy(AntlrModifier::isTo);
    }

    public void setKeyMatchingThisForeignKey(AntlrAssociationEnd associationEnd, AntlrDataTypeProperty<?> keyProperty) {
        ((MutableList)this.keysMatchingThisForeignKey.computeIfAbsent((Object)associationEnd, k -> Lists.mutable.empty())).add(keyProperty);
    }

    public void setForeignKeyMatchingThisKey(AntlrAssociationEnd associationEnd, AntlrDataTypeProperty<?> foreignKeyProperty) {
        ((MutableList)this.foreignKeysMatchingThisKey.computeIfAbsent((Object)associationEnd, k -> Lists.mutable.empty())).add(foreignKeyProperty);
    }

    public void addMinLengthValidation(AntlrMinLengthPropertyValidation minLengthValidation) {
        this.validations.add((Object)minLengthValidation);
        this.minLengthValidations.add((Object)minLengthValidation);
    }

    public void addMaxLengthValidation(AntlrMaxLengthPropertyValidation maxLengthValidation) {
        this.validations.add((Object)maxLengthValidation);
        this.maxLengthValidations.add((Object)maxLengthValidation);
    }

    public void addMinValidation(AntlrMinPropertyValidation minValidation) {
        this.validations.add((Object)minValidation);
        this.minValidations.add((Object)minValidation);
    }

    public void addMaxValidation(AntlrMaxPropertyValidation maxValidation) {
        this.validations.add((Object)maxValidation);
        this.maxValidations.add((Object)maxValidation);
    }

    public ListIterable<AbstractAntlrPropertyValidation> getValidations() {
        return this.validations;
    }

    public ListIterable<AntlrMinLengthPropertyValidation> getMinLengthValidations() {
        return this.minLengthValidations;
    }

    public ListIterable<AntlrMaxLengthPropertyValidation> getMaxLengthValidations() {
        return this.maxLengthValidations;
    }

    public ListIterable<AntlrMinPropertyValidation> getMinValidations() {
        return this.minValidations;
    }

    public ListIterable<AntlrMaxPropertyValidation> getMaxValidations() {
        return this.maxValidations;
    }

    @Nonnull
    public abstract AbstractDataTypeProperty.DataTypePropertyBuilder<T, ?, ?> getElementBuilder();

    @Override
    @Nonnull
    public AntlrClassifier getOwningClassifier() {
        return this.owningClassifier;
    }

    public ImmutableList<AntlrDataTypeProperty<?>> getOverriddenProperties() {
        return this.owningClassifier.getOverriddenDataTypeProperties(this.getName());
    }

    @Nonnull
    public abstract AbstractDataTypeProperty.DataTypePropertyBuilder<T, ?, ?> build();

    protected void buildValidations() {
        Optional minLengthPropertyValidationBuilders = this.minLengthValidations.collect(AntlrMinLengthPropertyValidation::build).detectOptional((Predicate & Serializable)x -> true);
        Optional maxLengthPropertyValidationBuilders = this.maxLengthValidations.collect(AntlrMaxLengthPropertyValidation::build).detectOptional((Predicate & Serializable)x -> true);
        Optional minPropertyValidationBuilders = this.minValidations.collect(AntlrMinPropertyValidation::build).detectOptional((Predicate & Serializable)x -> true);
        Optional maxPropertyValidationBuilders = this.maxValidations.collect(AntlrMaxPropertyValidation::build).detectOptional((Predicate & Serializable)x -> true);
        MutableList propertyValidationBuilders = this.validations.collect(AbstractAntlrPropertyValidation::getElementBuilder);
        this.getElementBuilder().setMinLengthPropertyValidationBuilder(minLengthPropertyValidationBuilders);
        this.getElementBuilder().setMaxLengthPropertyValidationBuilder(maxLengthPropertyValidationBuilders);
        this.getElementBuilder().setMinPropertyValidationBuilder(minPropertyValidationBuilders);
        this.getElementBuilder().setMaxPropertyValidationBuilder(maxPropertyValidationBuilders);
        this.getElementBuilder().setPropertyValidationBuilders(propertyValidationBuilders.toImmutable());
    }

    public void build2() {
        MutableOrderedMap keysMatchingThisForeignKey = this.keysMatchingThisForeignKey.collect((Function2 & Serializable)(associationEnd, dataTypeProperties) -> Tuples.pair((Object)associationEnd.getElementBuilder(), ((AntlrDataTypeProperty)dataTypeProperties.getOnly()).getElementBuilder()));
        this.getElementBuilder().setKeyBuildersMatchingThisForeignKey(keysMatchingThisForeignKey.asUnmodifiable());
        MutableOrderedMap foreignKeysMatchingThisKey = this.foreignKeysMatchingThisKey.collect((Function2 & Serializable)(associationEnd, dataTypeProperties) -> Tuples.pair((Object)associationEnd.getElementBuilder(), ((AntlrDataTypeProperty)dataTypeProperties.getOnly()).getElementBuilder()));
        this.getElementBuilder().setForeignKeyBuildersMatchingThisKey(foreignKeysMatchingThisKey.asUnmodifiable());
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void reportErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        super.reportErrors(compilerAnnotationHolder);
        this.reportDuplicateValidations(compilerAnnotationHolder);
        this.reportInvalidIdProperties(compilerAnnotationHolder);
        this.reportInvalidForeignKeyProperties(compilerAnnotationHolder);
        this.reportInvalidUserIdProperties(compilerAnnotationHolder);
        this.reportInvalidVersionProperties(compilerAnnotationHolder);
        this.reportInvalidTemporalProperties(compilerAnnotationHolder);
    }

    private void reportDuplicateValidations(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        this.reportDuplicateValidations(compilerAnnotationHolder, (ListIterable<? extends AbstractAntlrPropertyValidation>)this.minLengthValidations);
        this.reportDuplicateValidations(compilerAnnotationHolder, (ListIterable<? extends AbstractAntlrPropertyValidation>)this.maxLengthValidations);
        this.reportDuplicateValidations(compilerAnnotationHolder, (ListIterable<? extends AbstractAntlrPropertyValidation>)this.minValidations);
        this.reportDuplicateValidations(compilerAnnotationHolder, (ListIterable<? extends AbstractAntlrPropertyValidation>)this.maxValidations);
    }

    private void reportDuplicateValidations(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder, @Nonnull ListIterable<? extends AbstractAntlrPropertyValidation> validations) {
        if (validations.size() <= 1) {
            return;
        }
        for (AbstractAntlrPropertyValidation minLengthValidation : validations) {
            ParserRuleContext offendingToken = minLengthValidation.getElementContext();
            String message = String.format("Duplicate validation '%s'.", offendingToken.getText());
            compilerAnnotationHolder.add("ERR_DUP_VAL", message, (IAntlrElement)minLengthValidation, minLengthValidation.getKeywordToken());
        }
    }

    protected abstract void reportInvalidIdProperties(@Nonnull CompilerAnnotationHolder var1);

    private void reportInvalidForeignKeyProperties(CompilerAnnotationHolder compilerAnnotationHolder) {
        this.keysMatchingThisForeignKey.forEach((associationEnd, keyBuilders) -> this.reportInvalidForeignKeyProperties(compilerAnnotationHolder, (AntlrAssociationEnd)associationEnd, (ListIterable<AntlrDataTypeProperty<?>>)keyBuilders));
    }

    private void reportInvalidForeignKeyProperties(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder, @Nonnull AntlrAssociationEnd associationEnd, @Nonnull ListIterable<AntlrDataTypeProperty<?>> keyBuilders) {
        String message;
        if (keyBuilders.size() > 1) {
            throw new AssertionError((Object)"TODO: Is it sometimes valid to have a single foreign key relate to many different primary keys on different types?");
        }
        if (!associationEnd.isToOne()) {
            throw new AssertionError(associationEnd);
        }
        if (this.isOptional && associationEnd.isToOneRequired()) {
            message = String.format("Association end '%s.%s' has multiplicity [%s] so foreign key '%s.%s' ought to be required.", associationEnd.getOwningClassifier().getName(), associationEnd.getName(), associationEnd.getMultiplicity().getMultiplicity().getPrettyName(), this.owningClassifier.getName(), this.getName());
            compilerAnnotationHolder.add("ERR_FOR_MUL", message, (IAntlrElement)this, this.getTypeParserRuleContext());
            compilerAnnotationHolder.add("ERR_FOR_MUL", message, associationEnd.getMultiplicity());
        }
        if (!this.isOptional && associationEnd.isToOneOptional()) {
            message = String.format("Association end '%s.%s' has multiplicity [%s] so foreign key '%s.%s' ought to be optional.", associationEnd.getOwningClassifier().getName(), associationEnd.getName(), associationEnd.getMultiplicity().getMultiplicity().getPrettyName(), this.owningClassifier.getName(), this.getName());
            compilerAnnotationHolder.add("ERR_FOR_MUL", message, (IAntlrElement)this, this.getTypeParserRuleContext(), AnnotationSeverity.WARNING);
        }
        if (this.isCreatedBy() || this.isLastUpdatedBy()) {
            return;
        }
        if (!this.isFinal() && associationEnd.isFinal()) {
            message = String.format("Association end '%s.%s' is final [%s] so foreign key '%s.%s' ought to be final.", associationEnd.getOwningClassifier().getName(), associationEnd.getName(), associationEnd.getMultiplicity().getMultiplicity().getPrettyName(), this.owningClassifier.getName(), this.getName());
            compilerAnnotationHolder.add("ERR_FOR_FIN", message, this);
            for (AntlrModifier modifier : associationEnd.getModifiersByName("final")) {
                compilerAnnotationHolder.add("ERR_FOR_FIN", message, modifier);
            }
        }
        if (this.isFinal() && !associationEnd.isFinal()) {
            message = String.format("Association end '%s.%s' is not final [%s] but foreign key '%s.%s' is final. The two properties must match.", associationEnd.getOwningClassifier().getName(), associationEnd.getName(), associationEnd.getMultiplicity().getMultiplicity().getPrettyName(), this.owningClassifier.getName(), this.getName());
            ImmutableList<AntlrModifier> modifiers = this.getModifiersByName("final");
            for (AntlrModifier modifier : modifiers) {
                compilerAnnotationHolder.add("ERR_FOR_FIN", message, modifier);
            }
            compilerAnnotationHolder.add("ERR_FOR_FIN", message, associationEnd);
        }
    }

    private void reportInvalidUserIdProperties(CompilerAnnotationHolder compilerAnnotationHolder) {
        AntlrPrimitiveType primitiveType;
        if (!this.isUserId() || this.isCreatedBy() || this.isLastUpdatedBy()) {
            return;
        }
        AntlrType antlrType = this.getType();
        if (antlrType instanceof AntlrPrimitiveType && (primitiveType = (AntlrPrimitiveType)antlrType).getPrimitiveType() == PrimitiveType.STRING) {
            return;
        }
        AntlrModifier modifier = (AntlrModifier)this.getModifiers().detect(AntlrModifier::isUserId);
        String message = String.format("Expected type '%s' but was '%s' for '%s' property '%s'.", PrimitiveType.STRING, antlrType.getName(), modifier.getKeyword(), this);
        compilerAnnotationHolder.add("ERR_USR_DTP", message, (IAntlrElement)this, (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)modifier.getElementContext(), (Object)this.getTypeParserRuleContext()));
    }

    private void reportInvalidVersionProperties(CompilerAnnotationHolder compilerAnnotationHolder) {
        AntlrPrimitiveType primitiveType;
        if (this.getModifiers().noneSatisfy(AntlrModifier::isVersion)) {
            return;
        }
        AntlrType antlrType = this.getType();
        if (antlrType instanceof AntlrPrimitiveType && ALLOWED_VERSION_TYPES.contains((Object)(primitiveType = (AntlrPrimitiveType)antlrType).getPrimitiveType())) {
            return;
        }
        ParserRuleContext offendingToken = this.getTypeParserRuleContext();
        AntlrModifier modifier = (AntlrModifier)this.getModifiers().detect(AntlrModifier::isVersion);
        String message = String.format("Expected types %s but was '%s' for '%s' property '%s'.", ALLOWED_VERSION_TYPES, antlrType.getName(), modifier.getKeyword(), this);
        compilerAnnotationHolder.add("ERR_VER_DTP", message, (IAntlrElement)modifier, (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)offendingToken, (Object)modifier.getElementContext()));
    }

    private void reportInvalidTemporalProperties(CompilerAnnotationHolder compilerAnnotationHolder) {
        if (this.isValidRange() || this.isSystemRange()) {
            if (this.getType() != AntlrPrimitiveType.TEMPORAL_RANGE) {
                ParserRuleContext offendingToken = this.getTypeParserRuleContext();
                String message = String.format("Expected type '%s' for temporal property but found '%s'.", AntlrPrimitiveType.TEMPORAL_RANGE, offendingToken.getText());
                ListIterable modifiers = this.getModifiers().select((Predicate & Serializable)antlrModifier -> antlrModifier.isSystem() || antlrModifier.isVersion());
                ListIterable modifierContexts = modifiers.collect(AntlrElement::getElementContext);
                compilerAnnotationHolder.add("ERR_TMP_RNG", message, (IAntlrElement)this, (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)offendingToken).newWithAll((Iterable)modifierContexts));
            }
        } else if (this.isFrom() || this.isTo()) {
            if (!this.isValid() && !this.isSystem()) {
                ImmutableList modifiers = this.getModifiers().select((Predicate & Serializable)modifier -> modifier.isFrom() || modifier.isTo()).toImmutable();
                String message = String.format("Property '%s' with temporal modifier(s) %s must be marked as 'system' or 'valid'.", this, modifiers);
                compilerAnnotationHolder.add("ERR_TMP_SYS", message, (IAntlrElement)this, (ImmutableList<ParserRuleContext>)modifiers.collect(AntlrElement::getElementContext));
            } else if (this.getType() != AntlrPrimitiveType.TEMPORAL_INSTANT) {
                ParserRuleContext offendingToken = this.getTypeParserRuleContext();
                String message = String.format("Expected type '%s' for temporal property but found '%s'.", AntlrPrimitiveType.TEMPORAL_INSTANT, offendingToken.getText());
                ListIterable modifiers = this.getModifiers().select((Predicate & Serializable)modifier -> modifier.isSystem() || modifier.isVersion() || modifier.isFrom() || modifier.isTo());
                ListIterable modifierContexts = modifiers.collect(AntlrElement::getElementContext);
                compilerAnnotationHolder.add("ERR_TMP_INS", message, (IAntlrElement)this, (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)offendingToken).newWithAll((Iterable)modifierContexts));
            } else if (this.isFrom() && this.isTo()) {
                ImmutableList modifiers = this.getModifiers().select((Predicate & Serializable)modifier -> modifier.isFrom() || modifier.isTo()).toImmutable();
                ImmutableList modifierContexts = modifiers.collect(AntlrElement::getElementContext);
                String message = "Property may not have both 'from' and to' modifiers.";
                compilerAnnotationHolder.add("ERR_TMP_FTO", message, (IAntlrElement)this, (ImmutableList<ParserRuleContext>)modifierContexts);
            }
        }
    }

    @Override
    protected void reportInvalidAuditProperties(CompilerAnnotationHolder compilerAnnotationHolder) {
        String message;
        AntlrModifier modifier;
        AntlrType antlrType;
        String message2;
        AntlrModifier modifier2;
        super.reportInvalidAuditProperties(compilerAnnotationHolder);
        if (this.isUserId() && !this.isKey() && !this.isCreatedBy() && !this.isLastUpdatedBy()) {
            modifier2 = (AntlrModifier)this.getModifiers().detect(AntlrModifier::isUserId);
            message2 = String.format("Expected property '%s' with modifier '%s' to be a key, createdBy, or lastUpdatedBy.", this, modifier2.getKeyword());
            compilerAnnotationHolder.add("ERR_AUD_KEY", message2, (IAntlrElement)this, (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)modifier2.getElementContext()));
        }
        if (this.isCreatedBy() || this.isLastUpdatedBy()) {
            antlrType = this.getType();
            if (!(antlrType instanceof AntlrPrimitiveType) || ((AntlrPrimitiveType)antlrType).getPrimitiveType() != PrimitiveType.STRING) {
                modifier = (AntlrModifier)this.getModifiers().detect((Predicate & Serializable)antlrModifier -> antlrModifier.isCreatedBy() || antlrModifier.isLastUpdatedBy());
                message = String.format("Expected type '%s' but was '%s' for '%s' property '%s'.", PrimitiveType.STRING, antlrType.getName(), modifier.getKeyword(), this);
                compilerAnnotationHolder.add("ERR_AUD_DTP", message, (IAntlrElement)this, (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)modifier.getElementContext(), (Object)this.getTypeParserRuleContext()));
            } else if (!this.isUserId()) {
                modifier = (AntlrModifier)this.getModifiers().detect((Predicate & Serializable)antlrModifier -> antlrModifier.isCreatedBy() || antlrModifier.isLastUpdatedBy());
                message = String.format("Expected property '%s' with modifier '%s' to also have the userId modifier.", this, modifier.getKeyword());
                compilerAnnotationHolder.add("ERR_AUD_UID", message, (IAntlrElement)this, (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)modifier.getElementContext()));
            } else if (!this.isPrivate()) {
                modifier = (AntlrModifier)this.getModifiers().detect((Predicate & Serializable)antlrModifier -> antlrModifier.isCreatedBy() || antlrModifier.isLastUpdatedBy());
                message = String.format("Expected property '%s' with modifier '%s' to also have the private modifier.", this, modifier.getKeyword());
                compilerAnnotationHolder.add("ERR_AUD_PRI", message, (IAntlrElement)this, (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)modifier.getElementContext()));
            }
        }
        if (this.isCreatedOn()) {
            antlrType = this.getType();
            if (!(antlrType instanceof AntlrPrimitiveType) || ((AntlrPrimitiveType)antlrType).getPrimitiveType() != PrimitiveType.INSTANT) {
                modifier = (AntlrModifier)this.getModifiers().detect(AntlrModifier::isCreatedOn);
                message = String.format("Expected type '%s' but was '%s' for '%s' property '%s'.", PrimitiveType.INSTANT, antlrType.getName(), modifier.getKeyword(), this);
                compilerAnnotationHolder.add("ERR_AUD_DTP", message, (IAntlrElement)this, (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)modifier.getElementContext(), (Object)this.getTypeParserRuleContext()));
            } else if (!this.isFinal()) {
                modifier = (AntlrModifier)this.getModifiers().detect(AntlrModifier::isCreatedOn);
                message = String.format("Expected createdOn property '%s' to be final.", this);
                compilerAnnotationHolder.add("ERR_CON_FIN", message, (IAntlrElement)this, (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)modifier.getElementContext()));
            }
        }
        if (this.isCreatedBy() && this.isLastUpdatedBy()) {
            return;
        }
        if (this.isCreatedBy()) {
            modifier2 = (AntlrModifier)this.getModifiers().detect(AntlrModifier::isCreatedBy);
            if (!this.getName().equals("createdById")) {
                message2 = String.format("Expected createdBy property '%s' to be named 'createdById'.", this);
                compilerAnnotationHolder.add("WRN_CRT_NAM", message2, (IAntlrElement)this, (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)this.getNameContext(), (Object)modifier2.getElementContext()), AnnotationSeverity.WARNING);
            }
        }
        if (this.isLastUpdatedBy()) {
            modifier2 = (AntlrModifier)this.getModifiers().detect(AntlrModifier::isLastUpdatedBy);
            if (!this.getName().equals("lastUpdatedById")) {
                message2 = String.format("Expected lastUpdatedBy property '%s' to be named 'lastUpdatedById'.", this);
                compilerAnnotationHolder.add("WRN_LUB_NAM", message2, (IAntlrElement)this, (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)this.getNameContext(), (Object)modifier2.getElementContext()), AnnotationSeverity.WARNING);
            }
        }
    }

    public void reportIdPropertyWithKeyProperties(CompilerAnnotationHolder compilerAnnotationHolder) {
        String message = String.format("Class '%s' may have id properties or non-id key properties, but not both. Found id property: %s.", this.owningClassifier.getName(), this);
        compilerAnnotationHolder.add("ERR_KEY_IDS", message, this);
    }

    public void reportKeyPropertyWithIdProperties(CompilerAnnotationHolder compilerAnnotationHolder) {
        String message = String.format("Class '%s' may have id properties or non-id key properties, but not both. Found non-id key property: %s.", this.owningClassifier.getName(), this);
        compilerAnnotationHolder.add("ERR_KEY_IDS", message, this);
    }

    public void reportTransientIdProperties(CompilerAnnotationHolder compilerAnnotationHolder) {
        ImmutableList<AntlrModifier> idModifiers = this.getModifiersByName("id");
        if (idModifiers.isEmpty()) {
            return;
        }
        String message = String.format("Transient class '%s' may not have id properties.", this.owningClassifier.getName());
        compilerAnnotationHolder.add("ERR_TNS_IDP", message, (IAntlrElement)this, (ImmutableList<ParserRuleContext>)idModifiers.collect(AntlrElement::getElementContext));
    }

    @Override
    public String toString() {
        return String.format("%s.%s", this.owningClassifier.getName(), this.getShortString());
    }

    @Override
    public String getShortString() {
        MutableList sourceCodeStrings = org.eclipse.collections.api.factory.Lists.mutable.empty();
        String typeSourceCode = this.getType().getName();
        sourceCodeStrings.add((Object)typeSourceCode);
        this.getModifiers().asLazy().collect(AntlrElement::toString).into((Collection)sourceCodeStrings);
        this.getValidations().asLazy().collect(AntlrElement::toString).into((Collection)sourceCodeStrings);
        return String.format("%s: %s", this.getName(), sourceCodeStrings.makeString(" "));
    }

    public OrderedMap<AntlrAssociationEnd, MutableList<AntlrDataTypeProperty<?>>> getKeysMatchingThisForeignKey() {
        return (OrderedMap)Objects.requireNonNull(this.keysMatchingThisForeignKey);
    }

    public boolean isForeignKey() {
        return this.keysMatchingThisForeignKey.notEmpty();
    }
}

