/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state.service;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.state.AntlrElement;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.criteria.AntlrCriteria;
import cool.klass.model.converter.compiler.state.order.AntlrOrderBy;
import cool.klass.model.converter.compiler.state.order.AntlrOrderByOwner;
import cool.klass.model.converter.compiler.state.service.AntlrServiceCriteria;
import cool.klass.model.converter.compiler.state.service.AntlrServiceMultiplicity;
import cool.klass.model.converter.compiler.state.service.AntlrServiceProjectionDispatch;
import cool.klass.model.converter.compiler.state.service.AntlrVerb;
import cool.klass.model.converter.compiler.state.service.url.AntlrUrl;
import cool.klass.model.meta.domain.api.service.ServiceMultiplicity;
import cool.klass.model.meta.domain.api.service.Verb;
import cool.klass.model.meta.domain.order.OrderByImpl;
import cool.klass.model.meta.domain.service.ServiceImpl;
import cool.klass.model.meta.domain.service.ServiceProjectionDispatchImpl;
import cool.klass.model.meta.domain.service.url.UrlImpl;
import cool.klass.model.meta.grammar.KlassParser;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MutableOrderedMap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Maps;
import org.eclipse.collections.impl.map.ordered.mutable.OrderedMapAdapter;
import org.eclipse.collections.impl.tuple.Tuples;

public class AntlrService
extends AntlrElement
implements AntlrOrderByOwner {
    public static final AntlrService AMBIGUOUS = new AntlrService(new KlassParser.ServiceDeclarationContext(AMBIGUOUS_PARENT, -1), Optional.empty(), AntlrUrl.AMBIGUOUS, AntlrVerb.AMBIGUOUS);
    private static final ImmutableMap<Verb, ImmutableList<String>> ALLOWED_CRITERIA_TYPES = Maps.immutable.empty().newWithKeyValue((Object)Verb.GET, (Object)Lists.immutable.with((Object)"authorize", (Object)"criteria", (Object)"version")).newWithKeyValue((Object)Verb.POST, (Object)Lists.immutable.with((Object)"authorize")).newWithKeyValue((Object)Verb.PUT, (Object)Lists.immutable.with((Object)"authorize", (Object)"criteria", (Object)"conflict")).newWithKeyValue((Object)Verb.PATCH, (Object)Lists.immutable.with((Object)"authorize", (Object)"criteria", (Object)"conflict")).newWithKeyValue((Object)Verb.DELETE, (Object)Lists.immutable.with((Object)"authorize", (Object)"criteria", (Object)"conflict"));
    @Nonnull
    private final AntlrUrl url;
    @Nonnull
    private final AntlrVerb verb;
    private final MutableList<AntlrServiceCriteria> serviceCriterias = Lists.mutable.empty();
    private final MutableOrderedMap<KlassParser.ServiceCriteriaDeclarationContext, AntlrServiceCriteria> serviceCriteriaByContext = OrderedMapAdapter.adapt(new LinkedHashMap());
    @Nullable
    private AntlrServiceMultiplicity serviceMultiplicity;
    @Nonnull
    private Optional<AntlrServiceProjectionDispatch> serviceProjectionDispatch = Optional.empty();
    @Nonnull
    private Optional<AntlrOrderBy> orderBy = Optional.empty();
    private ServiceImpl.ServiceBuilder elementBuilder;

    public AntlrService(@Nonnull KlassParser.ServiceDeclarationContext elementContext, @Nonnull Optional<CompilationUnit> compilationUnit, @Nonnull AntlrUrl url, @Nonnull AntlrVerb verb) {
        super((ParserRuleContext)elementContext, compilationUnit);
        this.url = Objects.requireNonNull(url);
        this.verb = Objects.requireNonNull(verb);
    }

    @Override
    @Nonnull
    public Optional<IAntlrElement> getSurroundingElement() {
        return Optional.of(this.url);
    }

    @Override
    public boolean isContext() {
        return true;
    }

    @Override
    public Pair<Token, Token> getContextBefore() {
        return Tuples.pair((Object)this.getElementContext().getStart(), (Object)this.getElementContext().serviceBlock().getStart());
    }

    @Override
    public Pair<Token, Token> getContextAfter() {
        return Tuples.pair((Object)this.getElementContext().serviceBlock().getStop(), (Object)this.getElementContext().serviceBlock().getStop());
    }

    @Nonnull
    public AntlrUrl getUrl() {
        return this.url;
    }

    @Nullable
    public AntlrServiceMultiplicity getServiceMultiplicity() {
        return this.serviceMultiplicity;
    }

    public MutableList<AntlrServiceCriteria> getServiceCriterias() {
        return this.serviceCriterias.asUnmodifiable();
    }

    public AntlrServiceCriteria getServiceCriteriaByContext(KlassParser.ServiceCriteriaDeclarationContext ctx) {
        return (AntlrServiceCriteria)this.serviceCriteriaByContext.get((Object)ctx);
    }

    public void reportDuplicateVerb(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        String message = String.format("Duplicate verb: '%s'.", this.verb.getVerb());
        compilerAnnotationHolder.add("ERR_DUP_VRB", message, (IAntlrElement)this, this.verb.getElementContext());
    }

    public void enterServiceCriteriaDeclaration(@Nonnull AntlrServiceCriteria serviceCriteria) {
        this.serviceCriterias.add((Object)serviceCriteria);
        AntlrServiceCriteria duplicate = (AntlrServiceCriteria)this.serviceCriteriaByContext.put((Object)serviceCriteria.getElementContext(), (Object)serviceCriteria);
        if (duplicate != null) {
            throw new AssertionError();
        }
    }

    public void enterServiceProjectionDispatch(@Nonnull AntlrServiceProjectionDispatch projectionDispatch) {
        this.serviceProjectionDispatch = Optional.of(projectionDispatch);
    }

    public void reportErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        this.reportDuplicateKeywords(compilerAnnotationHolder);
        this.reportInvalidProjection(compilerAnnotationHolder);
        Verb verb = this.verb.getVerb();
        ImmutableList allowedCriteriaTypes = (ImmutableList)ALLOWED_CRITERIA_TYPES.get((Object)verb);
        for (AntlrServiceCriteria serviceCriteria : this.serviceCriterias) {
            if (allowedCriteriaTypes == null) {
                throw new AssertionError(verb);
            }
            serviceCriteria.reportAllowedCriteriaTypes(compilerAnnotationHolder, (ImmutableList<String>)allowedCriteriaTypes);
            serviceCriteria.getCriteria().reportErrors(compilerAnnotationHolder);
        }
        this.orderBy.ifPresent(orderBy -> orderBy.reportErrors(compilerAnnotationHolder));
    }

    protected void reportDuplicateKeywords(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        ImmutableBag duplicateKeywords = this.serviceCriterias.collect(AntlrServiceCriteria::getServiceCriteriaKeyword).toBag().selectByOccurrences((IntPredicate & Serializable)occurrences -> occurrences > 1).toImmutable();
        this.serviceCriterias.select((Predicate & Serializable)each -> duplicateKeywords.contains((Object)each.getServiceCriteriaKeyword())).forEachWith(AntlrServiceCriteria::reportDuplicateKeyword, (Object)compilerAnnotationHolder);
    }

    private void reportInvalidProjection(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        Verb verb = this.verb.getVerb();
        if (verb == Verb.GET) {
            this.serviceProjectionDispatch.ifPresentOrElse(projectionDispatch -> projectionDispatch.reportErrors(compilerAnnotationHolder), () -> this.reportMissingProjection(compilerAnnotationHolder));
        } else {
            this.serviceProjectionDispatch.ifPresent(projectionDispatch -> this.reportPresentProjection((AntlrServiceProjectionDispatch)projectionDispatch, compilerAnnotationHolder));
        }
    }

    private void reportMissingProjection(CompilerAnnotationHolder compilerAnnotationHolder) {
        ParserRuleContext verbContext = this.verb.getElementContext();
        compilerAnnotationHolder.add("ERR_GET_PRJ", "GET services require a projection.", (IAntlrElement)this, verbContext);
    }

    private void reportPresentProjection(AntlrServiceProjectionDispatch projectionDispatch, CompilerAnnotationHolder compilerAnnotationHolder) {
        KlassParser.ServiceProjectionDispatchContext elementContext = projectionDispatch.getElementContext();
        compilerAnnotationHolder.add("ERR_PUT_PRJ", String.format("%s services must not have a projection.", this.verb.getVerb().name()), (IAntlrElement)projectionDispatch, (ParserRuleContext)elementContext);
    }

    @Nonnull
    public AntlrVerb getVerb() {
        return this.verb;
    }

    public void enterServiceMultiplicityDeclaration(@Nonnull AntlrServiceMultiplicity serviceMultiplicity) {
        this.serviceMultiplicity = Objects.requireNonNull(serviceMultiplicity);
    }

    @Override
    public void enterOrderByDeclaration(@Nonnull AntlrOrderBy orderBy) {
        if (this.orderBy.isPresent()) {
            throw new IllegalStateException();
        }
        this.orderBy = Optional.of(orderBy);
    }

    @Override
    @Nonnull
    public Optional<AntlrOrderBy> getOrderBy() {
        return this.orderBy;
    }

    public ServiceImpl.ServiceBuilder build() {
        if (this.elementBuilder != null) {
            throw new IllegalStateException();
        }
        UrlImpl.UrlBuilder urlBuilder = this.url.getElementBuilder();
        Verb verb = this.verb.getVerb();
        ServiceMultiplicity serviceMultiplicity = this.serviceMultiplicity.getServiceMultiplicity();
        this.elementBuilder = new ServiceImpl.ServiceBuilder((KlassParser.ServiceDeclarationContext)this.elementContext, this.getMacroElementBuilder(), this.getSourceCodeBuilder(), urlBuilder, verb, serviceMultiplicity);
        for (AntlrServiceCriteria serviceCriteria : this.serviceCriterias) {
            String serviceCriteriaKeyword = serviceCriteria.getServiceCriteriaKeyword();
            AntlrCriteria criteria = serviceCriteria.getCriteria();
            this.elementBuilder.addCriteriaBuilder(serviceCriteriaKeyword, criteria.build());
        }
        Optional<ServiceProjectionDispatchImpl.ServiceProjectionDispatchBuilder> projectionDispatchBuilder = this.serviceProjectionDispatch.map(AntlrServiceProjectionDispatch::build);
        this.elementBuilder.setProjectionDispatchBuilder(projectionDispatchBuilder);
        Optional<OrderByImpl.OrderByBuilder> orderByBuilder = this.orderBy.map(AntlrOrderBy::build);
        this.elementBuilder.setOrderByBuilder(orderByBuilder);
        return this.elementBuilder;
    }

    @Nonnull
    public ServiceImpl.ServiceBuilder getElementBuilder() {
        return Objects.requireNonNull(this.elementBuilder);
    }

    @Nonnull
    public KlassParser.ServiceDeclarationContext getElementContext() {
        return (KlassParser.ServiceDeclarationContext)super.getElementContext();
    }
}

