/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler;

import cool.klass.model.converter.compiler.CompilationResult;
import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.CompilerInputState;
import cool.klass.model.converter.compiler.CompilerWalkState;
import cool.klass.model.converter.compiler.annotation.AbstractCompilerAnnotation;
import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.annotation.RootCompilerAnnotation;
import cool.klass.model.converter.compiler.parser.AntlrUtils;
import cool.klass.model.converter.compiler.parser.DelegatingKlassListener;
import cool.klass.model.converter.compiler.phase.AbstractCompilerPhase;
import cool.klass.model.converter.compiler.state.AntlrDomainModel;
import cool.klass.model.converter.compiler.state.AntlrElement;
import cool.klass.model.meta.domain.DomainModelImpl;
import cool.klass.model.meta.domain.api.source.DomainModelWithSourceCode;
import cool.klass.model.meta.grammar.KlassListener;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.impl.factory.Lists;

public class CompilerState {
    @Nonnull
    private final CompilerInputState compilerInput;
    private final CompilerAnnotationHolder compilerAnnotationHolder = new CompilerAnnotationHolder();
    private final AntlrDomainModel domainModel = new AntlrDomainModel();
    private CompilerWalkState compilerWalk = new CompilerWalkState(this.domainModel);

    public CompilerState(@Nonnull ImmutableList<CompilationUnit> compilationUnits) {
        this.compilerInput = new CompilerInputState((ImmutableCollection<CompilationUnit>)compilationUnits);
    }

    public void runInPlaceCompilerMacro(@Nonnull AntlrElement macroElement, @Nonnull AbstractCompilerPhase macroExpansionCompilerPhase, @Nonnull String sourceCodeText, @Nonnull Function<KlassParser, ? extends ParserRuleContext> parserRule, ParserRuleContext inPlaceContext, ParseTreeListener ... listeners) {
        Objects.requireNonNull(macroElement);
        CompilationUnit compilationUnit = CompilationUnit.getMacroCompilationUnit(this.compilerInput.getCompilationUnits().size(), macroElement, macroExpansionCompilerPhase, sourceCodeText, parserRule);
        ParserRuleContext parserContext = compilationUnit.getParserContext();
        parserContext.setParent((RuleContext)inPlaceContext);
        inPlaceContext.addChild((RuleContext)parserContext);
        this.compilerWalk.withInPlaceCompilationUnit(compilationUnit, () -> this.compilerInput.runInPlaceCompilerMacro(compilationUnit, (ImmutableList<ParseTreeListener>)Lists.immutable.with((Object[])listeners)));
    }

    public void runRootCompilerMacro(@Nonnull AntlrElement macroElement, @Nonnull AbstractCompilerPhase macroExpansionCompilerPhase, @Nonnull String sourceCodeText, @Nonnull Function<KlassParser, ? extends ParserRuleContext> parserRule, @Nonnull ImmutableList<ParseTreeListener> listeners) {
        CompilationUnit compilationUnit = CompilationUnit.getMacroCompilationUnit(this.compilerInput.getCompilationUnits().size(), macroElement, macroExpansionCompilerPhase, sourceCodeText, parserRule);
        this.runRootCompilerMacro(listeners, compilationUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runRootCompilerMacro(@Nonnull ImmutableList<ParseTreeListener> listeners, @Nonnull CompilationUnit compilationUnit) {
        CompilerWalkState oldCompilerWalk = this.compilerWalk;
        try {
            this.compilerWalk = new CompilerWalkState(this.domainModel);
            this.compilerInput.runCompilerMacro(compilationUnit, listeners);
        }
        finally {
            this.compilerWalk = oldCompilerWalk;
        }
    }

    public void reportErrors() {
        this.domainModel.reportErrors(this.compilerAnnotationHolder);
    }

    @Nonnull
    public CompilationResult getCompilationResult(ImmutableList<RootCompilerAnnotation> compilerAnnotations) {
        if (compilerAnnotations.anySatisfy(AbstractCompilerAnnotation::isError)) {
            return new CompilationResult(compilerAnnotations, Optional.empty());
        }
        return new CompilationResult(compilerAnnotations, Optional.of(this.buildDomainModel()));
    }

    @Nonnull
    private DomainModelWithSourceCode buildDomainModel() {
        ImmutableList<RootCompilerAnnotation> compilerAnnotations = this.compilerAnnotationHolder.getCompilerAnnotations();
        if (compilerAnnotations.anySatisfy(AbstractCompilerAnnotation::isError)) {
            throw new AssertionError((Object)this.compilerAnnotationHolder.getCompilerAnnotations().makeString("\n"));
        }
        ImmutableList compilationUnits = this.compilerInput.getCompilationUnits().toImmutable();
        DomainModelImpl.DomainModelBuilder domainModelBuilder = this.domainModel.build((ImmutableList<CompilationUnit>)compilationUnits);
        return domainModelBuilder.build();
    }

    @Nonnull
    public AntlrDomainModel getDomainModel() {
        return this.domainModel;
    }

    @Nonnull
    public CompilerInputState getCompilerInput() {
        return this.compilerInput;
    }

    @Nonnull
    public CompilerAnnotationHolder getCompilerAnnotationHolder() {
        return this.compilerAnnotationHolder;
    }

    public CompilerWalkState getCompilerWalk() {
        return this.compilerWalk;
    }

    public Integer getOrdinal(@Nonnull ParserRuleContext ctx) {
        KlassParser.TopLevelDeclarationContext topLevelDeclarationContext = AntlrUtils.getParentOfType(ctx, KlassParser.TopLevelDeclarationContext.class);
        if (ctx == topLevelDeclarationContext) {
            throw new AssertionError(ctx);
        }
        Integer topLevelElementOrdinalByContext = this.domainModel.getTopLevelElementOrdinalByContext(topLevelDeclarationContext);
        Objects.requireNonNull(topLevelElementOrdinalByContext);
        return topLevelElementOrdinalByContext;
    }

    @Nonnull
    public KlassListener asListener() {
        return new ListenerView();
    }

    public class ListenerView
    extends DelegatingKlassListener {
        @Override
        protected KlassListener getDelegate() {
            return CompilerState.this.compilerWalk.asListener();
        }

        @Override
        public void enterCompilationUnit(@Nonnull KlassParser.CompilationUnitContext ctx) {
            super.enterCompilationUnit(ctx);
            CompilationUnit currentCompilationUnit = CompilerState.this.compilerInput.getCompilationUnitByContext((ParserRuleContext)ctx);
            CompilerState.this.compilerWalk.enterCompilationUnit(currentCompilationUnit);
        }

        @Override
        public void exitCompilationUnit(@Nonnull KlassParser.CompilationUnitContext ctx) {
            super.exitCompilationUnit(ctx);
            CompilerState.this.compilerWalk.exitCompilationUnit();
        }
    }
}

