/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.phase;

import com.google.common.base.CaseFormat;
import cool.klass.model.converter.compiler.CompilerState;
import cool.klass.model.converter.compiler.phase.AbstractCompilerPhase;
import cool.klass.model.converter.compiler.phase.AssociationPhase;
import cool.klass.model.converter.compiler.phase.CompilationUnitPhase;
import cool.klass.model.converter.compiler.phase.TopLevelElementsPhase;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.property.AntlrDataTypeProperty;
import cool.klass.model.converter.compiler.state.property.AntlrModifier;
import cool.klass.model.converter.compiler.state.property.AntlrProperty;
import cool.klass.model.converter.compiler.state.property.AntlrReferenceProperty;
import cool.klass.model.meta.grammar.KlassParser;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.impl.factory.Lists;

public class AuditAssociationInferencePhase
extends AbstractCompilerPhase {
    public AuditAssociationInferencePhase(@Nonnull CompilerState compilerState) {
        super(compilerState);
    }

    @Override
    @Nonnull
    public String getName() {
        return "Audit association";
    }

    @Override
    public void enterClassifierModifier(@Nonnull KlassParser.ClassifierModifierContext ctx) {
        super.enterClassifierModifier(ctx);
        String modifierText = ctx.getText();
        if ("audited".equals(modifierText)) {
            this.addAuditProperties();
        }
    }

    private boolean hasAuditReferenceProperty(Predicate<AntlrReferenceProperty> predicate) {
        return this.compilerState.getCompilerWalk().getKlass().getAllProperties().selectInstancesOf(AntlrReferenceProperty.class).asLazy().anySatisfy(predicate);
    }

    private boolean hasAuditDataTypeProperty(Predicate<AntlrDataTypeProperty> predicate) {
        return this.compilerState.getCompilerWalk().getKlass().getAllDataTypeProperties().count(predicate) == 1;
    }

    private void addAuditProperties() {
        String sourceCode;
        boolean needsLastUpdatedBy;
        Optional<AntlrClass> maybeUserClass = this.compilerState.getDomainModel().getUserClass();
        if (maybeUserClass.isEmpty()) {
            return;
        }
        AntlrClass userClass = maybeUserClass.get();
        int userIdProperties = userClass.getAllDataTypeProperties().count(AntlrDataTypeProperty::isUserId);
        if (userIdProperties != 1) {
            return;
        }
        boolean needsCreatedBy = !this.hasAuditReferenceProperty((Predicate<AntlrReferenceProperty>)((Predicate & Serializable)AntlrProperty::isCreatedBy)) && this.hasAuditDataTypeProperty((Predicate<AntlrDataTypeProperty>)((Predicate & Serializable)AntlrProperty::isCreatedBy));
        boolean bl = needsLastUpdatedBy = !this.hasAuditReferenceProperty((Predicate<AntlrReferenceProperty>)((Predicate & Serializable)AntlrProperty::isLastUpdatedBy)) && this.hasAuditDataTypeProperty((Predicate<AntlrDataTypeProperty>)((Predicate & Serializable)AntlrProperty::isLastUpdatedBy));
        if (!needsCreatedBy && !needsLastUpdatedBy) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        AntlrClass klass = this.compilerState.getCompilerWalk().getKlass();
        stringBuilder.append("package ").append(klass.getPackageName()).append("\n");
        if (needsCreatedBy) {
            sourceCode = this.getSourceCode(userClass, "createdBy", (Predicate<AntlrDataTypeProperty>)((Predicate & Serializable)AntlrProperty::isCreatedBy), true);
            stringBuilder.append(sourceCode);
        }
        if (needsLastUpdatedBy) {
            sourceCode = this.getSourceCode(userClass, "lastUpdatedBy", (Predicate<AntlrDataTypeProperty>)((Predicate & Serializable)AntlrProperty::isLastUpdatedBy), false);
            stringBuilder.append(sourceCode);
        }
        this.runCompilerMacro(stringBuilder.toString());
    }

    private void runCompilerMacro(String sourceCode) {
        AntlrModifier classifierModifierState = this.compilerState.getCompilerWalk().getClassifierModifier();
        ImmutableList compilerPhases = Lists.immutable.with((Object)new CompilationUnitPhase(this.compilerState), (Object)new TopLevelElementsPhase(this.compilerState), (Object)new AssociationPhase(this.compilerState));
        this.compilerState.runRootCompilerMacro(classifierModifierState, this, sourceCode, (Function<KlassParser, ? extends ParserRuleContext>)((Function & Serializable)KlassParser::compilationUnit), (ImmutableList<ParseTreeListener>)compilerPhases);
    }

    @Nonnull
    private String getSourceCode(AntlrClass userClass, String modifier, Predicate<AntlrDataTypeProperty> predicate, boolean isFinal) {
        String suffix = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, modifier);
        AntlrClass klass = this.compilerState.getCompilerWalk().getKlass();
        String className = klass.getName();
        String associationEndName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, className);
        String userIdPropertyName = ((AntlrDataTypeProperty)userClass.getAllDataTypeProperties().detect(AntlrDataTypeProperty::isUserId)).getName();
        String finalModifier = isFinal ? " final" : "";
        AntlrDataTypeProperty auditProperty = (AntlrDataTypeProperty)klass.getAllDataTypeProperties().detect(predicate);
        return "\nassociation " + className + "Has" + suffix + "\n{\n    " + associationEndName + suffix + ": " + className + "[0..*];\n    " + modifier + ": " + userClass.getName() + "[1..1] " + modifier + finalModifier + ";\n\n    relationship this." + auditProperty.getName() + " == " + userClass.getName() + "." + userIdPropertyName + "\n}\n";
    }
}

