/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.phase;

import cool.klass.model.converter.compiler.CompilerState;
import cool.klass.model.converter.compiler.CompilerWalkState;
import cool.klass.model.converter.compiler.phase.ReferencePropertyPhase;
import cool.klass.model.converter.compiler.phase.criteria.CriteriaVisitor;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.AntlrEnumeration;
import cool.klass.model.converter.compiler.state.AntlrPrimitiveType;
import cool.klass.model.converter.compiler.state.AntlrType;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.criteria.AntlrCriteria;
import cool.klass.model.converter.compiler.state.parameter.AntlrParameter;
import cool.klass.model.converter.compiler.state.parameter.AntlrParameterOwner;
import cool.klass.model.converter.compiler.state.property.AntlrModifier;
import cool.klass.model.converter.compiler.state.property.AntlrParameterizedProperty;
import cool.klass.model.meta.domain.api.PrimitiveType;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class ParameterizedPropertyPhase
extends ReferencePropertyPhase {
    @Nullable
    private AntlrParameterizedProperty parameterizedProperty;
    @Nullable
    private AntlrParameter parameter;
    @Nullable
    private IAntlrElement criteriaOwner;
    @Nullable
    private AntlrParameterOwner parameterOwner;

    public ParameterizedPropertyPhase(@Nonnull CompilerState compilerState) {
        super(compilerState);
    }

    @Override
    public void enterParameterizedProperty(@Nonnull KlassParser.ParameterizedPropertyContext ctx) {
        super.enterParameterizedProperty(ctx);
        if (this.parameterizedProperty != null) {
            throw new IllegalStateException();
        }
        if (this.parameterOwner != null) {
            throw new IllegalStateException();
        }
        if (this.criteriaOwner != null) {
            throw new IllegalStateException();
        }
        if (this.classReferenceOwner != null) {
            throw new IllegalStateException();
        }
        if (this.multiplicityOwner != null) {
            throw new IllegalStateException();
        }
        CompilerWalkState compilerWalk = this.compilerState.getCompilerWalk();
        AntlrClass thisReference = (AntlrClass)compilerWalk.getThisReference();
        this.parameterizedProperty = new AntlrParameterizedProperty(ctx, Optional.of(compilerWalk.getCurrentCompilationUnit()), compilerWalk.getNumClassifierMembers(), ctx.identifier(), thisReference);
        thisReference.enterParameterizedProperty(this.parameterizedProperty);
        this.parameterOwner = this.parameterizedProperty;
        this.criteriaOwner = this.parameterizedProperty;
        this.classReferenceOwner = this.parameterizedProperty;
        this.multiplicityOwner = this.parameterizedProperty;
        this.handleClassReference(ctx.classReference());
        this.handleMultiplicity(ctx.multiplicity());
        CriteriaVisitor visitor = new CriteriaVisitor(this.compilerState, this.parameterizedProperty);
        KlassParser.CriteriaExpressionContext criteriaExpressionContext = ctx.criteriaExpression();
        AntlrCriteria criteria = (AntlrCriteria)visitor.visit((ParseTree)criteriaExpressionContext);
        this.parameterizedProperty.setCriteria(criteria);
    }

    @Override
    public void exitParameterizedProperty(@Nonnull KlassParser.ParameterizedPropertyContext ctx) {
        this.parameterizedProperty = null;
        this.parameterOwner = null;
        this.criteriaOwner = null;
        this.classReferenceOwner = null;
        this.multiplicityOwner = null;
        super.exitParameterizedProperty(ctx);
    }

    @Override
    public void enterRelationship(@Nonnull KlassParser.RelationshipContext ctx) {
        super.enterRelationship(ctx);
        if (this.parameterizedProperty == null) {
            return;
        }
        CriteriaVisitor visitor = new CriteriaVisitor(this.compilerState, this.criteriaOwner);
        AntlrCriteria criteria = (AntlrCriteria)visitor.visit((ParseTree)ctx.criteriaExpression());
        this.parameterizedProperty.setCriteria(criteria);
    }

    @Override
    public void enterPrimitiveParameterDeclaration(@Nonnull KlassParser.PrimitiveParameterDeclarationContext ctx) {
        super.enterPrimitiveParameterDeclaration(ctx);
        if (this.parameterizedProperty == null) {
            return;
        }
        String primitiveTypeName = ctx.primitiveType().getText();
        PrimitiveType primitiveType = PrimitiveType.byPrettyName((String)primitiveTypeName);
        AntlrPrimitiveType primitiveTypeState = AntlrPrimitiveType.valueOf(primitiveType);
        this.enterParameterDeclaration((ParserRuleContext)ctx, primitiveTypeState, ctx.identifier());
    }

    @Override
    public void exitPrimitiveParameterDeclaration(@Nonnull KlassParser.PrimitiveParameterDeclarationContext ctx) {
        this.parameter = null;
        this.multiplicityOwner = null;
        super.exitPrimitiveParameterDeclaration(ctx);
    }

    @Override
    public void enterEnumerationParameterDeclaration(@Nonnull KlassParser.EnumerationParameterDeclarationContext ctx) {
        super.enterEnumerationParameterDeclaration(ctx);
        if (this.parameterizedProperty == null) {
            return;
        }
        String enumerationName = ctx.enumerationReference().getText();
        AntlrEnumeration enumeration = this.compilerState.getDomainModel().getEnumerationByName(enumerationName);
        this.enterParameterDeclaration((ParserRuleContext)ctx, enumeration, ctx.identifier());
    }

    @Override
    public void exitEnumerationParameterDeclaration(@Nonnull KlassParser.EnumerationParameterDeclarationContext ctx) {
        this.parameter = null;
        this.multiplicityOwner = null;
        super.exitEnumerationParameterDeclaration(ctx);
    }

    @Override
    public void enterParameterDeclarationList(@Nonnull KlassParser.ParameterDeclarationListContext ctx) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".enterParameterDeclarationList() not implemented yet");
    }

    @Override
    public void exitParameterDeclarationList(@Nonnull KlassParser.ParameterDeclarationListContext ctx) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".exitParameterDeclarationList() not implemented yet");
    }

    @Override
    public void enterParameterModifier(@Nonnull KlassParser.ParameterModifierContext ctx) {
        super.enterParameterModifier(ctx);
        if (this.parameterizedProperty == null && this.parameter == null) {
            return;
        }
        int ordinal = this.parameter.getNumModifiers();
        AntlrModifier modifier = new AntlrModifier((ParserRuleContext)ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), ordinal, this.parameter);
        this.parameter.enterModifier(modifier);
    }

    private void enterParameterDeclaration(@Nonnull ParserRuleContext ctx, @Nonnull AntlrType typeState, @Nonnull KlassParser.IdentifierContext identifierContext) {
        if (this.parameter != null) {
            throw new IllegalStateException();
        }
        this.parameter = new AntlrParameter(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), this.parameterOwner.getNumParameters() + 1, identifierContext, typeState, (IAntlrElement)((Object)this.parameterOwner));
        this.multiplicityOwner = this.parameter;
        this.parameterOwner.enterParameterDeclaration(this.parameter);
    }
}

