/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.phase;

import cool.klass.model.converter.compiler.CompilerState;
import cool.klass.model.converter.compiler.phase.AbstractCompilerPhase;
import cool.klass.model.converter.compiler.state.AntlrEnumeration;
import cool.klass.model.converter.compiler.state.AntlrMultiplicity;
import cool.klass.model.converter.compiler.state.AntlrMultiplicityOwner;
import cool.klass.model.converter.compiler.state.AntlrPrimitiveType;
import cool.klass.model.converter.compiler.state.AntlrType;
import cool.klass.model.converter.compiler.state.parameter.AntlrParameter;
import cool.klass.model.converter.compiler.state.property.AntlrModifier;
import cool.klass.model.converter.compiler.state.service.url.AntlrUrl;
import cool.klass.model.converter.compiler.state.service.url.AntlrUrlConstant;
import cool.klass.model.meta.domain.api.PrimitiveType;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ParserRuleContext;

public class UrlParameterPhase
extends AbstractCompilerPhase {
    @Nullable
    private Boolean inQueryParameterList;
    @Nullable
    private AntlrParameter parameter;
    @Nullable
    private AntlrMultiplicityOwner multiplicityOwner;

    public UrlParameterPhase(@Nonnull CompilerState compilerState) {
        super(compilerState);
    }

    @Override
    public void enterUrlDeclaration(@Nonnull KlassParser.UrlDeclarationContext ctx) {
        super.enterUrlDeclaration(ctx);
        this.inQueryParameterList = false;
    }

    @Override
    public void exitUrlDeclaration(@Nonnull KlassParser.UrlDeclarationContext ctx) {
        this.inQueryParameterList = null;
        super.exitUrlDeclaration(ctx);
    }

    @Override
    public void enterUrlConstant(@Nonnull KlassParser.UrlConstantContext ctx) {
        super.enterUrlConstant(ctx);
        AntlrUrl url = this.compilerState.getCompilerWalk().getUrl();
        AntlrUrlConstant antlrUrlConstant = new AntlrUrlConstant(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), url.getNumPathSegments() + 1, ctx.identifier());
        url.enterUrlConstant(antlrUrlConstant);
    }

    @Override
    public void enterQueryParameterList(@Nonnull KlassParser.QueryParameterListContext ctx) {
        super.enterQueryParameterList(ctx);
        this.inQueryParameterList = true;
    }

    @Override
    public void enterPrimitiveParameterDeclaration(@Nonnull KlassParser.PrimitiveParameterDeclarationContext ctx) {
        super.enterPrimitiveParameterDeclaration(ctx);
        if (this.compilerState.getCompilerWalk().getUrl() == null) {
            return;
        }
        String primitiveTypeName = ctx.primitiveType().getText();
        PrimitiveType primitiveType = PrimitiveType.byPrettyName((String)primitiveTypeName);
        AntlrPrimitiveType primitiveTypeState = AntlrPrimitiveType.valueOf(primitiveType);
        this.enterParameterDeclaration((ParserRuleContext)ctx, primitiveTypeState, ctx.identifier());
    }

    @Override
    public void exitPrimitiveParameterDeclaration(@Nonnull KlassParser.PrimitiveParameterDeclarationContext ctx) {
        this.parameter = null;
        this.multiplicityOwner = null;
        super.exitPrimitiveParameterDeclaration(ctx);
    }

    @Override
    public void enterEnumerationParameterDeclaration(@Nonnull KlassParser.EnumerationParameterDeclarationContext ctx) {
        super.enterEnumerationParameterDeclaration(ctx);
        if (this.compilerState.getCompilerWalk().getUrl() == null) {
            return;
        }
        String enumerationName = ctx.enumerationReference().getText();
        AntlrEnumeration enumeration = this.compilerState.getDomainModel().getEnumerationByName(enumerationName);
        this.enterParameterDeclaration((ParserRuleContext)ctx, enumeration, ctx.identifier());
    }

    @Override
    public void exitEnumerationParameterDeclaration(@Nonnull KlassParser.EnumerationParameterDeclarationContext ctx) {
        this.parameter = null;
        this.multiplicityOwner = null;
        super.exitEnumerationParameterDeclaration(ctx);
    }

    @Override
    public void enterParameterModifier(@Nonnull KlassParser.ParameterModifierContext ctx) {
        super.enterParameterModifier(ctx);
        int ordinal = this.parameter.getNumModifiers();
        AntlrModifier modifier = new AntlrModifier((ParserRuleContext)ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), ordinal, this.parameter);
        this.parameter.enterModifier(modifier);
    }

    private void enterParameterDeclaration(@Nonnull ParserRuleContext ctx, @Nonnull AntlrType type, @Nonnull KlassParser.IdentifierContext identifierContext) {
        if (this.parameter != null) {
            throw new AssertionError();
        }
        AntlrUrl url = this.compilerState.getCompilerWalk().getUrl();
        int ordinal = this.inQueryParameterList != false ? url.getNumQueryParameters() + 1 : url.getNumPathSegments() + 1;
        this.parameter = new AntlrParameter(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), ordinal, identifierContext, type, url);
        this.multiplicityOwner = this.parameter;
        if (this.inQueryParameterList.booleanValue()) {
            url.enterQueryParameterDeclaration(this.parameter);
        } else {
            url.enterPathParameterDeclaration(this.parameter);
        }
    }

    @Override
    public void enterMultiplicity(@Nonnull KlassParser.MultiplicityContext ctx) {
        super.enterMultiplicity(ctx);
        if (this.multiplicityOwner != null) {
            AntlrMultiplicity multiplicity = new AntlrMultiplicity(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), this.multiplicityOwner);
            this.multiplicityOwner.enterMultiplicity(multiplicity);
        }
    }
}

