/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.phase;

import com.google.common.base.CaseFormat;
import cool.klass.model.converter.compiler.CompilerState;
import cool.klass.model.converter.compiler.phase.AbstractCompilerPhase;
import cool.klass.model.converter.compiler.phase.AssociationPhase;
import cool.klass.model.converter.compiler.phase.CompilationUnitPhase;
import cool.klass.model.converter.compiler.phase.TopLevelElementsPhase;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.AntlrNamedElement;
import cool.klass.model.converter.compiler.state.property.AntlrDataTypeProperty;
import cool.klass.model.converter.compiler.state.property.AntlrModifier;
import cool.klass.model.meta.grammar.KlassParser;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.impl.factory.Lists;

public class VersionAssociationInferencePhase
extends AbstractCompilerPhase {
    public VersionAssociationInferencePhase(@Nonnull CompilerState compilerState) {
        super(compilerState);
    }

    @Override
    @Nonnull
    public String getName() {
        return "Version association";
    }

    @Override
    public void enterClassifierModifier(@Nonnull KlassParser.ClassifierModifierContext ctx) {
        super.enterClassifierModifier(ctx);
        String modifierText = ctx.getText();
        if (!"versioned".equals(modifierText)) {
            return;
        }
        AntlrClass klass = this.compilerState.getCompilerWalk().getKlass();
        ImmutableList<AntlrDataTypeProperty<?>> allKeyProperties = klass.getAllKeyProperties();
        if (allKeyProperties.isEmpty()) {
            return;
        }
        AntlrModifier classifierModifierState = this.compilerState.getCompilerWalk().getClassifierModifier();
        String klassSourceCode = this.getSourceCode(allKeyProperties);
        ImmutableList compilerPhases = Lists.immutable.with((Object)new CompilationUnitPhase(this.compilerState), (Object)new TopLevelElementsPhase(this.compilerState), (Object)new AssociationPhase(this.compilerState));
        this.compilerState.runRootCompilerMacro(classifierModifierState, this, klassSourceCode, (Function<KlassParser, ? extends ParserRuleContext>)((Function & Serializable)KlassParser::compilationUnit), (ImmutableList<ParseTreeListener>)compilerPhases);
    }

    @Nonnull
    private String getSourceCode(@Nonnull ImmutableList<AntlrDataTypeProperty<?>> keyProperties) {
        AntlrClass klass = this.compilerState.getCompilerWalk().getKlass();
        String className = klass.getName();
        String relationshipKeyClauses = keyProperties.collect(AntlrNamedElement::getName).collect((Function & Serializable)each -> "this." + each + " == " + className + "Version." + each).makeString("\n        && ");
        String associationEndName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, className);
        return "package " + klass.getPackageName() + "\n\nassociation " + className + "HasVersion\n{\n    " + associationEndName + ": " + className + "[1..1];\n    version: " + className + "Version[1..1] owned version;\n\n    relationship " + relationshipKeyClauses + "\n}\n";
    }
}

