/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.meta.domain.AbstractElement;
import cool.klass.model.meta.domain.api.source.SourceCode;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;

public abstract class AntlrElement
implements IAntlrElement {
    public static final ParserRuleContext AMBIGUOUS_PARENT = new ParserRuleContext();
    public static final ParserRuleContext NOT_FOUND_PARENT = new ParserRuleContext();
    @Nonnull
    protected final ParserRuleContext elementContext;
    @Nonnull
    protected final Optional<CompilationUnit> compilationUnit;

    protected AntlrElement(@Nonnull ParserRuleContext elementContext, @Nonnull Optional<CompilationUnit> compilationUnit) {
        this.elementContext = Objects.requireNonNull(elementContext);
        this.compilationUnit = Objects.requireNonNull(compilationUnit);
        compilationUnit.ifPresent(cu -> AntlrElement.assertContextContains(cu.getParserContext(), elementContext));
    }

    private static void assertContextContains(ParserRuleContext parentContext, ParserRuleContext childContext) {
        if (parentContext == childContext) {
            return;
        }
        ParserRuleContext nextParent = childContext.getParent();
        Objects.requireNonNull(nextParent);
        AntlrElement.assertContextContains(parentContext, nextParent);
    }

    public static String getSourceTextLenient(ParserRuleContext parserRuleContext) {
        Objects.requireNonNull(parserRuleContext);
        Token start = parserRuleContext.getStart();
        Token stop = parserRuleContext.getStop();
        ParserRuleContext parent = parserRuleContext.getParent();
        RuleContext payload = parserRuleContext.getPayload();
        RuleContext ruleContext = parserRuleContext.getRuleContext();
        int childCount = parserRuleContext.getChildCount();
        if (start == null || stop == null || parent == null && !(parserRuleContext instanceof KlassParser.CompilationUnitContext) || payload != parserRuleContext || ruleContext != parserRuleContext || childCount == 0) {
            if (start != null) {
                throw new AssertionError();
            }
            if (stop != null) {
                throw new AssertionError();
            }
            if (payload != parserRuleContext) {
                throw new AssertionError();
            }
            if (ruleContext != parserRuleContext) {
                throw new AssertionError();
            }
            if (childCount != 0) {
                throw new AssertionError();
            }
            if (parent == AMBIGUOUS_PARENT) {
                return "AMBIGUOUS";
            }
            if (parent == NOT_FOUND_PARENT) {
                return "NOT_FOUND";
            }
            throw new AssertionError();
        }
        int startIndex = start.getStartIndex();
        int stopIndex = stop.getStopIndex();
        Interval interval = new Interval(startIndex, stopIndex);
        return start.getInputStream().getText(interval);
    }

    protected static String getSourceText(ParserRuleContext parserRuleContext) {
        Objects.requireNonNull(parserRuleContext.getStart());
        Objects.requireNonNull(parserRuleContext.getStop());
        int startIndex = parserRuleContext.getStart().getStartIndex();
        int stopIndex = parserRuleContext.getStop().getStopIndex();
        Interval interval = new Interval(startIndex, stopIndex);
        return parserRuleContext.getStart().getInputStream().getText(interval);
    }

    @Override
    @Nonnull
    public ParserRuleContext getElementContext() {
        return this.elementContext;
    }

    @Nonnull
    public AbstractElement.ElementBuilder<?> getElementBuilder() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getElementBuilder() not implemented yet");
    }

    @Override
    @Nonnull
    public Optional<AntlrElement> getMacroElement() {
        return this.compilationUnit.flatMap(CompilationUnit::getMacroElement);
    }

    public boolean hasMacro() {
        return this.getMacroElement().isPresent();
    }

    @Nonnull
    protected Optional<AbstractElement.ElementBuilder<?>> getMacroElementBuilder() {
        return this.getMacroElement().map(antlrElement -> Objects.requireNonNull(antlrElement.getElementBuilder()));
    }

    protected SourceCode.SourceCodeBuilder getSourceCodeBuilder() {
        return (SourceCode.SourceCodeBuilder)this.compilationUnit.map(CompilationUnit::build).orElseThrow();
    }

    @Override
    @Nonnull
    public Optional<CompilationUnit> getCompilationUnit() {
        return this.compilationUnit;
    }

    public boolean isInSameCompilationUnit(AntlrElement other) {
        return this.compilationUnit.isPresent() && other.compilationUnit.isPresent() && this.compilationUnit.equals(other.compilationUnit);
    }

    public boolean isForwardReference(AntlrElement other) {
        return this.isInSameCompilationUnit(other) && this.getElementContext().getStart().getStartIndex() < other.getElementContext().getStart().getStartIndex();
    }

    public String toString() {
        return AntlrElement.getSourceText(this.getElementContext());
    }
}

