/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state.parameter;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.state.AntlrEnumeration;
import cool.klass.model.converter.compiler.state.AntlrIdentifierElement;
import cool.klass.model.converter.compiler.state.AntlrMultiplicity;
import cool.klass.model.converter.compiler.state.AntlrMultiplicityOwner;
import cool.klass.model.converter.compiler.state.AntlrType;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.property.AntlrModifier;
import cool.klass.model.converter.compiler.state.property.AntlrParameterizedProperty;
import cool.klass.model.meta.domain.api.DataType;
import cool.klass.model.meta.domain.parameter.ParameterImpl;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.Lists;

public final class AntlrParameter
extends AntlrIdentifierElement
implements AntlrMultiplicityOwner {
    public static final AntlrParameter AMBIGUOUS = new AntlrParameter(new ParserRuleContext(AMBIGUOUS_PARENT, -1), Optional.empty(), -1, AMBIGUOUS_IDENTIFIER_CONTEXT, AntlrEnumeration.AMBIGUOUS, AntlrParameterizedProperty.AMBIGUOUS);
    public static final AntlrParameter NOT_FOUND = new AntlrParameter(new ParserRuleContext(NOT_FOUND_PARENT, -1), Optional.empty(), -1, NOT_FOUND_IDENTIFIER_CONTEXT, AntlrEnumeration.NOT_FOUND, AntlrParameterizedProperty.AMBIGUOUS);
    @Nonnull
    private final IAntlrElement parameterOwner;
    @Nonnull
    private final AntlrType type;
    private final MutableList<AntlrModifier> modifiers = Lists.mutable.empty();
    @Nullable
    private AntlrMultiplicity multiplicity;
    @Nullable
    private ParameterImpl.ParameterBuilder elementBuilder;

    public AntlrParameter(@Nonnull ParserRuleContext elementContext, @Nonnull Optional<CompilationUnit> compilationUnit, int ordinal, @Nonnull KlassParser.IdentifierContext nameContext, @Nonnull AntlrType type, @Nonnull IAntlrElement parameterOwner) {
        super(elementContext, compilationUnit, ordinal, nameContext);
        this.type = Objects.requireNonNull(type);
        this.parameterOwner = Objects.requireNonNull(parameterOwner);
    }

    @Override
    @Nonnull
    public Optional<IAntlrElement> getSurroundingElement() {
        return Optional.of(this.parameterOwner);
    }

    @Override
    public Pair<Token, Token> getContextBefore() {
        return this.getEntireContext();
    }

    @Override
    protected Pattern getNamePattern() {
        return MEMBER_NAME_PATTERN;
    }

    public int getNumModifiers() {
        return this.modifiers.size();
    }

    @Override
    public void enterMultiplicity(@Nonnull AntlrMultiplicity multiplicity) {
        if (this.multiplicity != null) {
            throw new IllegalStateException();
        }
        this.multiplicity = Objects.requireNonNull(multiplicity);
    }

    public void enterModifier(AntlrModifier modifier) {
        this.modifiers.add((Object)modifier);
    }

    public void reportErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        this.reportNameErrors(compilerAnnotationHolder);
        this.reportTypeErrors(compilerAnnotationHolder);
    }

    private void reportTypeErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        if (this.type != AntlrEnumeration.NOT_FOUND) {
            return;
        }
        KlassParser.EnumerationReferenceContext offendingToken = ((KlassParser.EnumerationParameterDeclarationContext)this.getElementContext()).enumerationReference();
        String message = String.format("Cannot find enumeration '%s'.", offendingToken.getText());
        compilerAnnotationHolder.add("ERR_ENM_PAR", message, (IAntlrElement)this, (ParserRuleContext)offendingToken);
    }

    public void reportDuplicateParameterName(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        String message = String.format("Duplicate parameter: '%s'.", this.getName());
        compilerAnnotationHolder.add("ERR_DUP_PAR", message, this);
    }

    @Nonnull
    public AntlrType getType() {
        return this.type;
    }

    @Nonnull
    public ParameterImpl.ParameterBuilder build() {
        if (this.elementBuilder != null) {
            throw new IllegalStateException();
        }
        this.elementBuilder = new ParameterImpl.ParameterBuilder(this.elementContext, this.getMacroElementBuilder(), this.getSourceCodeBuilder(), this.ordinal, this.getNameContext(), (DataType.DataTypeGetter)this.type.getElementBuilder(), this.multiplicity.getMultiplicity());
        return this.elementBuilder;
    }

    @Nonnull
    public ParameterImpl.ParameterBuilder getElementBuilder() {
        return Objects.requireNonNull(this.elementBuilder);
    }
}

