/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state.property;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.annotation.AnnotationSeverity;
import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.state.AntlrAssociation;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.AntlrClassifier;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.order.AntlrOrderBy;
import cool.klass.model.converter.compiler.state.property.AntlrClassReferenceProperty;
import cool.klass.model.converter.compiler.state.property.AntlrDataTypeProperty;
import cool.klass.model.converter.compiler.state.property.AntlrModifier;
import cool.klass.model.meta.domain.order.OrderByImpl;
import cool.klass.model.meta.domain.property.AssociationEndImpl;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.map.MutableOrderedMap;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.map.ordered.mutable.OrderedMapAdapter;

public class AntlrAssociationEnd
extends AntlrClassReferenceProperty {
    public static final AntlrAssociationEnd AMBIGUOUS = new AntlrAssociationEnd(new KlassParser.AssociationEndContext(AMBIGUOUS_PARENT, -1), Optional.empty(), -1, AMBIGUOUS_IDENTIFIER_CONTEXT, AntlrAssociation.AMBIGUOUS){

        @Override
        @Nonnull
        public AntlrClass getType() {
            return AntlrClass.AMBIGUOUS;
        }

        @Override
        public String toString() {
            return AntlrAssociationEnd.class.getSimpleName() + ".AMBIGUOUS";
        }
    };
    public static final AntlrAssociationEnd NOT_FOUND = new AntlrAssociationEnd(new KlassParser.AssociationEndContext(NOT_FOUND_PARENT, -1), Optional.empty(), -1, NOT_FOUND_IDENTIFIER_CONTEXT, AntlrAssociation.NOT_FOUND){

        @Override
        @Nonnull
        public AntlrClass getType() {
            return AntlrClass.NOT_FOUND;
        }

        @Override
        public String toString() {
            return AntlrAssociationEnd.class.getSimpleName() + ".NOT_FOUND";
        }
    };
    @Nonnull
    private final AntlrAssociation owningAssociation;
    private AntlrClass owningClass;
    private AntlrAssociationEnd opposite;
    private AssociationEndImpl.AssociationEndBuilder associationEnd;
    private final MutableOrderedMap<AntlrDataTypeProperty<?>, AntlrDataTypeProperty<?>> foreignKeys = OrderedMapAdapter.adapt(new LinkedHashMap());

    public AntlrAssociationEnd(@Nonnull KlassParser.AssociationEndContext elementContext, @Nonnull Optional<CompilationUnit> compilationUnit, int ordinal, @Nonnull KlassParser.IdentifierContext nameContext, @Nonnull AntlrAssociation owningAssociation) {
        super((ParserRuleContext)elementContext, compilationUnit, ordinal, nameContext);
        this.owningAssociation = Objects.requireNonNull(owningAssociation);
    }

    @Override
    @Nonnull
    public Optional<IAntlrElement> getSurroundingElement() {
        return Optional.of(this.owningAssociation);
    }

    @Nonnull
    public AntlrAssociation getOwningAssociation() {
        return this.owningAssociation;
    }

    @Nonnull
    public AssociationEndImpl.AssociationEndBuilder build() {
        if (this.associationEnd != null) {
            throw new IllegalStateException();
        }
        this.associationEnd = new AssociationEndImpl.AssociationEndBuilder(this.getElementContext(), this.getMacroElementBuilder(), this.getSourceCodeBuilder(), this.ordinal, this.getNameContext(), this.getType().getElementBuilder(), this.owningClass.getElementBuilder(), this.owningAssociation.getElementBuilder(), this.multiplicity.getMultiplicity());
        ImmutableList modifiers = this.getModifiers().collect(AntlrModifier::build).toImmutable();
        this.associationEnd.setModifiers(modifiers);
        Optional<OrderByImpl.OrderByBuilder> orderBy = this.orderBy.map(AntlrOrderBy::build);
        this.associationEnd.setOrderBy(orderBy);
        return this.associationEnd;
    }

    @Override
    public void reportErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        super.reportErrors(compilerAnnotationHolder);
        this.orderBy.ifPresent(o -> o.reportErrors(compilerAnnotationHolder));
        this.reportInvalidMultiplicity(compilerAnnotationHolder);
        this.reportVersionEndUnowned(compilerAnnotationHolder);
        this.reportNonVersionEnd(compilerAnnotationHolder);
        this.reportNonUserAuditEnd(compilerAnnotationHolder);
        this.reportPluralName(compilerAnnotationHolder);
        this.reportDeclarationOrderTypes(compilerAnnotationHolder);
        this.reportForwardReference(compilerAnnotationHolder);
    }

    private void reportVersionEndUnowned(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        if (this.isVersion() && !this.isOwned()) {
            String message = String.format("Expected version association end '%s.%s' to be owned.", this.getOwningClassifier().getName(), this.getName());
            compilerAnnotationHolder.add("ERR_VER_OWN", message, (IAntlrElement)this, this.nameContext);
        }
    }

    private void reportNonVersionEnd(CompilerAnnotationHolder compilerAnnotationHolder) {
        String message;
        if (this.isVersion() && !this.getType().isVersion()) {
            message = String.format("Expected version association end '%s.%s' to have version type, but %s has no version property.", this.getOwningClassifier().getName(), this.getName(), this.getType().getName());
            compilerAnnotationHolder.add("ERR_VER_END", message, (IAntlrElement)this, this.nameContext);
        }
        if (!(this.getOwningClassifier().isUser() || this.isVersion() || !this.getType().isVersion() || this.opposite.isCreatedBy() || this.opposite.isLastUpdatedBy())) {
            message = String.format("Association end '%s.%s' has version type %s, but is missing the version modifier.", this.getOwningClassifier().getName(), this.getName(), this.getType().getName());
            compilerAnnotationHolder.add("ERR_VER_TYP", message, (IAntlrElement)this, (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)this.nameContext, (Object)this.getElementContext().classReference()));
        }
    }

    private void reportNonUserAuditEnd(CompilerAnnotationHolder compilerAnnotationHolder) {
        String message;
        AntlrModifier modifier;
        if (this.isCreatedBy() && !this.getType().isUser()) {
            modifier = (AntlrModifier)this.getModifiers().detect(AntlrModifier::isCreatedBy);
            message = String.format("Expected createdBy association end '%s.%s' to have user type, but was %s.", this.getOwningClassifier().getName(), this.getName(), this.getType().getName());
            compilerAnnotationHolder.add("ERR_AUD_END", message, (IAntlrElement)modifier, modifier.getSurroundingElements(), (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)this.getElementContext().classReference(), (Object)modifier.getElementContext()));
        }
        if (this.isLastUpdatedBy() && !this.getType().isUser()) {
            modifier = (AntlrModifier)this.getModifiers().detect(AntlrModifier::isLastUpdatedBy);
            message = String.format("Expected lastUpdatedBy association end '%s.%s' to have user type, but was %s.", this.getOwningClassifier().getName(), this.getName(), this.getType().getName());
            compilerAnnotationHolder.add("ERR_AUD_END", message, (IAntlrElement)modifier, modifier.getSurroundingElements(), (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)this.getElementContext().classReference(), (Object)modifier.getElementContext()));
        }
    }

    public void reportDuplicateOppositeWithModifier(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder, @Nonnull AntlrClassifier classifier, @Nonnull String modifierString, @Nonnull AnnotationSeverity severity) {
        AntlrModifier modifier = (AntlrModifier)this.getModifiers().detectWith(AntlrModifier::is, (Object)modifierString);
        String message = String.format("Multiple %s association ends point at '%s'.", modifierString, classifier.getName());
        compilerAnnotationHolder.add("ERR_DUP_END", message, (IAntlrElement)modifier, severity);
    }

    private void reportPluralName(CompilerAnnotationHolder compilerAnnotationHolder) {
        if (this.multiplicity.isToMany() && this.classReference.getElementContext().identifier().getText().toLowerCase().endsWith(this.getName().toLowerCase())) {
            String message = "Expected to-many association end '%s.%s' to have a plural name, but name exactly matched type association end type '%s'.".formatted(this.getOwningClassifier().getName(), this.getName(), this.classReference.getElementContext().identifier().getText());
            compilerAnnotationHolder.add("ERR_ASS_PLU", message, (IAntlrElement)this, this.nameContext);
        }
    }

    private void reportDeclarationOrderTypes(CompilerAnnotationHolder compilerAnnotationHolder) {
        if (!this.isToOneRequired()) {
            return;
        }
        if (this.foreignKeys.isEmpty()) {
            return;
        }
        if (this.isVersion()) {
            return;
        }
        if (this.opposite.getType().isForwardReference(this.getType())) {
            String message = String.format("Association '%s' establishes that type '%s' requires type '%s', so it ought to be declared later in the source file. '%s' is declared on line %d and '%s' is declared on line %d in source file '%s'.", this.owningAssociation.getName(), this.opposite.getType().getName(), this.getType().getName(), this.opposite.getType().getName(), this.opposite.getType().getElementContext().getStart().getLine(), this.getType().getName(), this.getType().getElementContext().getStart().getLine(), this.getCompilationUnit().get().getSourceName());
            compilerAnnotationHolder.add("ERR_ASO_ORD", message, (IAntlrElement)this, (ParserRuleContext)this.getElementContext().classReference());
        }
    }

    private void reportForwardReference(CompilerAnnotationHolder compilerAnnotationHolder) {
        if (!this.owningAssociation.isForwardReference(this.getType())) {
            return;
        }
        String message = String.format("Association end '%s.%s' is declared on line %d and has a forward reference to type '%s' which is declared later in the source file '%s' on line %d.", this.getOwningClassifier().getName(), this.getName(), this.getElementContext().getStart().getLine(), this.getType().getName(), this.getCompilationUnit().get().getSourceName(), this.getType().getElementContext().getStart().getLine());
        compilerAnnotationHolder.add("ERR_ASO_ORD", message, (IAntlrElement)this, (ParserRuleContext)this.getElementContext().classReference());
    }

    @Override
    @Nonnull
    public AntlrClass getOwningClassifier() {
        return Objects.requireNonNull(this.owningClass);
    }

    public void setOwningClass(@Nonnull AntlrClass owningClass) {
        if (this.owningClass != null) {
            throw new IllegalStateException();
        }
        this.owningClass = Objects.requireNonNull(owningClass);
    }

    public boolean isVersioned() {
        return this.opposite.isVersion();
    }

    public void setOpposite(@Nonnull AntlrAssociationEnd opposite) {
        this.opposite = Objects.requireNonNull(opposite);
    }

    @Nonnull
    public AssociationEndImpl.AssociationEndBuilder getElementBuilder() {
        return Objects.requireNonNull(this.associationEnd);
    }

    @Nonnull
    public KlassParser.AssociationEndContext getElementContext() {
        return (KlassParser.AssociationEndContext)super.getElementContext();
    }

    public void addForeignKeyPropertyMatchingProperty(@Nonnull AntlrDataTypeProperty<?> foreignKeyProperty, @Nonnull AntlrDataTypeProperty<?> keyProperty) {
        this.foreignKeys.put(foreignKeyProperty, keyProperty);
        foreignKeyProperty.setKeyMatchingThisForeignKey(this, keyProperty);
        keyProperty.setForeignKeyMatchingThisKey(this, foreignKeyProperty);
    }

    @Override
    protected KlassParser.IdentifierContext getTypeIdentifier() {
        return this.getElementContext().classReference().identifier();
    }

    public boolean isSourceEnd() {
        return this == this.owningAssociation.getSourceEnd();
    }

    public boolean isTargetEnd() {
        return this == this.owningAssociation.getTargetEnd();
    }

    public AntlrAssociationEnd getOpposite() {
        return this.opposite;
    }
}

