/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state.property;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.state.AntlrClassifier;
import cool.klass.model.converter.compiler.state.AntlrEnumeration;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.property.AntlrDataTypeProperty;
import cool.klass.model.converter.compiler.state.property.AntlrModifier;
import cool.klass.model.meta.domain.EnumerationImpl;
import cool.klass.model.meta.domain.property.EnumerationPropertyImpl;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.collections.api.list.ImmutableList;

public class AntlrEnumerationProperty
extends AntlrDataTypeProperty<EnumerationImpl> {
    public static final AntlrEnumerationProperty AMBIGUOUS = new AntlrEnumerationProperty(new KlassParser.EnumerationPropertyContext(AMBIGUOUS_PARENT, -1), Optional.empty(), -1, AMBIGUOUS_IDENTIFIER_CONTEXT, AntlrClassifier.AMBIGUOUS, false, AntlrEnumeration.AMBIGUOUS){

        @Override
        public String toString() {
            return "AntlrEnumerationProperty.AMBIGUOUS";
        }
    };
    public static final AntlrEnumerationProperty NOT_FOUND = new AntlrEnumerationProperty(new KlassParser.EnumerationPropertyContext(NOT_FOUND_PARENT, -1), Optional.empty(), -1, NOT_FOUND_IDENTIFIER_CONTEXT, AntlrClassifier.NOT_FOUND, false, AntlrEnumeration.NOT_FOUND){

        @Override
        public String toString() {
            return "AntlrEnumerationProperty.NOT_FOUND";
        }
    };
    @Nonnull
    private final AntlrEnumeration enumeration;
    private EnumerationPropertyImpl.EnumerationPropertyBuilder elementBuilder;

    public AntlrEnumerationProperty(@Nonnull KlassParser.EnumerationPropertyContext elementContext, @Nonnull Optional<CompilationUnit> compilationUnit, int ordinal, @Nonnull KlassParser.IdentifierContext nameContext, @Nonnull AntlrClassifier owningClassifier, boolean isOptional, @Nonnull AntlrEnumeration enumeration) {
        super((ParserRuleContext)elementContext, compilationUnit, ordinal, nameContext, owningClassifier, isOptional);
        this.enumeration = Objects.requireNonNull(enumeration);
    }

    @Override
    @Nonnull
    public AntlrEnumeration getType() {
        return this.enumeration;
    }

    @Override
    protected ParserRuleContext getTypeParserRuleContext() {
        return this.getElementContext().enumerationReference();
    }

    @Nonnull
    public EnumerationPropertyImpl.EnumerationPropertyBuilder build() {
        if (this.elementBuilder != null) {
            throw new IllegalStateException();
        }
        this.elementBuilder = new EnumerationPropertyImpl.EnumerationPropertyBuilder((KlassParser.EnumerationPropertyContext)this.elementContext, this.getMacroElementBuilder(), this.getSourceCodeBuilder(), this.ordinal, this.getNameContext(), this.enumeration.getElementBuilder(), this.owningClassifier.getElementBuilder(), this.isOptional);
        ImmutableList modifierBuilders = this.getModifiers().collect(AntlrModifier::build).toImmutable();
        this.elementBuilder.setModifierBuilders(modifierBuilders);
        this.buildValidations();
        return this.elementBuilder;
    }

    @Nonnull
    public EnumerationPropertyImpl.EnumerationPropertyBuilder getElementBuilder() {
        return Objects.requireNonNull(this.elementBuilder);
    }

    @Override
    public String getTypeName() {
        return this.getElementContext().enumerationReference().getText();
    }

    @Override
    public void reportErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        super.reportErrors(compilerAnnotationHolder);
        this.reportTypeNotFound(compilerAnnotationHolder);
        this.reportForwardReference(compilerAnnotationHolder);
    }

    private void reportTypeNotFound(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        if (this.enumeration != AntlrEnumeration.NOT_FOUND) {
            return;
        }
        KlassParser.EnumerationReferenceContext offendingToken = this.getElementContext().enumerationReference();
        String message = String.format("Cannot find enumeration '%s'.", offendingToken.getText());
        compilerAnnotationHolder.add("ERR_ENM_PRP", message, (IAntlrElement)this, (ParserRuleContext)offendingToken);
    }

    private void reportForwardReference(CompilerAnnotationHolder compilerAnnotationHolder) {
        if (!this.isForwardReference(this.enumeration)) {
            return;
        }
        String message = String.format("Enumeration property '%s' is declared on line %d and has a forward reference to enumeration '%s' which is declared later in the source file '%s' on line %d.", this, this.getElementContext().getStart().getLine(), this.enumeration.getName(), this.getCompilationUnit().get().getSourceName(), this.enumeration.getElementContext().getStart().getLine());
        compilerAnnotationHolder.add("ERR_FWD_REF", message, (IAntlrElement)this, (ParserRuleContext)this.getElementContext().enumerationReference());
    }

    @Override
    protected void reportInvalidIdProperties(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        ImmutableList<AntlrModifier> idModifiers = this.getModifiersByName("id");
        for (AntlrModifier idModifier : idModifiers) {
            String message = "Enumeration properties may not be auto-generated ids.";
            compilerAnnotationHolder.add("ERR_ENM_IDP", message, (IAntlrElement)this, idModifier.getElementContext());
        }
    }

    @Nonnull
    public KlassParser.EnumerationPropertyContext getElementContext() {
        return (KlassParser.EnumerationPropertyContext)super.getElementContext();
    }
}

