/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state.property;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.AntlrClassifier;
import cool.klass.model.converter.compiler.state.AntlrPrimitiveType;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.property.AntlrDataTypeProperty;
import cool.klass.model.converter.compiler.state.property.AntlrEnumerationProperty;
import cool.klass.model.converter.compiler.state.property.AntlrModifier;
import cool.klass.model.meta.domain.api.PrimitiveType;
import cool.klass.model.meta.domain.property.PrimitivePropertyImpl;
import cool.klass.model.meta.grammar.KlassParser;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.list.ImmutableList;

public class AntlrPrimitiveProperty
extends AntlrDataTypeProperty<PrimitiveType> {
    public static final AntlrPrimitiveProperty AMBIGUOUS = new AntlrPrimitiveProperty(new KlassParser.PrimitivePropertyContext(AMBIGUOUS_PARENT, -1), Optional.empty(), -1, AMBIGUOUS_IDENTIFIER_CONTEXT, AntlrClassifier.AMBIGUOUS, false, AntlrPrimitiveType.AMBIGUOUS);
    @Nonnull
    private final AntlrPrimitiveType antlrPrimitiveType;
    private PrimitivePropertyImpl.PrimitivePropertyBuilder elementBuilder;

    public AntlrPrimitiveProperty(@Nonnull KlassParser.PrimitivePropertyContext elementContext, @Nonnull Optional<CompilationUnit> compilationUnit, int ordinal, @Nonnull KlassParser.IdentifierContext nameContext, @Nonnull AntlrClassifier owningClassifier, boolean isOptional, @Nonnull AntlrPrimitiveType primitiveType) {
        super((ParserRuleContext)elementContext, compilationUnit, ordinal, nameContext, owningClassifier, isOptional);
        this.antlrPrimitiveType = Objects.requireNonNull(primitiveType);
    }

    @Override
    @Nonnull
    public AntlrPrimitiveType getType() {
        return this.antlrPrimitiveType;
    }

    protected KlassParser.PrimitiveTypeContext getTypeParserRuleContext() {
        return this.getElementContext().primitiveType();
    }

    @Nonnull
    public PrimitivePropertyImpl.PrimitivePropertyBuilder build() {
        if (this.elementBuilder != null) {
            throw new IllegalStateException();
        }
        this.elementBuilder = new PrimitivePropertyImpl.PrimitivePropertyBuilder((KlassParser.PrimitivePropertyContext)this.elementContext, this.getMacroElementBuilder(), this.getSourceCodeBuilder(), this.ordinal, this.getNameContext(), this.antlrPrimitiveType.getPrimitiveType(), this.owningClassifier.getElementBuilder(), this.isOptional);
        ImmutableList modifiers = this.getModifiers().collect(AntlrModifier::build).toImmutable();
        this.elementBuilder.setModifierBuilders(modifiers);
        this.buildValidations();
        return this.elementBuilder;
    }

    @Nonnull
    public KlassParser.PrimitivePropertyContext getElementContext() {
        return (KlassParser.PrimitivePropertyContext)super.getElementContext();
    }

    @Nonnull
    public PrimitivePropertyImpl.PrimitivePropertyBuilder getElementBuilder() {
        return Objects.requireNonNull(this.elementBuilder);
    }

    @Override
    public String getTypeName() {
        return this.getElementContext().primitiveType().getText();
    }

    @Override
    public void reportErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        super.reportErrors(compilerAnnotationHolder);
        this.reportInvalidTemporalMultiplicity(compilerAnnotationHolder);
        this.reportInvalidTemporalVisibility(compilerAnnotationHolder);
        this.reportInvalidStringValidations(compilerAnnotationHolder);
        this.reportInvalidNumericValidations(compilerAnnotationHolder);
    }

    @Override
    protected void reportInvalidIdProperties(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        PrimitiveType primitiveType = this.antlrPrimitiveType.getPrimitiveType();
        if (primitiveType.isId()) {
            this.reportNonKeyIdProperty(compilerAnnotationHolder);
            this.reportOverriddenIdProperty(compilerAnnotationHolder);
        } else {
            this.reportInvalidTypeIdProperty(compilerAnnotationHolder);
        }
    }

    private void reportNonKeyIdProperty(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        if (this.isKey()) {
            return;
        }
        ImmutableList<AntlrModifier> idModifiers = this.getModifiersByName("id");
        for (AntlrModifier idModifier : idModifiers) {
            String message = "Properties with the 'id' modifier must also have the 'key' modifier.";
            compilerAnnotationHolder.add("ERR_NKY_IDP", message, idModifier);
        }
    }

    private void reportInvalidTypeIdProperty(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        PrimitiveType primitiveType = this.antlrPrimitiveType.getPrimitiveType();
        ImmutableList<AntlrModifier> idModifiers = this.getModifiersByName("id");
        for (AntlrModifier idModifier : idModifiers) {
            String message = String.format("Primitive properties with type %s may not be auto-generated ids. Only types %s may be id properties.", primitiveType.getPrettyName(), PrimitiveType.ID_PRIMITIVE_TYPES);
            compilerAnnotationHolder.add("ERR_PRP_IDP", message, idModifier);
        }
    }

    private void reportOverriddenIdProperty(CompilerAnnotationHolder compilerAnnotationHolder) {
        AntlrClassifier antlrClassifier = this.owningClassifier;
        if (!(antlrClassifier instanceof AntlrClass)) {
            return;
        }
        AntlrClass owningClass = (AntlrClass)antlrClassifier;
        if (owningClass.getSuperClass().isEmpty()) {
            return;
        }
        AntlrClass superClass = owningClass.getSuperClass().get();
        AntlrDataTypeProperty<?> overriddenProperty = superClass.getDataTypePropertyByName(this.getName());
        if (overriddenProperty == AntlrEnumerationProperty.NOT_FOUND) {
            return;
        }
        AntlrClassifier antlrClassifier2 = overriddenProperty.getOwningClassifier();
        if (!(antlrClassifier2 instanceof AntlrClass)) {
            return;
        }
        AntlrClass overriddenPropertyOwningClass = (AntlrClass)antlrClassifier2;
        String message = "'id' properties may not be overridden. The property '%s' in class '%s' overrides the 'id' property in class '%s'.".formatted(this.getName(), owningClass.getName(), overriddenPropertyOwningClass.getName());
        ImmutableList<AntlrModifier> idModifiers = this.getModifiersByName("id");
        if (idModifiers.notEmpty()) {
            for (AntlrModifier idModifier : idModifiers) {
                compilerAnnotationHolder.add("ERR_OVR_IDP", message, idModifier);
            }
        } else if (overriddenProperty.isId()) {
            compilerAnnotationHolder.add("ERR_OVR_IDP", message, this);
        }
    }

    private void reportInvalidTemporalMultiplicity(CompilerAnnotationHolder compilerAnnotationHolder) {
        PrimitiveType primitiveType = this.antlrPrimitiveType.getPrimitiveType();
        if (!primitiveType.isTemporal()) {
            return;
        }
        if (this.isOptional) {
            return;
        }
        String message = String.format("Primitive properties with type %s may not be required.", primitiveType.getPrettyName());
        compilerAnnotationHolder.add("ERR_REQ_TMP", message, (IAntlrElement)this, (ParserRuleContext)this.getTypeParserRuleContext());
    }

    private void reportInvalidTemporalVisibility(CompilerAnnotationHolder compilerAnnotationHolder) {
        PrimitiveType primitiveType = this.antlrPrimitiveType.getPrimitiveType();
        if (primitiveType != PrimitiveType.TEMPORAL_RANGE) {
            return;
        }
        if (this.isPrivate()) {
            return;
        }
        String message = String.format("Primitive properties with type %s must be private.", primitiveType.getPrettyName());
        compilerAnnotationHolder.add("ERR_REQ_PRV", message, (IAntlrElement)this, (ParserRuleContext)this.getTypeParserRuleContext());
    }

    private void reportInvalidStringValidations(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        PrimitiveType primitiveType = this.antlrPrimitiveType.getPrimitiveType();
        if (primitiveType == PrimitiveType.STRING) {
            return;
        }
        this.minLengthValidations.each((Procedure & Serializable)each -> each.reportInvalidType(compilerAnnotationHolder, primitiveType));
        this.maxLengthValidations.each((Procedure & Serializable)each -> each.reportInvalidType(compilerAnnotationHolder, primitiveType));
    }

    private void reportInvalidNumericValidations(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        PrimitiveType primitiveType = this.antlrPrimitiveType.getPrimitiveType();
        if (primitiveType.isNumeric()) {
            return;
        }
        this.minValidations.each((Procedure & Serializable)each -> each.reportInvalidType(compilerAnnotationHolder, primitiveType));
        this.maxValidations.each((Procedure & Serializable)each -> each.reportInvalidType(compilerAnnotationHolder, primitiveType));
    }
}

