/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state.service;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.AntlrClassifier;
import cool.klass.model.converter.compiler.state.AntlrElement;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.projection.AntlrProjection;
import cool.klass.model.converter.compiler.state.service.AntlrService;
import cool.klass.model.meta.domain.service.ServiceProjectionDispatchImpl;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.eclipse.collections.api.tuple.Pair;

public class AntlrServiceProjectionDispatch
extends AntlrElement {
    @Nonnull
    private final AntlrService service;
    @Nonnull
    private final AntlrProjection projection;
    private ServiceProjectionDispatchImpl.ServiceProjectionDispatchBuilder elementBuilder;

    public AntlrServiceProjectionDispatch(@Nonnull KlassParser.ServiceProjectionDispatchContext elementContext, @Nonnull Optional<CompilationUnit> compilationUnit, @Nonnull AntlrService service, @Nonnull AntlrProjection projection) {
        super((ParserRuleContext)elementContext, compilationUnit);
        this.service = Objects.requireNonNull(service);
        this.projection = Objects.requireNonNull(projection);
    }

    @Override
    @Nonnull
    public Optional<IAntlrElement> getSurroundingElement() {
        return Optional.of(this.service);
    }

    @Override
    public boolean isContext() {
        return true;
    }

    @Override
    public Pair<Token, Token> getContextBefore() {
        return this.getEntireContext();
    }

    @Nonnull
    public AntlrProjection getProjection() {
        return this.projection;
    }

    public void reportErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        AntlrClassifier projectionClassifier;
        if (this.projection == AntlrProjection.NOT_FOUND) {
            KlassParser.ProjectionReferenceContext reference = this.getElementContext().projectionReference();
            compilerAnnotationHolder.add("ERR_SER_PRJ", String.format("Cannot find projection '%s'", reference.getText()), (IAntlrElement)this, (ParserRuleContext)reference);
        }
        if ((projectionClassifier = this.projection.getClassifier()) == AntlrClass.NOT_FOUND || projectionClassifier == AntlrClass.AMBIGUOUS) {
            throw new AssertionError();
        }
        if (projectionClassifier == AntlrClassifier.NOT_FOUND || projectionClassifier == AntlrClassifier.AMBIGUOUS) {
            return;
        }
        AntlrClass serviceGroupKlass = this.service.getUrl().getServiceGroup().getKlass();
        if (serviceGroupKlass == AntlrClass.AMBIGUOUS || serviceGroupKlass == AntlrClass.NOT_FOUND) {
            return;
        }
        if (serviceGroupKlass == AntlrClassifier.NOT_FOUND || serviceGroupKlass == AntlrClassifier.AMBIGUOUS) {
            throw new AssertionError();
        }
        if (serviceGroupKlass != projectionClassifier && !serviceGroupKlass.isSubTypeOf(projectionClassifier)) {
            String error = String.format("Expected projection referencing '%s' but projection '%s' references '%s'.", serviceGroupKlass.getName(), this.projection.getName(), projectionClassifier.getName());
            compilerAnnotationHolder.add("ERR_SRV_PRJ", error, (IAntlrElement)this, (ParserRuleContext)this.getElementContext().projectionReference());
        }
        this.reportForwardReference(compilerAnnotationHolder);
    }

    private void reportForwardReference(CompilerAnnotationHolder compilerAnnotationHolder) {
        if (!this.isForwardReference(this.projection)) {
            return;
        }
        String message = String.format("Service group '%s' is declared on line %d and has a forward reference to projection '%s' which is declared later in the source file '%s' on line %d.", this, this.getElementContext().getStart().getLine(), this.projection.getName(), this.getCompilationUnit().get().getSourceName(), this.projection.getElementContext().getStart().getLine());
        compilerAnnotationHolder.add("ERR_FWD_REF", message, (IAntlrElement)this, (ParserRuleContext)this.getElementContext().projectionReference());
    }

    @Nonnull
    public KlassParser.ServiceProjectionDispatchContext getElementContext() {
        return (KlassParser.ServiceProjectionDispatchContext)super.getElementContext();
    }

    @Nonnull
    public ServiceProjectionDispatchImpl.ServiceProjectionDispatchBuilder build() {
        if (this.elementBuilder != null) {
            throw new IllegalStateException();
        }
        this.elementBuilder = new ServiceProjectionDispatchImpl.ServiceProjectionDispatchBuilder((KlassParser.ServiceProjectionDispatchContext)this.elementContext, this.getMacroElementBuilder(), this.getSourceCodeBuilder(), this.projection.getElementBuilder());
        return this.elementBuilder;
    }

    @Nonnull
    public ServiceProjectionDispatchImpl.ServiceProjectionDispatchBuilder getElementBuilder() {
        return Objects.requireNonNull(this.elementBuilder);
    }
}

