/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state.value;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.AntlrEnumeration;
import cool.klass.model.converter.compiler.state.AntlrType;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.property.AntlrAssociationEnd;
import cool.klass.model.converter.compiler.state.property.AntlrDataTypeProperty;
import cool.klass.model.converter.compiler.state.property.AntlrEnumerationProperty;
import cool.klass.model.converter.compiler.state.value.AntlrExpressionValueVisitor;
import cool.klass.model.converter.compiler.state.value.AntlrMemberReferencePath;
import cool.klass.model.meta.domain.value.TypeMemberReferencePathImpl;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.impl.factory.Lists;

public class AntlrTypeMemberReferencePath
extends AntlrMemberReferencePath {
    private TypeMemberReferencePathImpl.TypeMemberReferencePathBuilder elementBuilder;

    public AntlrTypeMemberReferencePath(@Nonnull KlassParser.TypeMemberReferencePathContext elementContext, @Nonnull Optional<CompilationUnit> compilationUnit, @Nonnull AntlrClass klass, @Nonnull ImmutableList<AntlrAssociationEnd> associationEnds, @Nonnull AntlrDataTypeProperty<?> dataTypeProperty, @Nonnull IAntlrElement expressionValueOwner) {
        super((ParserRuleContext)elementContext, compilationUnit, klass, associationEnds, dataTypeProperty, expressionValueOwner);
    }

    @Nonnull
    public TypeMemberReferencePathImpl.TypeMemberReferencePathBuilder build() {
        if (this.elementBuilder != null) {
            throw new IllegalStateException();
        }
        ImmutableList associationEndBuilders = this.associationEnd.collect(AntlrAssociationEnd::getElementBuilder);
        this.elementBuilder = new TypeMemberReferencePathImpl.TypeMemberReferencePathBuilder((KlassParser.TypeMemberReferencePathContext)this.elementContext, this.getMacroElementBuilder(), this.getSourceCodeBuilder(), this.klass.getElementBuilder(), associationEndBuilders, this.dataTypeProperty.getElementBuilder());
        return this.elementBuilder;
    }

    @Nonnull
    public TypeMemberReferencePathImpl.TypeMemberReferencePathBuilder getElementBuilder() {
        return Objects.requireNonNull(this.elementBuilder);
    }

    @Override
    public void reportErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        if (this.klass == AntlrClass.AMBIGUOUS) {
            return;
        }
        if (this.klass == AntlrClass.NOT_FOUND) {
            KlassParser.ClassReferenceContext offendingToken = this.getElementContext().classReference();
            String message = String.format("Cannot find class '%s'.", offendingToken.getText());
            compilerAnnotationHolder.add("ERR_MEM_TYP", message, (IAntlrElement)this, (ParserRuleContext)offendingToken);
            return;
        }
        List associationEndReferenceContexts = this.getElementContext().associationEndReference();
        AntlrClass currentClass = this.reportErrorsAssociationEnds(compilerAnnotationHolder, associationEndReferenceContexts);
        if (currentClass == null) {
            return;
        }
        if (this.dataTypeProperty == AntlrEnumerationProperty.NOT_FOUND) {
            KlassParser.IdentifierContext identifier = this.getElementContext().memberReference().identifier();
            String message = String.format("Cannot find member '%s.%s'.", currentClass.getName(), identifier.getText());
            compilerAnnotationHolder.add("ERR_TYP_MEM", message, (IAntlrElement)this, (ParserRuleContext)identifier);
        }
    }

    @Override
    @Nonnull
    public ImmutableList<AntlrType> getPossibleTypes() {
        AntlrType type = this.dataTypeProperty.getType();
        return type == AntlrEnumeration.NOT_FOUND || type == AntlrEnumeration.AMBIGUOUS ? Lists.immutable.empty() : Lists.immutable.with((Object)type);
    }

    @Override
    public void visit(AntlrExpressionValueVisitor visitor) {
        visitor.visitTypeMember(this);
    }

    @Nonnull
    public KlassParser.TypeMemberReferencePathContext getElementContext() {
        return (KlassParser.TypeMemberReferencePathContext)super.getElementContext();
    }
}

