/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.state.AntlrAssociation;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.AntlrClassifier;
import cool.klass.model.converter.compiler.state.AntlrCompilationUnit;
import cool.klass.model.converter.compiler.state.AntlrDomainModel;
import cool.klass.model.converter.compiler.state.AntlrEnumeration;
import cool.klass.model.converter.compiler.state.AntlrInterface;
import cool.klass.model.converter.compiler.state.AntlrTopLevelElement;
import cool.klass.model.converter.compiler.state.modifier.AntlrModifierOwner;
import cool.klass.model.converter.compiler.state.order.AntlrOrderBy;
import cool.klass.model.converter.compiler.state.order.AntlrOrderByMemberReferencePath;
import cool.klass.model.converter.compiler.state.order.AntlrOrderByOwner;
import cool.klass.model.converter.compiler.state.parameter.AntlrParameter;
import cool.klass.model.converter.compiler.state.parameter.AntlrParameterOwner;
import cool.klass.model.converter.compiler.state.projection.AntlrProjection;
import cool.klass.model.converter.compiler.state.property.AntlrAssociationEnd;
import cool.klass.model.converter.compiler.state.property.AntlrAssociationEndSignature;
import cool.klass.model.converter.compiler.state.property.AntlrClassReferenceProperty;
import cool.klass.model.converter.compiler.state.property.AntlrModifier;
import cool.klass.model.converter.compiler.state.property.AntlrParameterizedProperty;
import cool.klass.model.converter.compiler.state.service.AntlrService;
import cool.klass.model.converter.compiler.state.service.AntlrServiceGroup;
import cool.klass.model.converter.compiler.state.service.url.AntlrUrl;
import cool.klass.model.meta.grammar.KlassBaseListener;
import cool.klass.model.meta.grammar.KlassListener;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ParserRuleContext;

public class CompilerWalkState {
    private final AntlrDomainModel domainModel;
    @Nullable
    private CompilationUnit currentCompilationUnit;
    @Nullable
    private String packageName;
    @Nullable
    private AntlrCompilationUnit compilationUnit;
    @Nullable
    private AntlrTopLevelElement topLevelDeclaration;
    @Nullable
    private AntlrEnumeration enumeration;
    @Nullable
    private AntlrClassifier classifier;
    @Nullable
    private AntlrInterface iface;
    @Nullable
    private AntlrClass klass;
    @Nullable
    private AntlrAssociation association;
    @Nullable
    private AntlrAssociationEnd associationEnd;
    @Nullable
    private AntlrAssociationEndSignature associationEndSignature;
    @Nullable
    private AntlrParameterizedProperty parameterizedProperty;
    @Nullable
    private AntlrParameter parameter;
    @Nullable
    private AntlrProjection projection;
    @Nullable
    private AntlrServiceGroup serviceGroup;
    @Nullable
    private AntlrUrl url;
    @Nullable
    private AntlrService service;
    @Nullable
    private AntlrOrderBy orderBy;
    @Nullable
    private AntlrOrderByMemberReferencePath orderByMemberReferencePath;
    @Nullable
    private AntlrClassifier thisReference;
    @Nullable
    private AntlrOrderByOwner orderByOwner;
    @Nullable
    private AntlrModifier classifierModifier;
    @Nullable
    private KlassParser.PackageNameContext packageNameContext;
    @Nullable
    private AntlrParameterOwner parameterOwner;
    @Nullable
    private AntlrModifierOwner modifierOwner;
    private int numClassifierMembers;

    public CompilerWalkState(AntlrDomainModel domainModel) {
        this.domainModel = domainModel;
    }

    private static void assertNull(@Nullable Object object) {
        if (object != null) {
            throw new IllegalStateException("Expected null but was " + object);
        }
    }

    private static void assertZero(int number) {
        if (number != 0) {
            throw new IllegalStateException("Expected 0 but was " + number);
        }
    }

    @Nullable
    public String getPackageName() {
        return this.packageName;
    }

    @Nullable
    public KlassParser.PackageNameContext getPackageNameContext() {
        return this.packageNameContext;
    }

    @Nullable
    public AntlrClassifier getClassifier() {
        return this.classifier;
    }

    @Nullable
    public AntlrInterface getInterface() {
        return this.iface;
    }

    @Nullable
    public AntlrClass getKlass() {
        return this.klass;
    }

    @Nullable
    public AntlrAssociation getAssociation() {
        return this.association;
    }

    @Nullable
    public AntlrAssociationEnd getAssociationEnd() {
        return this.associationEnd;
    }

    @Nullable
    public AntlrServiceGroup getServiceGroup() {
        return this.serviceGroup;
    }

    @Nullable
    public AntlrUrl getUrl() {
        return this.url;
    }

    @Nullable
    public AntlrProjection getProjection() {
        return this.projection;
    }

    @Nullable
    public AntlrService getService() {
        return this.service;
    }

    @Nullable
    public AntlrOrderBy getOrderBy() {
        return this.orderBy;
    }

    @Nullable
    public AntlrOrderByMemberReferencePath getOrderByMemberReferencePath() {
        return this.orderByMemberReferencePath;
    }

    @Nullable
    public AntlrOrderByOwner getOrderByOwner() {
        return this.orderByOwner;
    }

    @Nullable
    public AntlrClassifier getThisReference() {
        return this.thisReference;
    }

    @Nullable
    public AntlrModifier getClassifierModifier() {
        return this.classifierModifier;
    }

    @Nullable
    public AntlrParameterOwner getParameterOwner() {
        return this.parameterOwner;
    }

    public int getNumClassifierMembers() {
        return this.numClassifierMembers;
    }

    @Nonnull
    public CompilationUnit getCurrentCompilationUnit() {
        return Objects.requireNonNull(this.currentCompilationUnit);
    }

    @Nullable
    public AntlrCompilationUnit getCompilationUnit() {
        return Objects.requireNonNull(this.compilationUnit);
    }

    public void enterCompilationUnit(CompilationUnit currentCompilationUnit) {
        this.currentCompilationUnit = currentCompilationUnit;
        if (this.compilationUnit == null) {
            return;
        }
        if (this.compilationUnit.getElementContext() != this.currentCompilationUnit.getParserContext()) {
            throw new AssertionError();
        }
    }

    public void exitCompilationUnit() {
        this.currentCompilationUnit = null;
        this.packageName = null;
        this.packageNameContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withInPlaceCompilationUnit(CompilationUnit compilationUnit, Runnable runnable) {
        CompilationUnit oldCompilationUnit = this.currentCompilationUnit;
        try {
            this.currentCompilationUnit = compilationUnit;
            runnable.run();
        }
        finally {
            this.currentCompilationUnit = oldCompilationUnit;
        }
    }

    public void assertEmpty() {
        if (this.packageNameContext != null) {
            throw new AssertionError();
        }
        if (this.packageName != null) {
            throw new AssertionError();
        }
        if (this.enumeration != null) {
            throw new AssertionError();
        }
        if (this.classifier != null) {
            throw new AssertionError();
        }
        if (this.iface != null) {
            throw new AssertionError();
        }
        if (this.klass != null) {
            throw new AssertionError();
        }
        if (this.association != null) {
            throw new AssertionError();
        }
        if (this.associationEnd != null) {
            throw new AssertionError();
        }
        if (this.parameterizedProperty != null) {
            throw new AssertionError();
        }
        if (this.parameter != null) {
            throw new AssertionError();
        }
        if (this.projection != null) {
            throw new AssertionError();
        }
        if (this.serviceGroup != null) {
            throw new AssertionError();
        }
        if (this.url != null) {
            throw new AssertionError();
        }
        if (this.service != null) {
            throw new AssertionError();
        }
        if (this.orderBy != null) {
            throw new AssertionError();
        }
        if (this.orderByMemberReferencePath != null) {
            throw new AssertionError();
        }
        if (this.thisReference != null) {
            throw new AssertionError();
        }
        if (this.orderByOwner != null) {
            throw new AssertionError();
        }
        if (this.classifierModifier != null) {
            throw new AssertionError();
        }
        if (this.parameterOwner != null) {
            throw new AssertionError();
        }
        if (this.numClassifierMembers != 0) {
            throw new AssertionError();
        }
    }

    public void assertEquals(@Nonnull CompilerWalkState other) {
        if (!Objects.equals(this.domainModel, other.domainModel)) {
            throw new AssertionError();
        }
        if (this.compilationUnit != other.compilationUnit) {
            throw new AssertionError();
        }
        if (this.currentCompilationUnit != other.currentCompilationUnit) {
            throw new AssertionError();
        }
        if (!Objects.equals(this.packageName, other.packageName)) {
            throw new AssertionError();
        }
        if (this.topLevelDeclaration != other.topLevelDeclaration) {
            throw new AssertionError();
        }
        if (this.enumeration != other.enumeration) {
            throw new AssertionError();
        }
        if (this.classifier != other.classifier) {
            throw new AssertionError();
        }
        if (this.iface != other.iface) {
            throw new AssertionError();
        }
        if (this.klass != other.klass) {
            throw new AssertionError();
        }
        if (this.association != other.association) {
            throw new AssertionError();
        }
        if (this.associationEnd != other.associationEnd) {
            throw new AssertionError();
        }
        if (this.associationEndSignature != other.associationEndSignature) {
            throw new AssertionError();
        }
        if (this.parameterizedProperty != other.parameterizedProperty) {
            throw new AssertionError();
        }
        if (this.parameter != other.parameter) {
            throw new AssertionError();
        }
        if (this.projection != other.projection) {
            throw new AssertionError();
        }
        if (this.serviceGroup != other.serviceGroup) {
            throw new AssertionError();
        }
        if (this.url != other.url) {
            throw new AssertionError();
        }
        if (this.service != other.service) {
            throw new AssertionError();
        }
        if (this.orderBy != other.orderBy) {
            throw new AssertionError();
        }
        if (this.orderByMemberReferencePath != other.orderByMemberReferencePath) {
            throw new AssertionError();
        }
        if (this.thisReference != other.thisReference) {
            throw new AssertionError();
        }
        if (this.orderByOwner != other.orderByOwner) {
            throw new AssertionError();
        }
        if (this.classifierModifier != other.classifierModifier) {
            throw new AssertionError();
        }
        if (this.parameterOwner != other.parameterOwner) {
            throw new AssertionError();
        }
        if (this.numClassifierMembers != other.numClassifierMembers) {
            throw new AssertionError();
        }
    }

    @Nonnull
    public KlassListener asListener() {
        return new ListenerView();
    }

    public class ListenerView
    extends KlassBaseListener {
        public void enterCompilationUnit(KlassParser.CompilationUnitContext ctx) {
            CompilerWalkState.assertNull(CompilerWalkState.this.compilationUnit);
            CompilerWalkState.this.compilationUnit = CompilerWalkState.this.domainModel.getCompilationUnitByContext(ctx);
        }

        public void exitCompilationUnit(KlassParser.CompilationUnitContext ctx) {
            CompilerWalkState.this.compilationUnit = null;
        }

        public void enterPackageDeclaration(@Nonnull KlassParser.PackageDeclarationContext packageContext) {
            CompilerWalkState.this.packageNameContext = packageContext.packageName();
            CompilerWalkState.this.packageName = CompilerWalkState.this.packageNameContext.getText();
        }

        public void enterTopLevelDeclaration(@Nonnull KlassParser.TopLevelDeclarationContext ctx) {
            CompilerWalkState.assertNull(CompilerWalkState.this.topLevelDeclaration);
            CompilerWalkState.this.topLevelDeclaration = CompilerWalkState.this.domainModel.getTopLevelElementByContext(ctx);
        }

        public void exitTopLevelDeclaration(@Nonnull KlassParser.TopLevelDeclarationContext ctx) {
            CompilerWalkState.this.topLevelDeclaration = null;
        }

        public void enterInterfaceDeclaration(@Nonnull KlassParser.InterfaceDeclarationContext ctx) {
            CompilerWalkState.assertNull(CompilerWalkState.this.classifier);
            CompilerWalkState.assertNull(CompilerWalkState.this.iface);
            CompilerWalkState.assertNull(CompilerWalkState.this.thisReference);
            CompilerWalkState.assertZero(CompilerWalkState.this.numClassifierMembers);
            AntlrInterface interfaceByContext = CompilerWalkState.this.domainModel.getInterfaceByContext(ctx);
            CompilerWalkState.this.classifier = interfaceByContext;
            CompilerWalkState.this.iface = interfaceByContext;
            CompilerWalkState.this.thisReference = interfaceByContext;
        }

        public void exitInterfaceDeclaration(@Nonnull KlassParser.InterfaceDeclarationContext ctx) {
            CompilerWalkState.this.classifier = null;
            CompilerWalkState.this.iface = null;
            CompilerWalkState.this.thisReference = null;
            CompilerWalkState.this.numClassifierMembers = 0;
        }

        public void enterClassDeclaration(@Nonnull KlassParser.ClassDeclarationContext ctx) {
            CompilerWalkState.assertNull(CompilerWalkState.this.classifier);
            CompilerWalkState.assertNull(CompilerWalkState.this.klass);
            CompilerWalkState.assertNull(CompilerWalkState.this.thisReference);
            CompilerWalkState.assertZero(CompilerWalkState.this.numClassifierMembers);
            AntlrClass classByContext = CompilerWalkState.this.domainModel.getClassByContext(ctx);
            CompilerWalkState.this.classifier = classByContext;
            CompilerWalkState.this.klass = classByContext;
            CompilerWalkState.this.thisReference = classByContext;
        }

        public void exitClassDeclaration(@Nonnull KlassParser.ClassDeclarationContext ctx) {
            CompilerWalkState.this.classifier = null;
            CompilerWalkState.this.klass = null;
            CompilerWalkState.this.thisReference = null;
            CompilerWalkState.this.numClassifierMembers = 0;
        }

        public void enterEnumerationDeclaration(@Nonnull KlassParser.EnumerationDeclarationContext ctx) {
            CompilerWalkState.assertNull(CompilerWalkState.this.enumeration);
            CompilerWalkState.this.enumeration = CompilerWalkState.this.domainModel.getEnumerationByContext(ctx);
        }

        public void exitEnumerationDeclaration(@Nonnull KlassParser.EnumerationDeclarationContext ctx) {
            CompilerWalkState.this.enumeration = null;
        }

        public void enterAssociationDeclaration(@Nonnull KlassParser.AssociationDeclarationContext ctx) {
            CompilerWalkState.assertNull(CompilerWalkState.this.association);
            CompilerWalkState.this.association = CompilerWalkState.this.domainModel.getAssociationByContext(ctx);
        }

        public void exitAssociationDeclaration(@Nonnull KlassParser.AssociationDeclarationContext ctx) {
            CompilerWalkState.this.association = null;
        }

        public void enterAssociationEnd(@Nonnull KlassParser.AssociationEndContext ctx) {
            CompilerWalkState.assertNull(CompilerWalkState.this.associationEnd);
            CompilerWalkState.assertNull(CompilerWalkState.this.thisReference);
            CompilerWalkState.assertNull(CompilerWalkState.this.orderByOwner);
            if (CompilerWalkState.this.association == null) {
                return;
            }
            CompilerWalkState.this.associationEnd = CompilerWalkState.this.association.getAssociationEndByContext(ctx);
            if (CompilerWalkState.this.associationEnd == null) {
                return;
            }
            CompilerWalkState.this.orderByOwner = CompilerWalkState.this.associationEnd;
            CompilerWalkState.this.thisReference = CompilerWalkState.this.associationEnd.getType();
        }

        public void exitAssociationEnd(@Nonnull KlassParser.AssociationEndContext ctx) {
            CompilerWalkState.this.associationEnd = null;
            CompilerWalkState.this.orderByOwner = null;
            CompilerWalkState.this.thisReference = null;
        }

        public void enterAssociationEndSignature(@Nonnull KlassParser.AssociationEndSignatureContext ctx) {
            CompilerWalkState.assertNull(CompilerWalkState.this.associationEndSignature);
            CompilerWalkState.assertNull(CompilerWalkState.this.orderByOwner);
            if (CompilerWalkState.this.classifier == null) {
                return;
            }
            CompilerWalkState.this.associationEndSignature = CompilerWalkState.this.classifier.getDeclaredAssociationEndSignatureByContext(ctx);
            if (CompilerWalkState.this.associationEndSignature == null) {
                return;
            }
            CompilerWalkState.this.orderByOwner = CompilerWalkState.this.associationEndSignature;
        }

        public void exitAssociationEndSignature(@Nonnull KlassParser.AssociationEndSignatureContext ctx) {
            CompilerWalkState.this.associationEndSignature = null;
            CompilerWalkState.this.orderByOwner = null;
        }

        public void enterRelationship(@Nonnull KlassParser.RelationshipContext ctx) {
            CompilerWalkState.assertNull(CompilerWalkState.this.thisReference);
            if (CompilerWalkState.this.association == null) {
                return;
            }
            CompilerWalkState.this.thisReference = CompilerWalkState.this.association.getAssociationEnds().getFirstOptional().map(AntlrClassReferenceProperty::getType).orElse(AntlrClass.NOT_FOUND);
        }

        public void exitRelationship(@Nonnull KlassParser.RelationshipContext ctx) {
            CompilerWalkState.this.thisReference = null;
        }

        public void enterProjectionDeclaration(@Nonnull KlassParser.ProjectionDeclarationContext ctx) {
            CompilerWalkState.assertNull(CompilerWalkState.this.projection);
            CompilerWalkState.this.projection = CompilerWalkState.this.domainModel.getProjectionByContext(ctx);
        }

        public void exitProjectionDeclaration(@Nonnull KlassParser.ProjectionDeclarationContext ctx) {
            CompilerWalkState.this.projection = null;
        }

        public void enterServiceGroupDeclaration(@Nonnull KlassParser.ServiceGroupDeclarationContext ctx) {
            CompilerWalkState.assertNull(CompilerWalkState.this.serviceGroup);
            CompilerWalkState.assertNull(CompilerWalkState.this.thisReference);
            CompilerWalkState.this.serviceGroup = CompilerWalkState.this.domainModel.getServiceGroupByContext(ctx);
            if (CompilerWalkState.this.serviceGroup == null) {
                return;
            }
            CompilerWalkState.this.thisReference = CompilerWalkState.this.serviceGroup.getKlass();
        }

        public void exitServiceGroupDeclaration(@Nonnull KlassParser.ServiceGroupDeclarationContext ctx) {
            CompilerWalkState.this.serviceGroup = null;
            CompilerWalkState.this.thisReference = null;
        }

        public void enterUrlDeclaration(@Nonnull KlassParser.UrlDeclarationContext ctx) {
            CompilerWalkState.assertNull(CompilerWalkState.this.url);
            if (CompilerWalkState.this.serviceGroup == null) {
                return;
            }
            CompilerWalkState.this.url = CompilerWalkState.this.serviceGroup.getUrlByContext(ctx);
        }

        public void exitUrlDeclaration(@Nonnull KlassParser.UrlDeclarationContext ctx) {
            CompilerWalkState.this.url = null;
        }

        public void enterServiceDeclaration(@Nonnull KlassParser.ServiceDeclarationContext ctx) {
            CompilerWalkState.assertNull(CompilerWalkState.this.service);
            CompilerWalkState.assertNull(CompilerWalkState.this.orderByOwner);
            if (CompilerWalkState.this.url == null) {
                return;
            }
            CompilerWalkState.this.service = CompilerWalkState.this.url.getServiceByContext(ctx);
            if (CompilerWalkState.this.service == null) {
                return;
            }
            CompilerWalkState.this.orderByOwner = CompilerWalkState.this.service;
        }

        public void exitServiceDeclaration(@Nonnull KlassParser.ServiceDeclarationContext ctx) {
            CompilerWalkState.this.service = null;
            CompilerWalkState.this.orderByOwner = null;
        }

        public void enterInterfaceMember(KlassParser.InterfaceMemberContext ctx) {
            ++CompilerWalkState.this.numClassifierMembers;
        }

        public void enterClassMember(KlassParser.ClassMemberContext ctx) {
            ++CompilerWalkState.this.numClassifierMembers;
        }

        public void enterParameterizedProperty(@Nonnull KlassParser.ParameterizedPropertyContext ctx) {
            CompilerWalkState.assertNull(CompilerWalkState.this.parameterizedProperty);
            CompilerWalkState.assertNull(CompilerWalkState.this.orderByOwner);
            CompilerWalkState.assertNull(CompilerWalkState.this.parameterOwner);
            if (CompilerWalkState.this.klass == null) {
                return;
            }
            CompilerWalkState.this.parameterizedProperty = CompilerWalkState.this.klass.getParameterizedPropertyByContext(ctx);
            CompilerWalkState.this.orderByOwner = CompilerWalkState.this.parameterizedProperty;
            CompilerWalkState.this.parameterOwner = CompilerWalkState.this.parameterizedProperty;
        }

        public void exitParameterizedProperty(@Nonnull KlassParser.ParameterizedPropertyContext ctx) {
            CompilerWalkState.this.parameterizedProperty = null;
            CompilerWalkState.this.orderByOwner = null;
            CompilerWalkState.this.parameterOwner = null;
        }

        public void enterParameterDeclaration(@Nonnull KlassParser.ParameterDeclarationContext ctx) {
            CompilerWalkState.assertNull(CompilerWalkState.this.parameter);
            if (CompilerWalkState.this.parameterOwner == null) {
                return;
            }
            CompilerWalkState.this.parameter = CompilerWalkState.this.parameterOwner.getParameterByContext(ctx);
        }

        public void exitParameterDeclaration(@Nonnull KlassParser.ParameterDeclarationContext ctx) {
            CompilerWalkState.this.parameter = null;
        }

        public void enterClassifierModifier(@Nonnull KlassParser.ClassifierModifierContext ctx) {
            CompilerWalkState.assertNull(CompilerWalkState.this.classifierModifier);
            if (CompilerWalkState.this.classifier == null) {
                return;
            }
            CompilerWalkState.this.classifierModifier = CompilerWalkState.this.classifier.getDeclaredModifierByContext((ParserRuleContext)ctx);
        }

        public void exitClassifierModifier(@Nonnull KlassParser.ClassifierModifierContext ctx) {
            CompilerWalkState.this.classifierModifier = null;
        }

        public void enterOrderByDeclaration(KlassParser.OrderByDeclarationContext ctx) {
            CompilerWalkState.assertNull(CompilerWalkState.this.orderBy);
            if (CompilerWalkState.this.orderByOwner == null) {
                return;
            }
            CompilerWalkState.this.orderByOwner.getOrderBy().ifPresent(antlrOrderBy -> {
                CompilerWalkState.this.orderBy = antlrOrderBy;
            });
        }

        public void exitOrderByDeclaration(KlassParser.OrderByDeclarationContext ctx) {
            CompilerWalkState.this.orderBy = null;
        }

        public void enterOrderByMemberReferencePath(KlassParser.OrderByMemberReferencePathContext ctx) {
            CompilerWalkState.assertNull(CompilerWalkState.this.orderByMemberReferencePath);
            if (CompilerWalkState.this.orderBy == null) {
                return;
            }
            CompilerWalkState.this.orderByMemberReferencePath = Objects.requireNonNull(CompilerWalkState.this.orderBy.getOrderByMemberReferencePath(ctx));
        }

        public void exitOrderByMemberReferencePath(KlassParser.OrderByMemberReferencePathContext ctx) {
            CompilerWalkState.this.orderByMemberReferencePath = null;
        }
    }
}

