/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.phase.criteria;

import cool.klass.model.converter.compiler.CompilerState;
import cool.klass.model.converter.compiler.phase.criteria.LiteralValueVisitor;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.AntlrClassifier;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.property.AntlrAssociationEnd;
import cool.klass.model.converter.compiler.state.property.AntlrDataTypeProperty;
import cool.klass.model.converter.compiler.state.value.AntlrExpressionValue;
import cool.klass.model.converter.compiler.state.value.AntlrThisMemberReferencePath;
import cool.klass.model.converter.compiler.state.value.AntlrTypeMemberReferencePath;
import cool.klass.model.converter.compiler.state.value.AntlrVariableReference;
import cool.klass.model.converter.compiler.state.value.literal.AbstractAntlrLiteralValue;
import cool.klass.model.converter.compiler.state.value.literal.AntlrLiteralListValue;
import cool.klass.model.converter.compiler.state.value.literal.AntlrUserLiteral;
import cool.klass.model.meta.grammar.KlassBaseVisitor;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.list.mutable.ListAdapter;

public class ExpressionValueVisitor
extends KlassBaseVisitor<AntlrExpressionValue> {
    @Nonnull
    private final CompilerState compilerState;
    @Nonnull
    private final AntlrClassifier thisReference;
    @Nonnull
    private final IAntlrElement expressionValueOwner;

    public ExpressionValueVisitor(@Nonnull CompilerState compilerState, @Nonnull AntlrClassifier thisReference, IAntlrElement expressionValueOwner) {
        this.compilerState = Objects.requireNonNull(compilerState);
        this.thisReference = Objects.requireNonNull(thisReference);
        this.expressionValueOwner = Objects.requireNonNull(expressionValueOwner);
    }

    @Nonnull
    public AntlrExpressionValue visitTerminal(TerminalNode node) {
        throw new AssertionError();
    }

    @Nonnull
    public AntlrLiteralListValue visitLiteralList(@Nonnull KlassParser.LiteralListContext ctx) {
        AntlrLiteralListValue literalListValue = new AntlrLiteralListValue(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), this.expressionValueOwner);
        ImmutableList literals = ListAdapter.adapt((List)ctx.literal()).collectWith(this::getAntlrLiteralValue, (Object)literalListValue).toImmutable();
        literalListValue.setLiterals((ImmutableList<AbstractAntlrLiteralValue>)literals);
        return literalListValue;
    }

    private AbstractAntlrLiteralValue getAntlrLiteralValue(@Nonnull KlassParser.LiteralContext literalCtx, @Nonnull IAntlrElement expressionValueOwner) {
        LiteralValueVisitor visitor = new LiteralValueVisitor(this.compilerState, expressionValueOwner);
        return (AbstractAntlrLiteralValue)visitor.visitLiteral(literalCtx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public AntlrExpressionValue visitNativeLiteral(@Nonnull KlassParser.NativeLiteralContext ctx) {
        String keyword;
        switch (keyword = ctx.getText()) {
            case "user": {
                return new AntlrUserLiteral(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), this.expressionValueOwner, this.compilerState.getDomainModel().getUserClass());
            }
            default: {
                throw new AssertionError((Object)keyword);
            }
        }
    }

    @Nonnull
    public AntlrVariableReference visitVariableReference(@Nonnull KlassParser.VariableReferenceContext ctx) {
        KlassParser.IdentifierContext identifier = ctx.identifier();
        String variableName = identifier.getText();
        return new AntlrVariableReference(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), variableName, this.expressionValueOwner);
    }

    @Nonnull
    public AntlrThisMemberReferencePath visitThisMemberReferencePath(@Nonnull KlassParser.ThisMemberReferencePathContext ctx) {
        KlassParser.MemberReferenceContext memberReferenceContext = ctx.memberReference();
        AntlrClass currentClass = (AntlrClass)this.thisReference;
        MutableList associationEnds = Lists.mutable.empty();
        for (KlassParser.AssociationEndReferenceContext associationEndReferenceContext : ctx.associationEndReference()) {
            String associationEndName = associationEndReferenceContext.identifier().getText();
            AntlrAssociationEnd associationEnd = currentClass.getAssociationEndByName(associationEndName);
            associationEnds.add((Object)associationEnd);
            currentClass = associationEnd.getType();
        }
        String memberName = memberReferenceContext.identifier().getText();
        AntlrDataTypeProperty<?> dataTypeProperty = currentClass.getDataTypePropertyByName(memberName);
        return new AntlrThisMemberReferencePath(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), (AntlrClass)this.thisReference, (ImmutableList<AntlrAssociationEnd>)associationEnds.toImmutable(), dataTypeProperty, this.expressionValueOwner);
    }

    @Nonnull
    public AntlrTypeMemberReferencePath visitTypeMemberReferencePath(@Nonnull KlassParser.TypeMemberReferencePathContext ctx) {
        String className = ctx.classReference().identifier().getText();
        AntlrClass klass = this.compilerState.getDomainModel().getClassByName(className);
        KlassParser.MemberReferenceContext memberReferenceContext = ctx.memberReference();
        AntlrClass currentClass = klass;
        MutableList associationEnds = Lists.mutable.empty();
        for (KlassParser.AssociationEndReferenceContext associationEndReferenceContext : ctx.associationEndReference()) {
            String associationEndName = associationEndReferenceContext.identifier().getText();
            AntlrAssociationEnd associationEnd = currentClass.getAssociationEndByName(associationEndName);
            associationEnds.add((Object)associationEnd);
            currentClass = associationEnd.getType();
        }
        String memberName = memberReferenceContext.identifier().getText();
        AntlrDataTypeProperty<?> dataTypeProperty = currentClass.getDataTypePropertyByName(memberName);
        return new AntlrTypeMemberReferencePath(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), klass, (ImmutableList<AntlrAssociationEnd>)associationEnds.toImmutable(), dataTypeProperty, this.expressionValueOwner);
    }

    public AbstractAntlrLiteralValue visitLiteral(KlassParser.LiteralContext ctx) {
        return this.getAntlrLiteralValue(ctx, this.expressionValueOwner);
    }
}

