/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.state.AntlrElement;
import cool.klass.model.converter.compiler.state.property.AntlrModifier;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.tuple.Tuples;

public interface IAntlrElement {
    @Nonnull
    public ParserRuleContext getElementContext();

    @Nonnull
    public Optional<AntlrElement> getMacroElement();

    @Nonnull
    public Optional<IAntlrElement> getSurroundingElement();

    default public <T extends IAntlrElement> Optional<T> getSurroundingElement(Class<T> elementClass) {
        if (elementClass.isInstance(this)) {
            return Optional.of((IAntlrElement)elementClass.cast(this));
        }
        return this.getSurroundingElement().flatMap(surroundingElement -> surroundingElement.getSurroundingElement(elementClass));
    }

    @Nonnull
    default public ImmutableList<IAntlrElement> getSurroundingElements() {
        MutableList result = Lists.mutable.empty();
        this.gatherSurroundingElements((MutableList<IAntlrElement>)result);
        return result.toImmutable();
    }

    default public void gatherSurroundingElements(@Nonnull MutableList<IAntlrElement> result) {
        result.add((Object)this);
        this.getSurroundingElement().ifPresent(element -> element.gatherSurroundingElements(result));
    }

    default public boolean isContext() {
        return false;
    }

    @Nonnull
    public Optional<CompilationUnit> getCompilationUnit();

    default public Pair<Token, Token> getContextBefore() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getContextBefore() not implemented yet");
    }

    default public Pair<Token, Token> getContextAfter() {
        this.getContextBefore();
        return null;
    }

    default public Pair<Token, Token> getEntireContext() {
        return Tuples.pair((Object)this.getElementContext().getStart(), (Object)this.getElementContext().getStop());
    }

    default public void reportAuditErrors(CompilerAnnotationHolder compilerAnnotationHolder, ListIterable<AntlrModifier> modifiers, IAntlrElement element) {
        ImmutableList offendingModifiers = modifiers.select((Predicate & Serializable)modifier -> modifier.isAudit() || modifier.isUser()).toImmutable();
        if (offendingModifiers.isEmpty()) {
            return;
        }
        String message = String.format("Modifiers %s require one 'user' class in the domain model.", offendingModifiers.collect(AntlrModifier::getKeyword));
        compilerAnnotationHolder.add("ERR_ADT_MOD", message, element, (ImmutableList<ParserRuleContext>)offendingModifiers.collect(AntlrElement::getElementContext));
    }
}

