/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state.projection;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.AntlrClassifier;
import cool.klass.model.converter.compiler.state.AntlrIdentifierElement;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.projection.AntlrProjection;
import cool.klass.model.converter.compiler.state.projection.AntlrProjectionChild;
import cool.klass.model.converter.compiler.state.projection.AntlrProjectionParent;
import cool.klass.model.converter.compiler.state.projection.AntlrProjectionVisitor;
import cool.klass.model.converter.compiler.state.property.AntlrAssociationEnd;
import cool.klass.model.converter.compiler.state.property.AntlrDataTypeProperty;
import cool.klass.model.converter.compiler.state.property.AntlrEnumerationProperty;
import cool.klass.model.converter.compiler.state.property.AntlrReferenceProperty;
import cool.klass.model.meta.domain.projection.ProjectionImpl;
import cool.klass.model.meta.domain.projection.ProjectionProjectionReferenceImpl;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.eclipse.collections.api.tuple.Pair;

public class AntlrProjectionProjectionReference
extends AntlrIdentifierElement
implements AntlrProjectionChild {
    @Nonnull
    private final AntlrClassifier classifier;
    @Nonnull
    private final AntlrProjectionParent antlrProjectionParent;
    @Nonnull
    private final AntlrClassifier classifierState;
    @Nonnull
    private final AntlrReferenceProperty<?> referenceProperty;
    @Nonnull
    private final AntlrProjection referencedProjection;
    private ProjectionProjectionReferenceImpl.ProjectionProjectionReferenceBuilder projectionProjectionReferenceBuilder;

    public AntlrProjectionProjectionReference(@Nonnull KlassParser.ProjectionProjectionReferenceContext elementContext, @Nonnull Optional<CompilationUnit> compilationUnit, int ordinal, @Nonnull KlassParser.IdentifierContext nameContext, @Nonnull AntlrClassifier classifier, @Nonnull AntlrProjectionParent antlrProjectionParent, @Nonnull AntlrClassifier classifierState, @Nonnull AntlrReferenceProperty<?> referenceProperty, @Nonnull AntlrProjection referencedProjection) {
        super((ParserRuleContext)elementContext, compilationUnit, ordinal, nameContext);
        this.classifier = Objects.requireNonNull(classifier);
        this.antlrProjectionParent = Objects.requireNonNull(antlrProjectionParent);
        this.classifierState = Objects.requireNonNull(classifierState);
        this.referenceProperty = Objects.requireNonNull(referenceProperty);
        this.referencedProjection = Objects.requireNonNull(referencedProjection);
    }

    @Nonnull
    public KlassParser.ProjectionProjectionReferenceContext getElementContext() {
        return (KlassParser.ProjectionProjectionReferenceContext)super.getElementContext();
    }

    @Override
    public boolean isContext() {
        return true;
    }

    @Override
    public Pair<Token, Token> getContextBefore() {
        return this.getEntireContext();
    }

    @Nonnull
    public ProjectionProjectionReferenceImpl.ProjectionProjectionReferenceBuilder build() {
        if (this.projectionProjectionReferenceBuilder != null) {
            throw new IllegalStateException();
        }
        this.projectionProjectionReferenceBuilder = new ProjectionProjectionReferenceImpl.ProjectionProjectionReferenceBuilder((KlassParser.ProjectionProjectionReferenceContext)this.elementContext, this.getMacroElementBuilder(), this.getSourceCodeBuilder(), this.ordinal, this.getNameContext(), this.antlrProjectionParent.getElementBuilder(), this.classifierState.getElementBuilder(), this.referenceProperty.getElementBuilder());
        return this.projectionProjectionReferenceBuilder;
    }

    @Override
    public void build2() {
        ProjectionImpl.ProjectionBuilder referencedProjectionBuilder = this.referencedProjection.getElementBuilder();
        this.projectionProjectionReferenceBuilder.setReferencedProjectionBuilder(referencedProjectionBuilder);
    }

    @Override
    public void visit(@Nonnull AntlrProjectionVisitor visitor) {
        visitor.visitProjectionReference(this);
    }

    @Override
    @Nonnull
    public AntlrProjectionParent getParent() {
        return this.antlrProjectionParent;
    }

    @Override
    public void reportDuplicateMemberName(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        String message = String.format("Duplicate member: '%s'.", this.getName());
        compilerAnnotationHolder.add("ERR_DUP_PRJ", message, this);
    }

    @Override
    public void reportErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        AntlrClassifier parentClassifier = this.antlrProjectionParent.getClassifier();
        if (parentClassifier == AntlrClass.NOT_FOUND || parentClassifier == AntlrClass.AMBIGUOUS || parentClassifier == AntlrClassifier.AMBIGUOUS || parentClassifier == AntlrClassifier.NOT_FOUND) {
            return;
        }
        if (this.referencedProjection == AntlrProjection.AMBIGUOUS) {
            return;
        }
        if (this.referenceProperty == AntlrReferenceProperty.NOT_FOUND || this.referenceProperty == AntlrAssociationEnd.NOT_FOUND) {
            AntlrDataTypeProperty<?> dataTypeProperty = parentClassifier.getDataTypePropertyByName(this.getName());
            if (dataTypeProperty == AntlrEnumerationProperty.NOT_FOUND) {
                String message = String.format("Cannot find member '%s.%s'.", parentClassifier.getName(), this.getName());
                compilerAnnotationHolder.add("ERR_PPR_NFD", message, this);
            } else {
                String message = "Projection reference '%s' requires a reference property with type '%s', but found a data type property '%s.%s' with type '%s'.".formatted(this.referencedProjection.getName(), this.referencedProjection.getClassifier().getName(), parentClassifier.getName(), this.getName(), dataTypeProperty.getTypeName());
                compilerAnnotationHolder.add("ERR_PPR_TYP", message, this);
            }
        } else if (this.referenceProperty == AntlrReferenceProperty.AMBIGUOUS || this.referenceProperty == AntlrAssociationEnd.AMBIGUOUS) {
            String message = String.format("Ambiguous: '%s'.", this);
            compilerAnnotationHolder.add("ERR_PPR_AMB", message, this);
        } else if (this.referencedProjection == AntlrProjection.NOT_FOUND) {
            String message = String.format("Not found: '%s'.", this.getElementContext().projectionReference().getText());
            compilerAnnotationHolder.add("ERR_PPR_NFD", message, (IAntlrElement)this, (ParserRuleContext)this.getElementContext().projectionReference());
        } else {
            this.reportTypeMismatch(compilerAnnotationHolder);
            this.reportForwardReference(compilerAnnotationHolder);
        }
    }

    private void reportTypeMismatch(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        if (this.classifier == this.referencedProjection.getClassifier() || this.classifier.isSubTypeOf(this.referencedProjection.getClassifier())) {
            return;
        }
        String message = String.format("Type mismatch: '%s' has type '%s' but '%s' has type '%s'.", this.getName(), this.classifier.getName(), this.referencedProjection.getName(), this.referencedProjection.getClassifier().getName());
        compilerAnnotationHolder.add("ERR_PRR_KLS", message, this);
    }

    private void reportForwardReference(CompilerAnnotationHolder compilerAnnotationHolder) {
        AntlrAssociationEnd associationEnd;
        if (!this.referenceProperty.isToOneRequired() || !this.isForwardReference(this.referencedProjection)) {
            return;
        }
        AntlrReferenceProperty<?> antlrReferenceProperty = this.referenceProperty;
        if (antlrReferenceProperty instanceof AntlrAssociationEnd && (associationEnd = (AntlrAssociationEnd)antlrReferenceProperty).isOwned()) {
            return;
        }
        String message = String.format("Projection property '%s' is declared on line %d and has a forward reference to projection '%s' which is declared later in the source file '%s' on line %d.", this.getName(), this.getElementContext().getStart().getLine(), this.referencedProjection.getName(), this.getCompilationUnit().get().getSourceName(), this.referencedProjection.getElementContext().getStart().getLine());
        compilerAnnotationHolder.add("ERR_FWD_REF", message, (IAntlrElement)this, (ParserRuleContext)this.getElementContext().projectionReference());
    }

    @Override
    public void reportNameErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
    }

    @Override
    @Nonnull
    protected Pattern getNamePattern() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getNamePattern() not implemented yet");
    }
}

