/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state.service;

import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.AntlrCompilationUnit;
import cool.klass.model.converter.compiler.state.AntlrPackageableElement;
import cool.klass.model.converter.compiler.state.AntlrTopLevelElement;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.service.url.AntlrUrl;
import cool.klass.model.meta.domain.service.ServiceGroupImpl;
import cool.klass.model.meta.grammar.KlassParser;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableOrderedMap;
import org.eclipse.collections.impl.bag.strategy.mutable.HashBagWithHashingStrategy;
import org.eclipse.collections.impl.block.factory.HashingStrategies;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.map.ordered.mutable.OrderedMapAdapter;

public class AntlrServiceGroup
extends AntlrPackageableElement
implements AntlrTopLevelElement {
    public static final AntlrServiceGroup AMBIGUOUS = new AntlrServiceGroup(new KlassParser.ServiceGroupDeclarationContext(AMBIGUOUS_PARENT, -1), AntlrCompilationUnit.AMBIGUOUS, -1, AMBIGUOUS_IDENTIFIER_CONTEXT, AntlrClass.AMBIGUOUS);
    @Nonnull
    private final AntlrClass klass;
    private final MutableList<AntlrUrl> urls = Lists.mutable.empty();
    private final MutableOrderedMap<KlassParser.UrlDeclarationContext, AntlrUrl> urlsByContext = OrderedMapAdapter.adapt(new LinkedHashMap());
    private ServiceGroupImpl.ServiceGroupBuilder serviceGroupBuilder;

    public AntlrServiceGroup(@Nonnull KlassParser.ServiceGroupDeclarationContext elementContext, @Nonnull AntlrCompilationUnit compilationUnitState, int ordinal, @Nonnull KlassParser.IdentifierContext nameContext, @Nonnull AntlrClass klass) {
        super((ParserRuleContext)elementContext, compilationUnitState, ordinal, nameContext);
        this.klass = Objects.requireNonNull(klass);
    }

    @Nonnull
    public AntlrClass getKlass() {
        return this.klass;
    }

    public AntlrUrl getUrlByContext(KlassParser.UrlDeclarationContext ctx) {
        return (AntlrUrl)this.urlsByContext.get((Object)ctx);
    }

    public void enterUrlDeclaration(@Nonnull AntlrUrl url) {
        AntlrUrl duplicate = (AntlrUrl)this.urlsByContext.put((Object)url.getElementContext(), (Object)url);
        if (duplicate != null) {
            throw new AssertionError();
        }
        this.urls.add((Object)url);
    }

    public ListIterable<AntlrUrl> getUrls() {
        return this.urls.asUnmodifiable();
    }

    @Nonnull
    public KlassParser.ServiceGroupDeclarationContext getElementContext() {
        return (KlassParser.ServiceGroupDeclarationContext)super.getElementContext();
    }

    @Override
    public void reportErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        this.reportNoUrls(compilerAnnotationHolder);
        this.reportDuplicateUrls(compilerAnnotationHolder);
        this.reportForwardReference(compilerAnnotationHolder);
        for (AntlrUrl url : this.urls) {
            url.reportErrors(compilerAnnotationHolder);
        }
        if (this.klass == AntlrClass.NOT_FOUND) {
            this.reportTypeNotFound(compilerAnnotationHolder);
        }
    }

    @Override
    public void reportDuplicateTopLevelName(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
    }

    private void reportTypeNotFound(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        if (this.klass != AntlrClass.NOT_FOUND) {
            return;
        }
        KlassParser.ClassReferenceContext reference = this.getElementContext().classReference();
        compilerAnnotationHolder.add("ERR_SRG_TYP", String.format("Cannot find class '%s'", reference.getText()), (IAntlrElement)this, (ParserRuleContext)reference);
    }

    private void reportDuplicateUrls(CompilerAnnotationHolder compilerAnnotationHolder) {
        HashBagWithHashingStrategy antlrUrls = new HashBagWithHashingStrategy(HashingStrategies.fromFunction(AntlrUrl::getNormalizedPathSegments));
        MutableBag duplicateUrls = antlrUrls.selectByOccurrences((IntPredicate & Serializable)occurrences -> occurrences > 1);
        if (duplicateUrls.notEmpty()) {
            throw new AssertionError();
        }
    }

    private void reportNoUrls(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        if (this.urls.isEmpty()) {
            String message = String.format("Service group should declare at least one url: '%s'.", this.getElementContext().classReference().getText());
            compilerAnnotationHolder.add("ERR_SER_EMP", message, this);
        }
    }

    public void reportDuplicateServiceGroupClass(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        String message = String.format("Multiple service groups for class: '%s.%s'.", this.klass.getPackageName(), this.klass.getName());
        compilerAnnotationHolder.add("ERR_DUP_SVC", message, this);
    }

    private void reportForwardReference(CompilerAnnotationHolder compilerAnnotationHolder) {
        if (!this.isForwardReference(this.klass)) {
            return;
        }
        String message = String.format("Service group '%s' is declared on line %d and has a forward reference to class '%s' which is declared later in the source file '%s' on line %d.", this, this.getElementContext().getStart().getLine(), this.klass.getName(), this.getCompilationUnit().get().getSourceName(), this.klass.getElementContext().getStart().getLine());
        compilerAnnotationHolder.add("ERR_FWD_REF", message, (IAntlrElement)this, (ParserRuleContext)this.getElementContext().classReference());
    }

    public ServiceGroupImpl.ServiceGroupBuilder build() {
        if (this.serviceGroupBuilder != null) {
            throw new IllegalStateException();
        }
        this.serviceGroupBuilder = new ServiceGroupImpl.ServiceGroupBuilder((KlassParser.ServiceGroupDeclarationContext)this.elementContext, this.getMacroElementBuilder(), this.getSourceCodeBuilder(), this.ordinal, this.getNameContext(), this.getPackageName(), this.klass.getElementBuilder());
        ImmutableList urlBuilders = this.urls.collect(AntlrUrl::build).toImmutable();
        this.serviceGroupBuilder.setUrlBuilders(urlBuilders);
        return this.serviceGroupBuilder;
    }

    public KlassParser.ServiceGroupBlockContext getBlockContext() {
        return this.getElementContext().serviceGroupBlock();
    }

    @Nonnull
    public ServiceGroupImpl.ServiceGroupBuilder getElementBuilder() {
        return this.serviceGroupBuilder;
    }
}

