/*
 * Copyright 2024 Craig Motlin
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cool.klass.model.converter.compiler.annotation;

import java.util.Optional;

import javax.annotation.Nonnull;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.syntax.highlighter.ansi.AnsiTokenColorizer;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.collections.api.list.ImmutableList;
import org.fusesource.jansi.Ansi.Color;

public class CauseCompilerAnnotation
        extends AbstractCompilerAnnotation
{
    public CauseCompilerAnnotation(
            @Nonnull CompilationUnit compilationUnit,
            @Nonnull Optional<CauseCompilerAnnotation> macroCause,
            @Nonnull ImmutableList<ParserRuleContext> offendingContexts,
            @Nonnull ImmutableList<IAntlrElement> sourceContexts,
            @Nonnull AnsiTokenColorizer ansiTokenColorizer,
            @Nonnull AnnotationSeverity severity)
    {
        super(
                compilationUnit,
                macroCause,
                offendingContexts,
                sourceContexts,
                ansiTokenColorizer,
                severity);
    }

    @Nonnull
    @Override
    protected Color getCaretColor()
    {
        return Color.GREEN;
    }

    @Nonnull
    @Override
    public String toString()
    {
        String contextString   = this.getContextString();
        String locationMessage = this.getOptionalLocationMessage();
        String causeString     = this.getCauseString();

        return "\n"
               + "Which was generated by macro at location " + this.getShortLocationString() + "\n"
               + contextString
               + locationMessage
               + causeString;
    }

    @Override
    public String toGitHubAnnotation()
    {
        return toString();
    }
}
