/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler;

import cool.klass.model.converter.compiler.CompilationUnit;
import java.util.IdentityHashMap;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.impl.map.mutable.MapAdapter;

public class CompilerInputState {
    @Nonnull
    private final MutableList<CompilationUnit> compilationUnits;
    private final MutableMap<ParserRuleContext, CompilationUnit> compilationUnitsByContext;

    public CompilerInputState(@Nonnull ImmutableCollection<CompilationUnit> compilationUnits) {
        this.compilationUnits = compilationUnits.toList();
        this.compilationUnitsByContext = (MutableMap)compilationUnits.groupByUniqueKey(CompilationUnit::getParserContext, (MutableMapIterable)MapAdapter.adapt(new IdentityHashMap()));
    }

    private void addCompilationUnit(@Nonnull CompilationUnit compilationUnit) {
        this.compilationUnits.add((Object)compilationUnit);
        this.compilationUnitsByContext.put((Object)compilationUnit.getParserContext(), (Object)compilationUnit);
    }

    public void runCompilerMacro(@Nonnull CompilationUnit compilationUnit, @Nonnull ImmutableList<ParseTreeListener> listeners) {
        this.addCompilationUnit(compilationUnit);
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
        for (ParseTreeListener listener : listeners) {
            parseTreeWalker.walk(listener, (ParseTree)compilationUnit.getParserContext());
        }
    }

    public void runInPlaceCompilerMacro(@Nonnull CompilationUnit compilationUnit, @Nonnull ImmutableList<ParseTreeListener> listeners) {
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
        for (ParseTreeListener listener : listeners) {
            parseTreeWalker.walk(listener, (ParseTree)compilationUnit.getParserContext());
        }
    }

    public MutableList<CompilationUnit> getCompilationUnits() {
        return this.compilationUnits.asUnmodifiable();
    }

    public CompilationUnit getCompilationUnitByContext(ParserRuleContext ctx) {
        return (CompilationUnit)this.compilationUnitsByContext.get((Object)ctx);
    }
}

