/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler;

import com.google.common.base.Stopwatch;
import cool.klass.model.converter.compiler.CompilationResult;
import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.CompilerInputState;
import cool.klass.model.converter.compiler.CompilerState;
import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.annotation.RootCompilerAnnotation;
import cool.klass.model.converter.compiler.phase.AssociationPhase;
import cool.klass.model.converter.compiler.phase.AuditAssociationInferencePhase;
import cool.klass.model.converter.compiler.phase.AuditPropertyInferencePhase;
import cool.klass.model.converter.compiler.phase.ClassTemporalPropertyInferencePhase;
import cool.klass.model.converter.compiler.phase.ClassifierPhase;
import cool.klass.model.converter.compiler.phase.CompilationUnitPhase;
import cool.klass.model.converter.compiler.phase.EnumerationsPhase;
import cool.klass.model.converter.compiler.phase.InheritancePhase;
import cool.klass.model.converter.compiler.phase.OrderByDirectionInferencePhase;
import cool.klass.model.converter.compiler.phase.OrderByDirectionPhase;
import cool.klass.model.converter.compiler.phase.OrderByPhase;
import cool.klass.model.converter.compiler.phase.ParameterizedPropertyPhase;
import cool.klass.model.converter.compiler.phase.ProjectionDeclarationPhase;
import cool.klass.model.converter.compiler.phase.ProjectionPhase;
import cool.klass.model.converter.compiler.phase.PropertyPhase;
import cool.klass.model.converter.compiler.phase.RelationshipInferencePhase;
import cool.klass.model.converter.compiler.phase.RelationshipPhase;
import cool.klass.model.converter.compiler.phase.ServiceCriteriaInferencePhase;
import cool.klass.model.converter.compiler.phase.ServiceCriteriaPhase;
import cool.klass.model.converter.compiler.phase.ServiceMultiplicityInferencePhase;
import cool.klass.model.converter.compiler.phase.ServiceMultiplicityPhase;
import cool.klass.model.converter.compiler.phase.ServicePhase;
import cool.klass.model.converter.compiler.phase.TopLevelElementsPhase;
import cool.klass.model.converter.compiler.phase.UrlParameterPhase;
import cool.klass.model.converter.compiler.phase.VariableResolutionPhase;
import cool.klass.model.converter.compiler.phase.VersionAssociationInferencePhase;
import cool.klass.model.converter.compiler.phase.VersionClassInferencePhase;
import cool.klass.model.converter.compiler.syntax.highlighter.ansi.AnsiTokenColorizer;
import cool.klass.model.converter.compiler.syntax.highlighter.ansi.scheme.AnsiColorScheme;
import cool.klass.model.converter.compiler.syntax.highlighter.ansi.scheme.DarkAnsiColorScheme;
import cool.klass.model.converter.compiler.token.categories.TokenCategory;
import cool.klass.model.converter.compiler.token.categorizing.lexer.LexerBasedTokenCategorizer;
import cool.klass.model.converter.compiler.token.categorizing.parser.ParserBasedTokenCategorizer;
import cool.klass.model.meta.grammar.KlassListener;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableOrderedMap;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.map.ordered.mutable.OrderedMapAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KlassCompiler {
    public static final ImmutableList<Function<CompilerState, KlassListener>> COMPILER_PHASE_BUILDERS = Lists.immutable.with((Object[])new Function[]{CompilationUnitPhase::new, TopLevelElementsPhase::new, EnumerationsPhase::new, ClassifierPhase::new, PropertyPhase::new, InheritancePhase::new, ParameterizedPropertyPhase::new, VersionClassInferencePhase::new, ClassTemporalPropertyInferencePhase::new, AuditPropertyInferencePhase::new, AssociationPhase::new, VersionAssociationInferencePhase::new, AuditAssociationInferencePhase::new, RelationshipPhase::new, RelationshipInferencePhase::new, ProjectionDeclarationPhase::new, ProjectionPhase::new, ServicePhase::new, ServiceMultiplicityPhase::new, ServiceMultiplicityInferencePhase::new, UrlParameterPhase::new, ServiceCriteriaPhase::new, ServiceCriteriaInferencePhase::new, VariableResolutionPhase::new, OrderByPhase::new, OrderByDirectionPhase::new, OrderByDirectionInferencePhase::new});
    private static final Logger LOGGER = LoggerFactory.getLogger(KlassCompiler.class);
    private final CompilerState compilerState;

    public KlassCompiler(CompilationUnit compilationUnit) {
        this((ImmutableList<CompilationUnit>)Lists.immutable.with((Object)compilationUnit));
    }

    public KlassCompiler(ImmutableList<CompilationUnit> compilationUnits) {
        this.compilerState = new CompilerState(compilationUnits);
    }

    private void executeCompilerPhase(KlassListener compilerPhase) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ImmutableList immutableCompilationUnits = this.compilerState.getCompilerInput().getCompilationUnits().toImmutable();
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
        for (CompilationUnit compilationUnit : immutableCompilationUnits) {
            try {
                this.compilerState.getCompilerWalk().assertEmpty();
                parseTreeWalker.walk((ParseTreeListener)compilerPhase, (ParseTree)compilationUnit.getParserContext());
                this.compilerState.getCompilerWalk().assertEmpty();
            }
            catch (RuntimeException e) {
                String message = "Exception in compiler during phase: %s for compilation unit: %s".formatted(compilerPhase.getClass().getSimpleName(), compilationUnit.getFullPathSourceName());
                throw new RuntimeException(message, e);
            }
        }
        Stopwatch stopped = stopwatch.stop();
        long sElapsed = stopped.elapsed(TimeUnit.SECONDS);
        long msElapsed = stopped.elapsed(TimeUnit.MILLISECONDS);
        LOGGER.info("Executed compiler phase {} in {}s {}ms.", new Object[]{compilerPhase.getClass().getSimpleName(), sElapsed, msElapsed});
    }

    @Nonnull
    public CompilationResult compile() {
        ImmutableList compilerPhases = COMPILER_PHASE_BUILDERS.collectWith(Function::apply, (Object)this.compilerState);
        for (KlassListener compilerPhase : compilerPhases) {
            this.executeCompilerPhase(compilerPhase);
        }
        CompilerInputState compilerInputState = this.compilerState.getCompilerInput();
        ImmutableList compilationUnits = compilerInputState.getCompilationUnits().toImmutable();
        MapIterable<Token, TokenCategory> tokenCategoriesFromLexer = this.getTokenCategoriesFromLexer((ImmutableList<CompilationUnit>)compilationUnits);
        MapIterable<Token, TokenCategory> tokenCategoriesFromParser = this.getTokenCategoriesFromParser((ImmutableList<CompilationUnit>)compilationUnits);
        CompilerAnnotationHolder compilerAnnotationHolder = this.compilerState.getCompilerAnnotationHolder();
        AnsiTokenColorizer ansiTokenColorizer = new AnsiTokenColorizer((AnsiColorScheme)DarkAnsiColorScheme.INSTANCE, tokenCategoriesFromParser, tokenCategoriesFromLexer);
        compilerAnnotationHolder.setAnsiTokenColorizer(ansiTokenColorizer);
        this.compilerState.reportErrors();
        ImmutableList<RootCompilerAnnotation> compilerAnnotations = compilerAnnotationHolder.getCompilerAnnotations();
        return this.compilerState.getCompilationResult(compilerAnnotations);
    }

    private MapIterable<Token, TokenCategory> getTokenCategoriesFromLexer(ImmutableList<CompilationUnit> compilationUnits) {
        MutableOrderedMap tokenCategoriesFromLexer = OrderedMapAdapter.adapt(new LinkedHashMap());
        compilationUnits.collect(CompilationUnit::getTokenStream).forEachWith(LexerBasedTokenCategorizer::findTokenCategoriesFromLexer, (Object)tokenCategoriesFromLexer);
        return tokenCategoriesFromLexer.asUnmodifiable();
    }

    private MapIterable<Token, TokenCategory> getTokenCategoriesFromParser(ImmutableList<CompilationUnit> compilationUnits) {
        ParserBasedTokenCategorizer listener = new ParserBasedTokenCategorizer();
        compilationUnits.collect(CompilationUnit::getParserContext).forEachWith(ParserBasedTokenCategorizer::findTokenCategoriesFromParser, (Object)listener);
        return listener.getTokenCategories();
    }
}

