/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.annotation;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.annotation.AnnotationSeverity;
import cool.klass.model.converter.compiler.annotation.CauseCompilerAnnotation;
import cool.klass.model.converter.compiler.annotation.RootCompilerAnnotation;
import cool.klass.model.converter.compiler.state.AntlrNamedElement;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.syntax.highlighter.ansi.AnsiTokenColorizer;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.factory.Lists;

public class CompilerAnnotationHolder {
    private final MutableList<RootCompilerAnnotation> compilerAnnotations = Lists.mutable.empty();
    private AnsiTokenColorizer ansiTokenColorizer;

    public void add(@Nonnull String annotationCode, @Nonnull String message, @Nonnull IAntlrElement element) {
        this.add(annotationCode, message, element, AnnotationSeverity.ERROR);
    }

    public void add(@Nonnull String annotationCode, @Nonnull String message, @Nonnull IAntlrElement element, @Nonnull AnnotationSeverity severity) {
        Objects.requireNonNull(element);
        if (element instanceof AntlrNamedElement) {
            AntlrNamedElement namedElement = (AntlrNamedElement)element;
            this.add(annotationCode, message, element, namedElement.getNameContext(), severity);
        } else {
            this.add(annotationCode, message, element, element.getElementContext(), severity);
        }
    }

    public void add(@Nonnull String annotationCode, @Nonnull String message, @Nonnull IAntlrElement element, @Nonnull ParserRuleContext offendingContext) {
        this.add(annotationCode, message, element, offendingContext, AnnotationSeverity.ERROR);
    }

    public void add(@Nonnull String annotationCode, @Nonnull String message, @Nonnull IAntlrElement element, @Nonnull ParserRuleContext offendingContext, @Nonnull AnnotationSeverity severity) {
        this.add(annotationCode, message, element, (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)offendingContext), severity);
    }

    public void add(@Nonnull String annotationCode, @Nonnull String message, @Nonnull IAntlrElement element, @Nonnull ImmutableList<ParserRuleContext> offendingContexts) {
        this.add(annotationCode, message, element, offendingContexts, AnnotationSeverity.ERROR);
    }

    public void add(@Nonnull String annotationCode, @Nonnull String message, @Nonnull IAntlrElement element, @Nonnull ImmutableList<ParserRuleContext> offendingContexts, @Nonnull AnnotationSeverity severity) {
        this.add(annotationCode, message, element, element.getSurroundingElements(), offendingContexts, severity);
    }

    public void add(@Nonnull String annotationCode, @Nonnull String message, @Nonnull IAntlrElement element, @Nonnull ImmutableList<IAntlrElement> surroundingElements, @Nonnull ImmutableList<ParserRuleContext> offendingContexts) {
        this.add(annotationCode, message, element, surroundingElements, offendingContexts, AnnotationSeverity.ERROR);
    }

    public void add(@Nonnull String annotationCode, @Nonnull String message, @Nonnull IAntlrElement element, @Nonnull ImmutableList<IAntlrElement> surroundingElements, @Nonnull ImmutableList<ParserRuleContext> offendingContexts, @Nonnull AnnotationSeverity severity) {
        RootCompilerAnnotation compilerAnnotation = this.getCompilerAnnotation(annotationCode, message, element, surroundingElements, offendingContexts, severity);
        this.compilerAnnotations.add((Object)compilerAnnotation);
    }

    @Nonnull
    private RootCompilerAnnotation getCompilerAnnotation(@Nonnull String annotationCode, @Nonnull String message, @Nonnull IAntlrElement element, @Nonnull ImmutableList<IAntlrElement> surroundingElements, @Nonnull ImmutableList<ParserRuleContext> offendingContexts, @Nonnull AnnotationSeverity severity) {
        Optional<CauseCompilerAnnotation> macroCause = this.getCauseCompilerAnnotation(element, severity);
        CompilationUnit compilationUnit = element.getCompilationUnit().get();
        return new RootCompilerAnnotation(compilationUnit, macroCause, offendingContexts, surroundingElements, annotationCode, message, this.ansiTokenColorizer, severity);
    }

    @Nonnull
    private CauseCompilerAnnotation getCauseCompilerAnnotation(@Nonnull IAntlrElement element, @Nonnull ImmutableList<IAntlrElement> surroundingElements, @Nonnull ImmutableList<ParserRuleContext> offendingContexts, @Nonnull AnnotationSeverity severity) {
        Optional<CauseCompilerAnnotation> macroCause = this.getCauseCompilerAnnotation(element, severity);
        CompilationUnit compilationUnit = element.getCompilationUnit().get();
        return new CauseCompilerAnnotation(compilationUnit, macroCause, offendingContexts, surroundingElements, this.ansiTokenColorizer, severity);
    }

    private Optional<CauseCompilerAnnotation> getCauseCompilerAnnotation(@Nonnull IAntlrElement element, @Nonnull AnnotationSeverity severity) {
        return element.getMacroElement().map(macroElement -> this.getCauseCompilerAnnotation((IAntlrElement)macroElement, macroElement.getSurroundingElements(), (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)macroElement.getElementContext()), severity));
    }

    public ImmutableList<RootCompilerAnnotation> getCompilerAnnotations() {
        return this.compilerAnnotations.toSortedList().toImmutable();
    }

    public boolean hasCompilerAnnotations() {
        return this.compilerAnnotations.notEmpty();
    }

    public void setAnsiTokenColorizer(@Nonnull AnsiTokenColorizer ansiTokenColorizer) {
        this.ansiTokenColorizer = Objects.requireNonNull(ansiTokenColorizer);
    }
}

