/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.phase;

import cool.klass.model.converter.compiler.CompilerState;
import cool.klass.model.converter.compiler.phase.AbstractCompilerPhase;
import cool.klass.model.converter.compiler.phase.PropertyPhase;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.AntlrClassifier;
import cool.klass.model.converter.compiler.state.property.AntlrDataTypeProperty;
import cool.klass.model.converter.compiler.state.property.AntlrModifier;
import cool.klass.model.converter.compiler.state.property.AntlrProperty;
import cool.klass.model.converter.compiler.state.property.validation.AbstractAntlrPropertyValidation;
import cool.klass.model.meta.grammar.KlassParser;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.MutableList;

public class AuditPropertyInferencePhase
extends AbstractCompilerPhase {
    public AuditPropertyInferencePhase(@Nonnull CompilerState compilerState) {
        super(compilerState);
    }

    @Override
    @Nonnull
    public String getName() {
        return "Audit modifier";
    }

    @Override
    public void exitInterfaceBody(KlassParser.InterfaceBodyContext ctx) {
        this.runCompilerMacro((ParserRuleContext)ctx);
        super.exitInterfaceBody(ctx);
    }

    @Override
    public void exitClassBody(KlassParser.ClassBodyContext ctx) {
        this.runCompilerMacro((ParserRuleContext)ctx);
        super.exitClassBody(ctx);
    }

    private void runCompilerMacro(ParserRuleContext inPlaceContext) {
        AntlrClassifier classifier = this.compilerState.getCompilerWalk().getClassifier();
        MutableList<AntlrModifier> declaredModifiers = classifier.getDeclaredModifiers();
        ImmutableList<AntlrDataTypeProperty<?>> allDataTypeProperties = classifier.getAllDataTypeProperties();
        MutableList auditedModifiers = declaredModifiers.select((Predicate & Serializable)modifier -> modifier.is("audited"));
        if (auditedModifiers.size() != 1) {
            return;
        }
        AntlrModifier auditedModifier = (AntlrModifier)auditedModifiers.getOnly();
        Optional<AntlrClass> maybeUserClass = this.compilerState.getDomainModel().getUserClass();
        if (maybeUserClass.isEmpty()) {
            return;
        }
        AntlrClass userClass = maybeUserClass.get();
        ImmutableList userIdProperties = userClass.getAllDataTypeProperties().select(AntlrDataTypeProperty::isUserId);
        if (userIdProperties.size() != 1) {
            return;
        }
        AntlrDataTypeProperty userIdProperty = (AntlrDataTypeProperty)userIdProperties.getOnly();
        ListIterable<AbstractAntlrPropertyValidation> validations = userIdProperty.getValidations();
        String validationSourceCode = validations.isEmpty() ? "" : validations.makeString(" ", " ", "");
        StringBuilder sourceCodeText = new StringBuilder();
        if (allDataTypeProperties.noneSatisfy(AntlrProperty::isCreatedBy)) {
            sourceCodeText.append("    createdById    : String createdBy private userId final").append(validationSourceCode).append(";\n");
        }
        if (allDataTypeProperties.noneSatisfy(AntlrDataTypeProperty::isCreatedOn)) {
            sourceCodeText.append("    createdOn      : Instant createdOn final;\n");
        }
        if (allDataTypeProperties.noneSatisfy(AntlrProperty::isLastUpdatedBy)) {
            sourceCodeText.append("    lastUpdatedById: String lastUpdatedBy private userId").append(validationSourceCode).append(";\n");
        }
        this.runCompilerMacro(inPlaceContext, sourceCodeText.toString(), auditedModifier);
    }

    private void runCompilerMacro(ParserRuleContext inPlaceContext, @Nonnull String sourceCodeText, AntlrModifier macroElement) {
        if (sourceCodeText.isEmpty()) {
            return;
        }
        PropertyPhase compilerPhase = new PropertyPhase(this.compilerState);
        this.compilerState.runInPlaceCompilerMacro(macroElement, this, sourceCodeText, (Function<KlassParser, ? extends ParserRuleContext>)((Function & Serializable)KlassParser::classBody), inPlaceContext, new ParseTreeListener[]{compilerPhase});
    }
}

