/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.phase;

import cool.klass.model.converter.compiler.CompilerState;
import cool.klass.model.converter.compiler.phase.AbstractCompilerPhase;
import cool.klass.model.converter.compiler.phase.PropertyPhase;
import cool.klass.model.converter.compiler.state.AntlrClassifier;
import cool.klass.model.converter.compiler.state.property.AntlrDataTypeProperty;
import cool.klass.model.converter.compiler.state.property.AntlrModifier;
import cool.klass.model.meta.grammar.KlassParser;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;

public class ClassTemporalPropertyInferencePhase
extends AbstractCompilerPhase {
    public ClassTemporalPropertyInferencePhase(@Nonnull CompilerState compilerState) {
        super(compilerState);
    }

    @Override
    @Nonnull
    public String getName() {
        return "Temporal modifier";
    }

    @Override
    public void exitInterfaceBody(KlassParser.InterfaceBodyContext ctx) {
        this.runCompilerMacro((ParserRuleContext)ctx);
        super.exitInterfaceBody(ctx);
    }

    @Override
    public void exitClassBody(KlassParser.ClassBodyContext ctx) {
        this.runCompilerMacro((ParserRuleContext)ctx);
        super.exitClassBody(ctx);
    }

    private void runCompilerMacro(ParserRuleContext inPlaceContext) {
        StringBuilder sourceCodeText;
        AntlrClassifier classifier = this.compilerState.getCompilerWalk().getClassifier();
        MutableList<AntlrModifier> declaredModifiers = classifier.getDeclaredModifiers();
        ImmutableList<AntlrDataTypeProperty<?>> allDataTypeProperties = classifier.getAllDataTypeProperties();
        MutableList validTemporalModifiers = declaredModifiers.select((Predicate & Serializable)modifier -> modifier.is("validTemporal") || modifier.is("bitemporal"));
        MutableList systemTemporalModifiers = declaredModifiers.select((Predicate & Serializable)modifier -> modifier.is("systemTemporal") || modifier.is("bitemporal"));
        if (validTemporalModifiers.size() == 1) {
            AntlrModifier validTemporalModifier = (AntlrModifier)validTemporalModifiers.getOnly();
            sourceCodeText = new StringBuilder();
            if (allDataTypeProperties.noneSatisfy(AntlrDataTypeProperty::isValidRange)) {
                sourceCodeText.append("    valid    : TemporalRange?   valid private;\n");
            }
            if (allDataTypeProperties.noneSatisfy(AntlrDataTypeProperty::isValidFrom)) {
                sourceCodeText.append("    validFrom: TemporalInstant? valid from;\n");
            }
            if (allDataTypeProperties.noneSatisfy(AntlrDataTypeProperty::isValidTo)) {
                sourceCodeText.append("    validTo  : TemporalInstant? valid to;\n");
            }
            this.runCompilerMacro(inPlaceContext, sourceCodeText.toString(), validTemporalModifier);
        }
        if (systemTemporalModifiers.size() == 1) {
            AntlrModifier systemTemporalModifier = (AntlrModifier)systemTemporalModifiers.getOnly();
            sourceCodeText = new StringBuilder();
            if (allDataTypeProperties.noneSatisfy(AntlrDataTypeProperty::isSystemRange)) {
                sourceCodeText.append("    system    : TemporalRange?   system private;\n");
            }
            if (allDataTypeProperties.noneSatisfy(AntlrDataTypeProperty::isSystemFrom)) {
                sourceCodeText.append("    systemFrom: TemporalInstant? system from;\n");
            }
            if (allDataTypeProperties.noneSatisfy(AntlrDataTypeProperty::isSystemTo)) {
                sourceCodeText.append("    systemTo  : TemporalInstant? system to;\n");
            }
            this.runCompilerMacro(inPlaceContext, sourceCodeText.toString(), systemTemporalModifier);
        }
    }

    private void runCompilerMacro(ParserRuleContext inPlaceContext, @Nonnull String sourceCodeText, AntlrModifier macroElement) {
        if (sourceCodeText.isEmpty()) {
            return;
        }
        PropertyPhase compilerPhase = new PropertyPhase(this.compilerState);
        this.compilerState.runInPlaceCompilerMacro(macroElement, this, sourceCodeText, (Function<KlassParser, ? extends ParserRuleContext>)((Function & Serializable)KlassParser::classBody), inPlaceContext, new ParseTreeListener[]{compilerPhase});
    }
}

