/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.phase;

import cool.klass.model.converter.compiler.CompilerState;
import cool.klass.model.converter.compiler.phase.AbstractCompilerPhase;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.AntlrClassifier;
import cool.klass.model.converter.compiler.state.AntlrInterface;
import cool.klass.model.converter.compiler.state.property.AntlrModifier;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ParserRuleContext;

public class ClassifierPhase
extends AbstractCompilerPhase {
    @Nullable
    private AntlrClassifier classifier;
    @Nullable
    private AntlrInterface iface;
    @Nullable
    private AntlrClass klass;

    public ClassifierPhase(@Nonnull CompilerState compilerState) {
        super(compilerState);
    }

    @Override
    public void enterInterfaceDeclaration(@Nonnull KlassParser.InterfaceDeclarationContext ctx) {
        super.enterInterfaceDeclaration(ctx);
        KlassParser.IdentifierContext identifier = ctx.interfaceHeader().identifier();
        this.iface = new AntlrInterface(ctx, this.compilerState.getCompilerWalk().getCompilationUnit(), (int)this.compilerState.getOrdinal((ParserRuleContext)ctx), identifier);
        this.classifier = this.iface;
    }

    @Override
    public void exitInterfaceDeclaration(@Nonnull KlassParser.InterfaceDeclarationContext ctx) {
        this.compilerState.getDomainModel().exitInterfaceDeclaration(this.iface);
        this.iface = null;
        this.classifier = null;
        super.exitInterfaceDeclaration(ctx);
    }

    @Override
    public void enterClassDeclaration(@Nonnull KlassParser.ClassDeclarationContext ctx) {
        super.enterClassDeclaration(ctx);
        String classOrUserKeyword = ctx.classHeader().classOrUser().getText();
        this.klass = new AntlrClass(ctx, this.compilerState.getCompilerWalk().getCompilationUnit(), this.compilerState.getOrdinal((ParserRuleContext)ctx), ctx.classHeader().identifier(), classOrUserKeyword.equals("user"));
        this.classifier = this.klass;
    }

    @Override
    public void exitClassDeclaration(@Nonnull KlassParser.ClassDeclarationContext ctx) {
        this.compilerState.getDomainModel().exitClassDeclaration(this.klass);
        this.klass = null;
        this.classifier = null;
        super.exitClassDeclaration(ctx);
    }

    @Override
    public void enterAbstractDeclaration(@Nonnull KlassParser.AbstractDeclarationContext ctx) {
        super.enterAbstractDeclaration(ctx);
        this.klass.setAbstract(true);
    }

    @Override
    public void enterClassifierModifier(@Nonnull KlassParser.ClassifierModifierContext ctx) {
        super.enterClassifierModifier(ctx);
        int ordinal = this.classifier.getNumClassifierModifiers();
        AntlrModifier modifier = new AntlrModifier((ParserRuleContext)ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), ordinal + 1, this.classifier);
        this.classifier.enterModifier(modifier);
    }
}

