/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.phase;

import cool.klass.model.converter.compiler.CompilerState;
import cool.klass.model.converter.compiler.phase.AbstractCompilerPhase;
import cool.klass.model.converter.compiler.state.AntlrEnumeration;
import cool.klass.model.converter.compiler.state.AntlrEnumerationLiteral;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;

public class EnumerationsPhase
extends AbstractCompilerPhase {
    @Nullable
    private AntlrEnumeration enumeration;

    public EnumerationsPhase(@Nonnull CompilerState compilerState) {
        super(compilerState);
    }

    @Override
    public void enterEnumerationDeclaration(@Nonnull KlassParser.EnumerationDeclarationContext ctx) {
        super.enterEnumerationDeclaration(ctx);
        KlassParser.IdentifierContext identifier = ctx.identifier();
        this.enumeration = new AntlrEnumeration(ctx, this.compilerState.getCompilerWalk().getCompilationUnit(), (int)this.compilerState.getOrdinal((ParserRuleContext)ctx), identifier);
    }

    @Override
    public void exitEnumerationDeclaration(@Nonnull KlassParser.EnumerationDeclarationContext ctx) {
        this.compilerState.getDomainModel().exitEnumerationDeclaration(this.enumeration);
        this.enumeration = null;
        super.exitEnumerationDeclaration(ctx);
    }

    @Override
    public void enterEnumerationLiteral(@Nonnull KlassParser.EnumerationLiteralContext ctx) {
        super.enterEnumerationLiteral(ctx);
        Optional<KlassParser.EnumerationPrettyNameContext> prettyNameContext = Optional.ofNullable(ctx.enumerationPrettyName());
        Optional<String> prettyName = prettyNameContext.map(RuleContext::getText).map(this::trimQuotes);
        AntlrEnumerationLiteral enumerationLiteral = new AntlrEnumerationLiteral(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), this.enumeration.getNumLiterals() + 1, ctx.identifier(), prettyName, this.enumeration);
        this.enumeration.enterEnumerationLiteral(enumerationLiteral);
    }

    @Nonnull
    private String trimQuotes(@Nonnull String text) {
        return text.substring(1, text.length() - 1);
    }
}

