/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.phase;

import cool.klass.model.converter.compiler.CompilerState;
import cool.klass.model.converter.compiler.phase.AbstractCompilerPhase;
import cool.klass.model.converter.compiler.state.AntlrClassifier;
import cool.klass.model.converter.compiler.state.projection.AntlrProjection;
import cool.klass.model.converter.compiler.state.projection.AntlrProjectionDataTypeProperty;
import cool.klass.model.converter.compiler.state.projection.AntlrProjectionParent;
import cool.klass.model.converter.compiler.state.projection.AntlrProjectionProjectionReference;
import cool.klass.model.converter.compiler.state.projection.AntlrProjectionReferenceProperty;
import cool.klass.model.converter.compiler.state.property.AntlrDataTypeProperty;
import cool.klass.model.converter.compiler.state.property.AntlrReferenceProperty;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.impl.factory.Stacks;

public class ProjectionPhase
extends AbstractCompilerPhase {
    private final MutableStack<AntlrProjectionParent> elementStack = Stacks.mutable.empty();

    public ProjectionPhase(@Nonnull CompilerState compilerState) {
        super(compilerState);
    }

    @Override
    public void enterProjectionDeclaration(@Nonnull KlassParser.ProjectionDeclarationContext ctx) {
        super.enterProjectionDeclaration(ctx);
        AntlrProjection projection = this.compilerState.getCompilerWalk().getProjection();
        Objects.requireNonNull(projection);
        this.elementStack.push((Object)projection);
    }

    @Override
    public void exitProjectionDeclaration(@Nonnull KlassParser.ProjectionDeclarationContext ctx) {
        this.elementStack.pop();
        super.exitProjectionDeclaration(ctx);
    }

    @Override
    public void enterProjectionPrimitiveMember(@Nonnull KlassParser.ProjectionPrimitiveMemberContext ctx) {
        super.enterProjectionPrimitiveMember(ctx);
        AntlrProjectionParent projectionParent = (AntlrProjectionParent)this.elementStack.peek();
        Objects.requireNonNull(projectionParent);
        KlassParser.IdentifierContext nameContext = ctx.identifier();
        String name = nameContext.getText();
        KlassParser.HeaderContext header = ctx.header();
        String headerQuotedText = header.StringLiteral().getText();
        String headerText = headerQuotedText.substring(1, headerQuotedText.length() - 1);
        KlassParser.ClassifierReferenceContext classifierReferenceContext = ctx.classifierReference();
        AntlrClassifier classifier = classifierReferenceContext == null ? projectionParent.getClassifier() : this.compilerState.getDomainModel().getClassifierByName(classifierReferenceContext.getText());
        AntlrDataTypeProperty<?> dataTypePropertyState = classifier.getDataTypePropertyByName(name);
        AntlrProjectionDataTypeProperty projectionPrimitiveMemberState = new AntlrProjectionDataTypeProperty(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), projectionParent.getNumChildren() + 1, nameContext, header, headerText, projectionParent, classifier, dataTypePropertyState);
        projectionParent.enterAntlrProjectionMember(projectionPrimitiveMemberState);
    }

    @Override
    public void enterProjectionReferenceProperty(@Nonnull KlassParser.ProjectionReferencePropertyContext ctx) {
        super.enterProjectionReferenceProperty(ctx);
        AntlrProjectionParent projectionParent = (AntlrProjectionParent)this.elementStack.peek();
        KlassParser.IdentifierContext nameContext = ctx.identifier();
        String name = nameContext.getText();
        KlassParser.ClassifierReferenceContext classifierReferenceContext = ctx.classifierReference();
        AntlrClassifier classifier = classifierReferenceContext == null ? projectionParent.getClassifier() : this.compilerState.getDomainModel().getClassifierByName(classifierReferenceContext.getText());
        AntlrReferenceProperty<?> referenceProperty = classifier.getReferencePropertyByName(name);
        AntlrProjectionReferenceProperty projectionReferenceProperty = new AntlrProjectionReferenceProperty(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), projectionParent.getNumChildren() + 1, nameContext, (AntlrClassifier)referenceProperty.getType(), projectionParent, classifier, referenceProperty);
        projectionParent.enterAntlrProjectionMember(projectionReferenceProperty);
        this.elementStack.push((Object)projectionReferenceProperty);
    }

    @Override
    public void exitProjectionReferenceProperty(@Nonnull KlassParser.ProjectionReferencePropertyContext ctx) {
        this.elementStack.pop();
        super.exitProjectionReferenceProperty(ctx);
    }

    @Override
    public void enterProjectionProjectionReference(@Nonnull KlassParser.ProjectionProjectionReferenceContext ctx) {
        super.enterProjectionProjectionReference(ctx);
        AntlrProjectionParent projectionParent = (AntlrProjectionParent)this.elementStack.peek();
        KlassParser.IdentifierContext nameContext = ctx.identifier();
        String name = nameContext.getText();
        KlassParser.ProjectionReferenceContext projectionReferenceContext = ctx.projectionReference();
        String projectionName = projectionReferenceContext.identifier().getText();
        KlassParser.ClassifierReferenceContext classifierReferenceContext = ctx.classifierReference();
        AntlrClassifier classifier = classifierReferenceContext == null ? projectionParent.getClassifier() : this.compilerState.getDomainModel().getClassByName(classifierReferenceContext.getText());
        AntlrReferenceProperty<?> referenceProperty = classifier.getReferencePropertyByName(name);
        AntlrProjection projection = this.compilerState.getDomainModel().getProjectionByName(projectionName);
        AntlrProjectionProjectionReference projectionProjectionReference = new AntlrProjectionProjectionReference(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), projectionParent.getNumChildren() + 1, nameContext, (AntlrClassifier)referenceProperty.getType(), projectionParent, classifier, referenceProperty, projection);
        projectionParent.enterAntlrProjectionMember(projectionProjectionReference);
    }

    @Override
    public void exitProjectionProjectionReference(@Nonnull KlassParser.ProjectionProjectionReferenceContext ctx) {
        super.exitProjectionProjectionReference(ctx);
    }

    @Override
    public void enterProjectionParameterizedProperty(@Nonnull KlassParser.ProjectionParameterizedPropertyContext ctx) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".enterProjectionParameterizedProperty() not implemented yet");
    }

    @Override
    public void exitProjectionParameterizedProperty(@Nonnull KlassParser.ProjectionParameterizedPropertyContext ctx) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".exitProjectionParameterizedProperty() not implemented yet");
    }
}

