/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.phase;

import cool.klass.model.converter.compiler.CompilerState;
import cool.klass.model.converter.compiler.CompilerWalkState;
import cool.klass.model.converter.compiler.phase.AbstractCompilerPhase;
import cool.klass.model.converter.compiler.state.AntlrClassifier;
import cool.klass.model.converter.compiler.state.AntlrClassifierReference;
import cool.klass.model.converter.compiler.state.AntlrClassifierReferenceOwner;
import cool.klass.model.converter.compiler.state.AntlrDomainModel;
import cool.klass.model.converter.compiler.state.AntlrEnumeration;
import cool.klass.model.converter.compiler.state.AntlrMultiplicity;
import cool.klass.model.converter.compiler.state.AntlrMultiplicityOwner;
import cool.klass.model.converter.compiler.state.AntlrPrimitiveType;
import cool.klass.model.converter.compiler.state.property.AntlrAssociationEndSignature;
import cool.klass.model.converter.compiler.state.property.AntlrDataTypeProperty;
import cool.klass.model.converter.compiler.state.property.AntlrEnumerationProperty;
import cool.klass.model.converter.compiler.state.property.AntlrModifier;
import cool.klass.model.converter.compiler.state.property.AntlrPrimitiveProperty;
import cool.klass.model.converter.compiler.state.property.validation.AntlrMaxLengthPropertyValidation;
import cool.klass.model.converter.compiler.state.property.validation.AntlrMaxPropertyValidation;
import cool.klass.model.converter.compiler.state.property.validation.AntlrMinLengthPropertyValidation;
import cool.klass.model.converter.compiler.state.property.validation.AntlrMinPropertyValidation;
import cool.klass.model.meta.domain.api.PrimitiveType;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ParserRuleContext;

public class PropertyPhase
extends AbstractCompilerPhase {
    @Nullable
    private AntlrDataTypeProperty<?> dataTypeProperty;
    @Nullable
    private AntlrAssociationEndSignature associationEndSignature;
    @Nullable
    private AntlrClassifierReferenceOwner classifierReferenceOwner;
    @Nullable
    private AntlrMultiplicityOwner multiplicityOwner;

    public PropertyPhase(@Nonnull CompilerState compilerState) {
        super(compilerState);
    }

    @Override
    public void enterAssociationEndSignature(@Nonnull KlassParser.AssociationEndSignatureContext ctx) {
        super.enterAssociationEndSignature(ctx);
        if (this.associationEndSignature != null) {
            throw new IllegalStateException();
        }
        if (this.classifierReferenceOwner != null) {
            throw new IllegalStateException();
        }
        if (this.multiplicityOwner != null) {
            throw new IllegalStateException();
        }
        CompilerWalkState compilerWalk = this.compilerState.getCompilerWalk();
        this.associationEndSignature = new AntlrAssociationEndSignature(ctx, Optional.of(compilerWalk.getCurrentCompilationUnit()), compilerWalk.getNumClassifierMembers(), ctx.identifier(), this.getClassifier());
        this.classifierReferenceOwner = this.associationEndSignature;
        this.multiplicityOwner = this.associationEndSignature;
        this.getClassifier().enterAssociationEndSignature(this.associationEndSignature);
    }

    @Override
    public void exitAssociationEndSignature(@Nonnull KlassParser.AssociationEndSignatureContext ctx) {
        Objects.requireNonNull(this.associationEndSignature);
        this.associationEndSignature = null;
        this.classifierReferenceOwner = null;
        this.multiplicityOwner = null;
        super.exitAssociationEndSignature(ctx);
    }

    @Override
    public void enterPrimitiveProperty(@Nonnull KlassParser.PrimitivePropertyContext ctx) {
        super.enterPrimitiveProperty(ctx);
        boolean isOptional = ctx.optionalMarker() != null;
        String primitiveTypeName = ctx.primitiveType().getText();
        PrimitiveType primitiveType = PrimitiveType.byPrettyName((String)primitiveTypeName);
        AntlrPrimitiveType primitiveTypeState = AntlrPrimitiveType.valueOf(primitiveType);
        if (this.dataTypeProperty != null) {
            throw new IllegalStateException();
        }
        CompilerWalkState compilerWalk = this.compilerState.getCompilerWalk();
        this.dataTypeProperty = new AntlrPrimitiveProperty(ctx, Optional.of(compilerWalk.getCurrentCompilationUnit()), compilerWalk.getNumClassifierMembers(), ctx.identifier(), this.getClassifier(), isOptional, primitiveTypeState);
        this.getClassifier().enterDataTypeProperty(this.dataTypeProperty);
    }

    @Override
    public void exitPrimitiveProperty(@Nonnull KlassParser.PrimitivePropertyContext ctx) {
        Objects.requireNonNull(this.dataTypeProperty);
        this.dataTypeProperty = null;
        super.exitPrimitiveProperty(ctx);
    }

    @Override
    public void enterEnumerationProperty(@Nonnull KlassParser.EnumerationPropertyContext ctx) {
        super.enterEnumerationProperty(ctx);
        boolean isOptional = ctx.optionalMarker() != null;
        AntlrDomainModel domainModel = this.compilerState.getDomainModel();
        String enumerationName = ctx.enumerationReference().getText();
        AntlrEnumeration enumeration = domainModel.getEnumerationByName(enumerationName);
        if (this.dataTypeProperty != null) {
            throw new IllegalStateException();
        }
        CompilerWalkState compilerWalk = this.compilerState.getCompilerWalk();
        this.dataTypeProperty = new AntlrEnumerationProperty(ctx, Optional.of(compilerWalk.getCurrentCompilationUnit()), compilerWalk.getNumClassifierMembers(), ctx.identifier(), this.getClassifier(), isOptional, enumeration);
        this.getClassifier().enterDataTypeProperty(this.dataTypeProperty);
    }

    @Override
    public void exitEnumerationProperty(@Nonnull KlassParser.EnumerationPropertyContext ctx) {
        Objects.requireNonNull(this.dataTypeProperty);
        this.dataTypeProperty = null;
        super.exitEnumerationProperty(ctx);
    }

    @Override
    public void enterMinLengthValidation(@Nonnull KlassParser.MinLengthValidationContext ctx) {
        super.enterMinLengthValidation(ctx);
        KlassParser.IntegerLiteralContext integerLiteralContext = ctx.integerValidationParameter().integerLiteral();
        int length = this.getIntegerFromLiteral(integerLiteralContext);
        AntlrMinLengthPropertyValidation minLengthValidation = new AntlrMinLengthPropertyValidation(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), this.dataTypeProperty, length);
        this.dataTypeProperty.addMinLengthValidation(minLengthValidation);
    }

    @Override
    public void enterMaxLengthValidation(@Nonnull KlassParser.MaxLengthValidationContext ctx) {
        super.enterMaxLengthValidation(ctx);
        KlassParser.IntegerLiteralContext integerLiteralContext = ctx.integerValidationParameter().integerLiteral();
        int length = this.getIntegerFromLiteral(integerLiteralContext);
        AntlrMaxLengthPropertyValidation maxLengthValidation = new AntlrMaxLengthPropertyValidation(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), this.dataTypeProperty, length);
        this.dataTypeProperty.addMaxLengthValidation(maxLengthValidation);
    }

    @Override
    public void enterMinValidation(@Nonnull KlassParser.MinValidationContext ctx) {
        super.enterMinValidation(ctx);
        KlassParser.IntegerLiteralContext integerLiteralContext = ctx.integerValidationParameter().integerLiteral();
        int minimum = this.getIntegerFromLiteral(integerLiteralContext);
        AntlrMinPropertyValidation minValidation = new AntlrMinPropertyValidation(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), this.dataTypeProperty, minimum);
        this.dataTypeProperty.addMinValidation(minValidation);
    }

    @Override
    public void enterMaxValidation(@Nonnull KlassParser.MaxValidationContext ctx) {
        super.enterMaxValidation(ctx);
        KlassParser.IntegerLiteralContext integerLiteralContext = ctx.integerValidationParameter().integerLiteral();
        int maximum = this.getIntegerFromLiteral(integerLiteralContext);
        AntlrMaxPropertyValidation maxValidation = new AntlrMaxPropertyValidation(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), this.dataTypeProperty, maximum);
        this.dataTypeProperty.addMaxValidation(maxValidation);
    }

    @Override
    public void enterMultiplicity(@Nonnull KlassParser.MultiplicityContext ctx) {
        super.enterMultiplicity(ctx);
        if (this.multiplicityOwner == null) {
            return;
        }
        AntlrMultiplicity multiplicity = new AntlrMultiplicity(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), this.multiplicityOwner);
        this.associationEndSignature.enterMultiplicity(multiplicity);
    }

    @Override
    public void enterDataTypePropertyModifier(KlassParser.DataTypePropertyModifierContext ctx) {
        AntlrModifier modifier = new AntlrModifier((ParserRuleContext)ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), this.dataTypeProperty.getNumModifiers() + 1, this.dataTypeProperty);
        this.dataTypeProperty.enterModifier(modifier);
    }

    @Override
    public void enterAssociationEndModifier(@Nonnull KlassParser.AssociationEndModifierContext ctx) {
        super.enterAssociationEndModifier(ctx);
        if (this.associationEndSignature == null) {
            return;
        }
        AntlrModifier antlrAssociationEndModifier = new AntlrModifier((ParserRuleContext)ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), this.associationEndSignature.getNumModifiers() + 1, this.associationEndSignature);
        this.associationEndSignature.enterModifier(antlrAssociationEndModifier);
    }

    @Override
    public void enterClassifierReference(@Nonnull KlassParser.ClassifierReferenceContext ctx) {
        super.enterClassifierReference(ctx);
        if (this.classifierReferenceOwner == null) {
            return;
        }
        String classifierName = ctx.identifier().getText();
        AntlrDomainModel domainModel = this.compilerState.getDomainModel();
        AntlrClassifier classifier = domainModel.getClassifierByName(classifierName);
        AntlrClassifierReference classifierReference = new AntlrClassifierReference(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), this.classifierReferenceOwner, classifier);
        this.classifierReferenceOwner.enterClassifierReference(classifierReference);
    }

    private int getIntegerFromLiteral(@Nonnull KlassParser.IntegerLiteralContext integerLiteralContext) {
        String integerText = integerLiteralContext.getText();
        String withoutUnderscores = integerText.replaceAll("_", "");
        return Integer.decode(withoutUnderscores);
    }

    @Nullable
    private AntlrClassifier getClassifier() {
        return this.compilerState.getCompilerWalk().getClassifier();
    }
}

