/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.phase;

import cool.klass.model.converter.compiler.CompilerState;
import cool.klass.model.converter.compiler.phase.AbstractCompilerPhase;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.projection.AntlrProjection;
import cool.klass.model.converter.compiler.state.service.AntlrService;
import cool.klass.model.converter.compiler.state.service.AntlrServiceGroup;
import cool.klass.model.converter.compiler.state.service.AntlrServiceProjectionDispatch;
import cool.klass.model.converter.compiler.state.service.AntlrVerb;
import cool.klass.model.converter.compiler.state.service.url.AntlrUrl;
import cool.klass.model.meta.domain.api.service.Verb;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ParserRuleContext;

public class ServicePhase
extends AbstractCompilerPhase {
    @Nullable
    private AntlrServiceGroup serviceGroup;
    @Nullable
    private AntlrUrl url;
    @Nullable
    private AntlrService service;

    public ServicePhase(@Nonnull CompilerState compilerState) {
        super(compilerState);
    }

    @Override
    public void enterServiceGroupDeclaration(@Nonnull KlassParser.ServiceGroupDeclarationContext ctx) {
        super.enterServiceGroupDeclaration(ctx);
        KlassParser.IdentifierContext nameContext = ctx.identifier();
        String serviceClassName = ctx.classReference().getText();
        AntlrClass klass = this.compilerState.getDomainModel().getClassByName(serviceClassName);
        this.serviceGroup = new AntlrServiceGroup(ctx, this.compilerState.getCompilerWalk().getCompilationUnit(), this.compilerState.getOrdinal((ParserRuleContext)ctx), nameContext, klass);
    }

    @Override
    public void exitServiceGroupDeclaration(@Nonnull KlassParser.ServiceGroupDeclarationContext ctx) {
        this.compilerState.getDomainModel().exitServiceGroupDeclaration(this.serviceGroup);
        this.serviceGroup = null;
        super.exitServiceGroupDeclaration(ctx);
    }

    @Override
    public void enterUrlDeclaration(@Nonnull KlassParser.UrlDeclarationContext ctx) {
        super.enterUrlDeclaration(ctx);
        this.url = new AntlrUrl(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), this.serviceGroup);
        this.serviceGroup.enterUrlDeclaration(this.url);
    }

    @Override
    public void exitUrlDeclaration(@Nonnull KlassParser.UrlDeclarationContext ctx) {
        this.url = null;
        super.exitUrlDeclaration(ctx);
    }

    @Override
    public void enterServiceDeclaration(@Nonnull KlassParser.ServiceDeclarationContext ctx) {
        super.enterServiceDeclaration(ctx);
        KlassParser.VerbContext verb = ctx.verb();
        AntlrVerb antlrVerb = new AntlrVerb(verb, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), Verb.valueOf((String)verb.getText()));
        this.service = new AntlrService(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), this.url, antlrVerb);
    }

    @Override
    public void exitServiceDeclaration(@Nonnull KlassParser.ServiceDeclarationContext ctx) {
        this.url.exitServiceDeclaration(this.service);
        this.service = null;
        super.exitServiceDeclaration(ctx);
    }

    @Override
    public void enterServiceProjectionDispatch(@Nonnull KlassParser.ServiceProjectionDispatchContext ctx) {
        super.enterServiceProjectionDispatch(ctx);
        KlassParser.ProjectionReferenceContext projectionReferenceContext = ctx.projectionReference();
        String projectionName = projectionReferenceContext.identifier().getText();
        AntlrProjection projection = this.compilerState.getDomainModel().getProjectionByName(projectionName);
        if (ctx.argumentList() != null && !ctx.argumentList().argument().isEmpty()) {
            throw new AssertionError();
        }
        AntlrServiceProjectionDispatch projectionDispatch = new AntlrServiceProjectionDispatch(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), this.service, projection);
        this.service.enterServiceProjectionDispatch(projectionDispatch);
    }
}

