/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.phase.criteria;

import cool.klass.model.converter.compiler.CompilerState;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.value.literal.AbstractAntlrLiteralValue;
import cool.klass.model.converter.compiler.state.value.literal.AntlrBooleanLiteralValue;
import cool.klass.model.converter.compiler.state.value.literal.AntlrFloatingPointLiteralValue;
import cool.klass.model.converter.compiler.state.value.literal.AntlrIntegerLiteralValue;
import cool.klass.model.converter.compiler.state.value.literal.AntlrNullLiteral;
import cool.klass.model.converter.compiler.state.value.literal.AntlrStringLiteralValue;
import cool.klass.model.meta.grammar.KlassBaseVisitor;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class LiteralValueVisitor
extends KlassBaseVisitor<AbstractAntlrLiteralValue> {
    @Nonnull
    private final CompilerState compilerState;
    @Nonnull
    private final IAntlrElement expressionValueOwner;

    public LiteralValueVisitor(@Nonnull CompilerState compilerState, @Nonnull IAntlrElement expressionValueOwner) {
        this.compilerState = Objects.requireNonNull(compilerState);
        this.expressionValueOwner = Objects.requireNonNull(expressionValueOwner);
    }

    @Nonnull
    public AntlrIntegerLiteralValue visitIntegerLiteral(@Nonnull KlassParser.IntegerLiteralContext ctx) {
        long value = Long.parseLong(ctx.getText());
        return new AntlrIntegerLiteralValue(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), value, this.expressionValueOwner);
    }

    @Nonnull
    public AntlrFloatingPointLiteralValue visitFloatingPointLiteral(KlassParser.FloatingPointLiteralContext ctx) {
        double value = Double.parseDouble(ctx.getText());
        return new AntlrFloatingPointLiteralValue(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), value, this.expressionValueOwner);
    }

    @Nonnull
    public AntlrBooleanLiteralValue visitBooleanLiteral(KlassParser.BooleanLiteralContext ctx) {
        boolean value = Boolean.parseBoolean(ctx.getText());
        return new AntlrBooleanLiteralValue(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), value, this.expressionValueOwner);
    }

    @Nonnull
    public AbstractAntlrLiteralValue visitCharacterLiteral(KlassParser.CharacterLiteralContext ctx) {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getSimpleName() + ".visitCharacterLiteral() not implemented yet");
    }

    @Nonnull
    public AntlrStringLiteralValue visitStringLiteral(@Nonnull KlassParser.StringLiteralContext ctx) {
        String quotedText = ctx.getText();
        String text = quotedText.substring(1, quotedText.length() - 1);
        return new AntlrStringLiteralValue(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), text, this.expressionValueOwner);
    }

    @Nonnull
    public AntlrNullLiteral visitNullLiteral(@Nonnull KlassParser.NullLiteralContext ctx) {
        return new AntlrNullLiteral(ctx, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), this.expressionValueOwner);
    }
}

