/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state.criteria;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.state.AntlrAssociation;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.AntlrType;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.criteria.AntlrCriteria;
import cool.klass.model.converter.compiler.state.criteria.AntlrCriteriaVisitor;
import cool.klass.model.converter.compiler.state.operator.AntlrOperator;
import cool.klass.model.converter.compiler.state.parameter.AntlrParameter;
import cool.klass.model.converter.compiler.state.property.AntlrAssociationEnd;
import cool.klass.model.converter.compiler.state.property.AntlrDataTypeProperty;
import cool.klass.model.converter.compiler.state.value.AntlrExpressionValue;
import cool.klass.model.converter.compiler.state.value.AntlrThisMemberReferencePath;
import cool.klass.model.converter.compiler.state.value.AntlrTypeMemberReferencePath;
import cool.klass.model.converter.compiler.state.value.literal.AbstractAntlrLiteralValue;
import cool.klass.model.meta.domain.criteria.OperatorCriteriaImpl;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.map.OrderedMap;

public class OperatorAntlrCriteria
extends AntlrCriteria {
    @Nonnull
    private final AntlrOperator operator;
    private AntlrExpressionValue sourceValue;
    private AntlrExpressionValue targetValue;
    private OperatorCriteriaImpl.OperatorCriteriaBuilder elementBuilder;

    public OperatorAntlrCriteria(@Nonnull KlassParser.CriteriaOperatorContext elementContext, @Nonnull Optional<CompilationUnit> compilationUnit, @Nonnull IAntlrElement criteriaOwner, @Nonnull AntlrOperator operator) {
        super((ParserRuleContext)elementContext, compilationUnit, criteriaOwner);
        this.operator = Objects.requireNonNull(operator);
    }

    @Nonnull
    public KlassParser.CriteriaOperatorContext getElementContext() {
        return (KlassParser.CriteriaOperatorContext)super.getElementContext();
    }

    @Nullable
    public AntlrExpressionValue getSourceValue() {
        return Objects.requireNonNull(this.sourceValue);
    }

    public void setSourceValue(@Nonnull AntlrExpressionValue sourceValue) {
        if (this.sourceValue != null) {
            throw new IllegalArgumentException(this.sourceValue.toString());
        }
        this.sourceValue = Objects.requireNonNull(sourceValue);
    }

    @Nullable
    public AntlrExpressionValue getTargetValue() {
        return Objects.requireNonNull(this.targetValue);
    }

    public void setTargetValue(@Nonnull AntlrExpressionValue targetValue) {
        if (this.targetValue != null) {
            throw new IllegalArgumentException(this.targetValue.toString());
        }
        this.targetValue = Objects.requireNonNull(targetValue);
    }

    @Nonnull
    public OperatorCriteriaImpl.OperatorCriteriaBuilder build() {
        if (this.elementBuilder != null) {
            throw new IllegalStateException(this.elementBuilder.toString());
        }
        this.elementBuilder = new OperatorCriteriaImpl.OperatorCriteriaBuilder((KlassParser.CriteriaOperatorContext)this.elementContext, this.getMacroElementBuilder(), this.getSourceCodeBuilder(), this.operator.build(), this.sourceValue.build(), this.targetValue.build());
        return this.elementBuilder;
    }

    @Nonnull
    public OperatorCriteriaImpl.OperatorCriteriaBuilder getElementBuilder() {
        return Objects.requireNonNull(this.elementBuilder);
    }

    @Override
    public void reportErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        this.sourceValue.reportErrors(compilerAnnotationHolder);
        this.targetValue.reportErrors(compilerAnnotationHolder);
        ImmutableList<AntlrType> sourceTypes = this.sourceValue.getPossibleTypes();
        ImmutableList<AntlrType> targetTypes = this.targetValue.getPossibleTypes();
        this.operator.checkTypes(compilerAnnotationHolder, (ListIterable<AntlrType>)sourceTypes, (ListIterable<AntlrType>)targetTypes);
    }

    @Override
    public void resolveServiceVariables(@Nonnull OrderedMap<String, AntlrParameter> formalParametersByName) {
        this.sourceValue.resolveServiceVariables(formalParametersByName);
        this.targetValue.resolveServiceVariables(formalParametersByName);
    }

    @Override
    public void resolveTypes() {
        AbstractAntlrLiteralValue literalValue;
        ImmutableList<AntlrType> sourcePossibleTypes = this.sourceValue.getPossibleTypes();
        ImmutableList<AntlrType> targetPossibleTypes = this.targetValue.getPossibleTypes();
        AntlrExpressionValue antlrExpressionValue = this.sourceValue;
        if (antlrExpressionValue instanceof AbstractAntlrLiteralValue) {
            literalValue = (AbstractAntlrLiteralValue)antlrExpressionValue;
            if (targetPossibleTypes.size() != 1) {
                return;
            }
            literalValue.setInferredType((AntlrType)targetPossibleTypes.getOnly());
        }
        if ((antlrExpressionValue = this.targetValue) instanceof AbstractAntlrLiteralValue) {
            literalValue = (AbstractAntlrLiteralValue)antlrExpressionValue;
            if (sourcePossibleTypes.size() != 1) {
                return;
            }
            literalValue.setInferredType((AntlrType)sourcePossibleTypes.getOnly());
        }
    }

    @Override
    public void addForeignKeys() {
        AntlrDataTypeProperty<?> keyProperty;
        AntlrAssociation association = this.getSurroundingElement(AntlrAssociation.class).get();
        AntlrAssociationEnd sourceEnd = association.getSourceEnd();
        AntlrAssociationEnd targetEnd = association.getTargetEnd();
        AntlrThisMemberReferencePath thisMemberReferencePath = this.getThisMemberReferencePath();
        AntlrTypeMemberReferencePath typeMemberReferencePath = this.getTypeMemberReferencePath();
        AntlrDataTypeProperty<?> thisDataTypeProperty = thisMemberReferencePath.getDataTypeProperty();
        AntlrDataTypeProperty<?> typeDataTypeProperty = typeMemberReferencePath.getDataTypeProperty();
        if (sourceEnd.isToMany() && targetEnd.isToMany()) {
            throw new AssertionError((Object)"TODO: Support many-to-many associations");
        }
        AntlrAssociationEnd endWithForeignKeys = this.getEndWithForeignKeys(association, thisDataTypeProperty, typeDataTypeProperty);
        if (endWithForeignKeys == null) {
            return;
        }
        AntlrClass typeWithForeignKeys = endWithForeignKeys.getOwningClassifier();
        if (typeWithForeignKeys == AntlrClass.NOT_FOUND || typeWithForeignKeys == AntlrClass.AMBIGUOUS) {
            return;
        }
        if (!endWithForeignKeys.isToOne()) {
            throw new AssertionError();
        }
        boolean isTargetEnd = endWithForeignKeys.isTargetEnd();
        AntlrDataTypeProperty<?> foreignKeyProperty = isTargetEnd ? thisDataTypeProperty : typeDataTypeProperty;
        AntlrDataTypeProperty<?> antlrDataTypeProperty = keyProperty = isTargetEnd ? typeDataTypeProperty : thisDataTypeProperty;
        if (!foreignKeyProperty.isKey() || !keyProperty.isKey()) {
            // empty if block
        }
        endWithForeignKeys.addForeignKeyPropertyMatchingProperty(foreignKeyProperty, keyProperty);
    }

    @Override
    public void visit(AntlrCriteriaVisitor visitor) {
        visitor.visitOperator(this);
    }

    @Nullable
    private AntlrAssociationEnd getEndWithForeignKeys(@Nonnull AntlrAssociation association, @Nonnull AntlrDataTypeProperty<?> thisDataTypeProperty, @Nonnull AntlrDataTypeProperty<?> typeDataTypeProperty) {
        AntlrAssociationEnd sourceEnd = association.getSourceEnd();
        AntlrAssociationEnd targetEnd = association.getTargetEnd();
        if (targetEnd.isToMany()) {
            return sourceEnd;
        }
        if (sourceEnd.isToMany()) {
            return targetEnd;
        }
        if (sourceEnd.isToOneRequired() && targetEnd.isToOneOptional()) {
            return sourceEnd;
        }
        if (targetEnd.isToOneRequired() && sourceEnd.isToOneOptional()) {
            return targetEnd;
        }
        if (thisDataTypeProperty.isKey() && !typeDataTypeProperty.isKey()) {
            return sourceEnd;
        }
        if (typeDataTypeProperty.isKey() && !thisDataTypeProperty.isKey()) {
            return targetEnd;
        }
        if (sourceEnd.isToOne() && targetEnd.isToOne()) {
            if (sourceEnd.isOwned() && !targetEnd.isOwned()) {
                return targetEnd;
            }
            if (!sourceEnd.isOwned() && targetEnd.isOwned()) {
                return sourceEnd;
            }
        }
        return null;
    }

    @Nonnull
    private AntlrThisMemberReferencePath getThisMemberReferencePath() {
        AntlrExpressionValue antlrExpressionValue = this.sourceValue;
        if (antlrExpressionValue instanceof AntlrThisMemberReferencePath) {
            AntlrThisMemberReferencePath memberReferencePath = (AntlrThisMemberReferencePath)antlrExpressionValue;
            return memberReferencePath;
        }
        antlrExpressionValue = this.targetValue;
        if (antlrExpressionValue instanceof AntlrThisMemberReferencePath) {
            AntlrThisMemberReferencePath memberReferencePath = (AntlrThisMemberReferencePath)antlrExpressionValue;
            return memberReferencePath;
        }
        throw new AssertionError();
    }

    @Nonnull
    private AntlrTypeMemberReferencePath getTypeMemberReferencePath() {
        AntlrExpressionValue antlrExpressionValue = this.sourceValue;
        if (antlrExpressionValue instanceof AntlrTypeMemberReferencePath) {
            AntlrTypeMemberReferencePath memberReferencePath = (AntlrTypeMemberReferencePath)antlrExpressionValue;
            return memberReferencePath;
        }
        antlrExpressionValue = this.targetValue;
        if (antlrExpressionValue instanceof AntlrTypeMemberReferencePath) {
            AntlrTypeMemberReferencePath memberReferencePath = (AntlrTypeMemberReferencePath)antlrExpressionValue;
            return memberReferencePath;
        }
        throw new AssertionError();
    }
}

