/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state.property;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.AntlrClassifier;
import cool.klass.model.converter.compiler.state.AntlrMultiplicity;
import cool.klass.model.converter.compiler.state.AntlrMultiplicityOwner;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.order.AntlrOrderBy;
import cool.klass.model.converter.compiler.state.order.AntlrOrderByOwner;
import cool.klass.model.converter.compiler.state.property.AntlrModifier;
import cool.klass.model.converter.compiler.state.property.AntlrProperty;
import cool.klass.model.meta.domain.api.Multiplicity;
import cool.klass.model.meta.domain.property.ReferencePropertyImpl;
import cool.klass.model.meta.grammar.KlassParser;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.impl.list.fixed.ArrayAdapter;

public abstract class AntlrReferenceProperty<Type extends AntlrClassifier>
extends AntlrProperty
implements AntlrOrderByOwner,
AntlrMultiplicityOwner {
    public static final AntlrReferenceProperty AMBIGUOUS = new AntlrReferenceProperty(new ParserRuleContext(AMBIGUOUS_PARENT, -1), Optional.empty(), -1, AMBIGUOUS_IDENTIFIER_CONTEXT){

        @Override
        @Nonnull
        public AntlrClassifier getType() {
            return AntlrClassifier.AMBIGUOUS;
        }

        @Override
        public String toString() {
            return AntlrReferenceProperty.class.getSimpleName() + ".AMBIGUOUS";
        }

        @Override
        public AntlrMultiplicity getMultiplicity() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getMultiplicity() not implemented yet");
        }

        @Override
        @Nonnull
        public ReferencePropertyImpl.ReferencePropertyBuilder<?, ?, ?> build() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".build() not implemented yet");
        }

        @Override
        @Nonnull
        public ReferencePropertyImpl.ReferencePropertyBuilder<?, ?, ?> getElementBuilder() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getElementBuilder() not implemented yet");
        }

        @Override
        protected KlassParser.IdentifierContext getTypeIdentifier() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getTypeIdentifier() not implemented yet");
        }

        @Override
        @Nonnull
        public AntlrClassifier getOwningClassifier() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getOwningClassifier() not implemented yet");
        }

        @Override
        @Nonnull
        public Optional<IAntlrElement> getSurroundingElement() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getSurroundingElement() not implemented yet");
        }
    };
    public static final AntlrReferenceProperty NOT_FOUND = new AntlrReferenceProperty(new ParserRuleContext(NOT_FOUND_PARENT, -1), Optional.empty(), -1, NOT_FOUND_IDENTIFIER_CONTEXT){

        @Override
        @Nonnull
        public AntlrClassifier getType() {
            return AntlrClassifier.NOT_FOUND;
        }

        @Override
        public String toString() {
            return AntlrReferenceProperty.class.getSimpleName() + ".NOT_FOUND";
        }

        @Override
        @Nonnull
        public Optional<IAntlrElement> getSurroundingElement() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getSurroundingElement() not implemented yet");
        }

        @Override
        public AntlrMultiplicity getMultiplicity() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getMultiplicity() not implemented yet");
        }

        @Override
        @Nonnull
        public ReferencePropertyImpl.ReferencePropertyBuilder<?, ?, ?> build() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".build() not implemented yet");
        }

        @Override
        @Nonnull
        public ReferencePropertyImpl.ReferencePropertyBuilder<?, ?, ?> getElementBuilder() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getElementBuilder() not implemented yet");
        }

        @Override
        @Nonnull
        public AntlrClassifier getOwningClassifier() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getOwningClassifier() not implemented yet");
        }

        @Override
        protected KlassParser.IdentifierContext getTypeIdentifier() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getTypeIdentifier() not implemented yet");
        }
    };
    @Nonnull
    protected Optional<AntlrOrderBy> orderBy = Optional.empty();
    protected AntlrMultiplicity multiplicity;

    protected AntlrReferenceProperty(@Nonnull ParserRuleContext elementContext, @Nonnull Optional<CompilationUnit> compilationUnit, int ordinal, @Nonnull KlassParser.IdentifierContext nameContext) {
        super(elementContext, compilationUnit, ordinal, nameContext);
    }

    @Nonnull
    public abstract Type getType();

    @Nonnull
    public abstract ReferencePropertyImpl.ReferencePropertyBuilder<?, ?, ?> build();

    public AntlrMultiplicity getMultiplicity() {
        return this.multiplicity;
    }

    public boolean isToOne() {
        return this.multiplicity != null && this.multiplicity.isToOne();
    }

    public boolean isToMany() {
        return this.multiplicity != null && this.multiplicity.isToMany();
    }

    public boolean isToOneOptional() {
        return this.multiplicity != null && this.multiplicity.getMultiplicity() == Multiplicity.ZERO_TO_ONE;
    }

    public boolean isToOneRequired() {
        return this.multiplicity != null && this.multiplicity.getMultiplicity() == Multiplicity.ONE_TO_ONE;
    }

    public boolean isOwned() {
        return this.getModifiers().anySatisfy(AntlrModifier::isOwned);
    }

    protected void reportInvalidMultiplicity(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        if (this.multiplicity.getMultiplicity() == null) {
            String multiplicityChoices = ArrayAdapter.adapt((Object[])Multiplicity.values()).collect(Multiplicity::getPrettyName).collect((Function & Serializable)each -> "[" + each + "]").makeString();
            String message = String.format("Reference property '%s: %s[%s..%s]' has invalid multiplicity. Expected one of %s.", this.getName(), this.getOwningClassifier().getName(), this.multiplicity.getLowerBoundText(), this.multiplicity.getUpperBoundText(), multiplicityChoices);
            compilerAnnotationHolder.add("ERR_ASO_MUL", message, this.multiplicity);
        }
    }

    @Nonnull
    public abstract ReferencePropertyImpl.ReferencePropertyBuilder<?, ?, ?> getElementBuilder();

    @Override
    public void enterMultiplicity(@Nonnull AntlrMultiplicity multiplicity) {
        if (this.multiplicity != null) {
            throw new AssertionError();
        }
        this.multiplicity = Objects.requireNonNull(multiplicity);
    }

    @Override
    public void enterOrderByDeclaration(@Nonnull AntlrOrderBy orderBy) {
        if (this.orderBy.isPresent()) {
            throw new IllegalStateException();
        }
        this.orderBy = Optional.of(orderBy);
    }

    @Override
    @Nonnull
    public Optional<AntlrOrderBy> getOrderBy() {
        return this.orderBy;
    }

    @Override
    public void reportErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        super.reportErrors(compilerAnnotationHolder);
        this.reportToOneOrderBy(compilerAnnotationHolder);
    }

    public void reportTypeNotFound(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        if (this.getType() != AntlrClass.NOT_FOUND) {
            return;
        }
        KlassParser.IdentifierContext offendingToken = this.getTypeIdentifier();
        String message = String.format("Cannot find class '%s'.", offendingToken.getText());
        compilerAnnotationHolder.add("ERR_REF_TYP", message, (IAntlrElement)this, (ParserRuleContext)offendingToken);
    }

    public void reportToOneOrderBy(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        if (!this.isToOne()) {
            return;
        }
        if (this.orderBy.isEmpty()) {
            return;
        }
        String message = String.format("Reference property '%s.%s' is to-one but has an order-by clause. Order by clauses are only valid for to-many properties.", this.getOwningClassifier().getName(), this.getName());
        compilerAnnotationHolder.add("ERR_REF_ORD", message, this.orderBy.get());
    }

    protected abstract KlassParser.IdentifierContext getTypeIdentifier();

    @Override
    public String getTypeName() {
        return this.getTypeIdentifier().getText();
    }
}

