/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state.value;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.property.AntlrAssociationEnd;
import cool.klass.model.converter.compiler.state.property.AntlrDataTypeProperty;
import cool.klass.model.converter.compiler.state.value.AntlrExpressionValue;
import cool.klass.model.meta.domain.value.AbstractMemberReferencePath;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.collections.api.list.ImmutableList;

public abstract class AntlrMemberReferencePath
extends AntlrExpressionValue {
    @Nonnull
    protected final AntlrClass klass;
    @Nonnull
    protected final ImmutableList<AntlrAssociationEnd> associationEnd;
    @Nonnull
    protected final AntlrDataTypeProperty<?> dataTypeProperty;

    protected AntlrMemberReferencePath(@Nonnull ParserRuleContext elementContext, @Nonnull Optional<CompilationUnit> compilationUnit, @Nonnull AntlrClass klass, @Nonnull ImmutableList<AntlrAssociationEnd> associationEnd, @Nonnull AntlrDataTypeProperty<?> dataTypeProperty, @Nonnull IAntlrElement expressionValueOwner) {
        super(elementContext, compilationUnit, expressionValueOwner);
        this.klass = Objects.requireNonNull(klass);
        this.associationEnd = Objects.requireNonNull(associationEnd);
        this.dataTypeProperty = Objects.requireNonNull(dataTypeProperty);
    }

    @Nonnull
    public AntlrClass getKlass() {
        return this.klass;
    }

    @Nonnull
    public ImmutableList<AntlrAssociationEnd> getAssociationEnds() {
        return this.associationEnd;
    }

    @Nonnull
    public AntlrDataTypeProperty<?> getDataTypeProperty() {
        return this.dataTypeProperty;
    }

    @Nonnull
    public abstract AbstractMemberReferencePath.AbstractMemberReferencePathBuilder<?> build();

    @Nullable
    protected AntlrClass reportErrorsAssociationEnds(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder, @Nonnull List<KlassParser.AssociationEndReferenceContext> associationEndReferenceContexts) {
        AntlrClass currentClass = this.klass;
        for (int i = 0; i < this.associationEnd.size(); ++i) {
            AntlrAssociationEnd associationEnd = (AntlrAssociationEnd)this.associationEnd.get(i);
            if (associationEnd == AntlrAssociationEnd.NOT_FOUND) {
                KlassParser.IdentifierContext identifier = associationEndReferenceContexts.get(i).identifier();
                String message = String.format("Cannot find member '%s.%s'.", currentClass.getName(), identifier.getText());
                compilerAnnotationHolder.add("ERR_MEM_EXP", message, (IAntlrElement)this, (ParserRuleContext)identifier);
                return null;
            }
            currentClass = associationEnd.getType();
        }
        return currentClass;
    }
}

