/*
 * Copyright 2024 Craig Motlin
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cool.klass.model.converter.compiler.state;

import java.util.Optional;

import javax.annotation.Nonnull;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.meta.grammar.KlassParser.IdentifierContext;
import org.antlr.v4.runtime.ParserRuleContext;

public abstract class AntlrIdentifierElement extends AntlrNamedElement {

    public static final IdentifierContext AMBIGUOUS_IDENTIFIER_CONTEXT = new IdentifierContext(AMBIGUOUS_PARENT, -1);
    public static final IdentifierContext NOT_FOUND_IDENTIFIER_CONTEXT = new IdentifierContext(NOT_FOUND_PARENT, -1);

    protected AntlrIdentifierElement(
        @Nonnull ParserRuleContext elementContext,
        @Nonnull Optional<CompilationUnit> compilationUnit,
        int ordinal,
        @Nonnull IdentifierContext nameContext
    ) {
        super(elementContext, compilationUnit, ordinal, nameContext);
    }

    @Nonnull
    @Override
    public IdentifierContext getNameContext() {
        return (IdentifierContext) super.getNameContext();
    }
}
