/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.phase;

import cool.klass.model.converter.compiler.CompilerState;
import cool.klass.model.converter.compiler.phase.AbstractCompilerPhase;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.AntlrClassifier;
import cool.klass.model.converter.compiler.state.AntlrInterface;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.List;
import javax.annotation.Nonnull;

public class InheritancePhase
extends AbstractCompilerPhase {
    public InheritancePhase(@Nonnull CompilerState compilerState) {
        super(compilerState);
    }

    @Override
    public void enterExtendsDeclaration(@Nonnull KlassParser.ExtendsDeclarationContext ctx) {
        super.enterExtendsDeclaration(ctx);
        KlassParser.ClassReferenceContext classReferenceContext = ctx.classReference();
        KlassParser.IdentifierContext identifier = classReferenceContext.identifier();
        String className = identifier.getText();
        AntlrClass superClass = this.compilerState.getDomainModel().getClassByName(className);
        AntlrClass klass = this.compilerState.getCompilerWalk().getKlass();
        klass.enterExtendsDeclaration(superClass);
    }

    @Override
    public void enterImplementsDeclaration(@Nonnull KlassParser.ImplementsDeclarationContext ctx) {
        super.enterImplementsDeclaration(ctx);
        AntlrClassifier classifier = this.compilerState.getCompilerWalk().getClassifier();
        List interfaceReferenceContexts = ctx.interfaceReference();
        for (KlassParser.InterfaceReferenceContext interfaceReferenceContext : interfaceReferenceContexts) {
            KlassParser.IdentifierContext identifier = interfaceReferenceContext.identifier();
            String interfaceName = identifier.getText();
            AntlrInterface iface = this.compilerState.getDomainModel().getInterfaceByName(interfaceName);
            classifier.enterImplementsDeclaration(iface);
        }
    }
}

