/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.phase;

import cool.klass.model.converter.compiler.CompilerState;
import cool.klass.model.converter.compiler.phase.AbstractCompilerPhase;
import cool.klass.model.converter.compiler.state.service.AntlrService;
import cool.klass.model.converter.compiler.state.service.AntlrServiceMultiplicity;
import cool.klass.model.meta.domain.api.service.ServiceMultiplicity;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Optional;
import javax.annotation.Nonnull;

public class ServiceMultiplicityPhase
extends AbstractCompilerPhase {
    public ServiceMultiplicityPhase(@Nonnull CompilerState compilerState) {
        super(compilerState);
    }

    @Override
    public void enterServiceMultiplicityDeclaration(KlassParser.ServiceMultiplicityDeclarationContext ctx) {
        super.enterServiceMultiplicityDeclaration(ctx);
        KlassParser.ServiceMultiplicityContext multiplicityContext = ctx.serviceMultiplicity();
        AntlrServiceMultiplicity serviceMultiplicity = new AntlrServiceMultiplicity(multiplicityContext, Optional.of(this.compilerState.getCompilerWalk().getCurrentCompilationUnit()), this.getServiceMultiplicity(multiplicityContext));
        AntlrService service = this.compilerState.getCompilerWalk().getService();
        service.enterServiceMultiplicityDeclaration(serviceMultiplicity);
    }

    @Nonnull
    private ServiceMultiplicity getServiceMultiplicity(@Nonnull KlassParser.ServiceMultiplicityContext serviceMultiplicityContext) {
        if (serviceMultiplicityContext.one != null) {
            return ServiceMultiplicity.ONE;
        }
        if (serviceMultiplicityContext.many != null) {
            return ServiceMultiplicity.MANY;
        }
        throw new AssertionError();
    }
}

