/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.phase;

import cool.klass.model.converter.compiler.CompilerState;
import cool.klass.model.converter.compiler.phase.AbstractCompilerPhase;
import cool.klass.model.converter.compiler.phase.ClassifierPhase;
import cool.klass.model.converter.compiler.phase.CompilationUnitPhase;
import cool.klass.model.converter.compiler.phase.PropertyPhase;
import cool.klass.model.converter.compiler.phase.TopLevelElementsPhase;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.property.AntlrDataTypeProperty;
import cool.klass.model.converter.compiler.state.property.AntlrModifier;
import cool.klass.model.converter.compiler.state.property.validation.AbstractAntlrPropertyValidation;
import cool.klass.model.meta.grammar.KlassParser;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.impl.factory.Lists;

public class VersionClassInferencePhase
extends AbstractCompilerPhase {
    public VersionClassInferencePhase(@Nonnull CompilerState compilerState) {
        super(compilerState);
    }

    @Override
    @Nonnull
    public String getName() {
        return "Version class";
    }

    @Override
    public void enterClassifierModifier(@Nonnull KlassParser.ClassifierModifierContext ctx) {
        super.enterClassifierModifier(ctx);
        String modifierText = ctx.getText();
        if (!"versioned".equals(modifierText)) {
            return;
        }
        String klassSourceCode = this.getSourceCode();
        AntlrModifier classifierModifierState = this.compilerState.getCompilerWalk().getClassifierModifier();
        ImmutableList compilerPhases = Lists.immutable.with((Object)new CompilationUnitPhase(this.compilerState), (Object)new TopLevelElementsPhase(this.compilerState), (Object)new ClassifierPhase(this.compilerState), (Object)new PropertyPhase(this.compilerState));
        this.compilerState.runRootCompilerMacro(classifierModifierState, this, klassSourceCode, (Function<KlassParser, ? extends ParserRuleContext>)((Function & Serializable)KlassParser::compilationUnit), (ImmutableList<ParseTreeListener>)compilerPhases);
    }

    @Nonnull
    private String getSourceCode() {
        AntlrClass klass = this.compilerState.getCompilerWalk().getKlass();
        String propertySourceCode = klass.getAllDataTypeProperties().select((Predicate & Serializable)property -> property.isKey() || property.isValid() || property.isSystem() || property.isAudit()).collect(this::getSourceCode).collect((Function & Serializable)each -> String.format("    %s\n", each)).makeString("");
        AntlrModifier auditedModifier = klass.getModifierByName("audited");
        String auditedSourceCode = auditedModifier == AntlrModifier.NOT_FOUND ? "" : " audited";
        return "package " + klass.getPackageName() + "\n\nclass " + klass.getName() + "Version systemTemporal" + auditedSourceCode + "\n{\n" + propertySourceCode + "    number: Integer version;\n}\n";
    }

    private String getSourceCode(@Nonnull AntlrDataTypeProperty<?> dataTypeProperty) {
        String isOptionalString = dataTypeProperty.isOptional() ? "?" : "";
        ListIterable modifiers = dataTypeProperty.getModifiers().reject(AntlrModifier::isId);
        String modifierSourceCode = modifiers.isEmpty() ? "" : modifiers.collect(AntlrModifier::getKeyword).makeString(" ", " ", "");
        ListIterable<AbstractAntlrPropertyValidation> validations = dataTypeProperty.getValidations();
        String validationSourceCode = validations.isEmpty() ? "" : validations.makeString(" ", " ", "");
        return String.format("%s: %s%s%s%s;", dataTypeProperty.getName(), dataTypeProperty.getType().getName(), isOptionalString, modifierSourceCode, validationSourceCode);
    }
}

