/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state;

import cool.klass.model.converter.compiler.annotation.CompilerAnnotationHolder;
import cool.klass.model.converter.compiler.state.AntlrClass;
import cool.klass.model.converter.compiler.state.AntlrCompilationUnit;
import cool.klass.model.converter.compiler.state.AntlrPackageableElement;
import cool.klass.model.converter.compiler.state.AntlrRelationship;
import cool.klass.model.converter.compiler.state.AntlrTopLevelElement;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.converter.compiler.state.criteria.AntlrCriteriaVisitor;
import cool.klass.model.converter.compiler.state.property.AntlrAssociationEnd;
import cool.klass.model.converter.compiler.state.property.AntlrModifier;
import cool.klass.model.meta.domain.AssociationImpl;
import cool.klass.model.meta.domain.criteria.AbstractCriteria;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableOrderedMap;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.map.ordered.mutable.OrderedMapAdapter;

public class AntlrAssociation
extends AntlrPackageableElement
implements AntlrTopLevelElement {
    public static final AntlrAssociation AMBIGUOUS = new AntlrAssociation(new KlassParser.AssociationDeclarationContext(AMBIGUOUS_PARENT, -1), AntlrCompilationUnit.AMBIGUOUS, -1, AMBIGUOUS_IDENTIFIER_CONTEXT){

        @Override
        public void enterAssociationEnd(@Nonnull AntlrAssociationEnd associationEnd) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".enterAssociationEnd() not implemented yet");
        }
    };
    public static final AntlrAssociation NOT_FOUND = new AntlrAssociation(new KlassParser.AssociationDeclarationContext(NOT_FOUND_PARENT, -1), AntlrCompilationUnit.NOT_FOUND, -1, NOT_FOUND_IDENTIFIER_CONTEXT){

        @Override
        public void enterAssociationEnd(@Nonnull AntlrAssociationEnd associationEnd) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".enterAssociationEnd() not implemented yet");
        }
    };
    private final MutableList<AntlrAssociationEnd> associationEnds = Lists.mutable.empty();
    private final MutableOrderedMap<KlassParser.AssociationEndContext, AntlrAssociationEnd> associationEndsByContext = OrderedMapAdapter.adapt(new LinkedHashMap());
    private AntlrRelationship relationship;
    private AssociationImpl.AssociationBuilder associationBuilder;

    public AntlrAssociation(@Nonnull KlassParser.AssociationDeclarationContext elementContext, @Nonnull AntlrCompilationUnit compilationUnitState, int ordinal, @Nonnull KlassParser.IdentifierContext nameContext) {
        super((ParserRuleContext)elementContext, compilationUnitState, ordinal, nameContext);
    }

    public void visitCriteria(AntlrCriteriaVisitor criteriaVisitor) {
        if (this.relationship == null) {
            return;
        }
        this.relationship.getCriteria().visit(criteriaVisitor);
    }

    @Nonnull
    public KlassParser.AssociationDeclarationContext getElementContext() {
        return (KlassParser.AssociationDeclarationContext)this.elementContext;
    }

    public KlassParser.AssociationBlockContext getBlockContext() {
        return this.getElementContext().associationBlock();
    }

    public MutableList<AntlrAssociationEnd> getAssociationEnds() {
        return this.associationEnds.asUnmodifiable();
    }

    public int getNumAssociationEnds() {
        return this.associationEnds.size();
    }

    public AntlrAssociationEnd getAssociationEndByContext(KlassParser.AssociationEndContext ctx) {
        return (AntlrAssociationEnd)this.associationEndsByContext.get((Object)ctx);
    }

    public void enterAssociationEnd(@Nonnull AntlrAssociationEnd associationEnd) {
        AntlrAssociationEnd duplicate = (AntlrAssociationEnd)this.associationEndsByContext.put((Object)associationEnd.getElementContext(), (Object)associationEnd);
        if (duplicate != null) {
            throw new AssertionError();
        }
        this.associationEnds.add((Object)associationEnd);
    }

    public void exitAssociationDeclaration() {
        int numAssociationEnds = this.associationEnds.size();
        if (numAssociationEnds != 2) {
            throw new AssertionError(numAssociationEnds);
        }
        AntlrClass sourceType = this.getSourceEnd().getType();
        AntlrClass targetType = this.getTargetEnd().getType();
        this.getSourceEnd().setOpposite(this.getTargetEnd());
        this.getTargetEnd().setOpposite(this.getSourceEnd());
        this.getSourceEnd().setOwningClass(targetType);
        this.getTargetEnd().setOwningClass(sourceType);
        if (sourceType != AntlrClass.NOT_FOUND && sourceType != AntlrClass.AMBIGUOUS) {
            sourceType.enterAssociationEnd(this.getTargetEnd());
        }
        if (targetType != AntlrClass.NOT_FOUND && targetType != AntlrClass.AMBIGUOUS) {
            targetType.enterAssociationEnd(this.getSourceEnd());
        }
    }

    public AssociationImpl.AssociationBuilder build() {
        if (this.associationBuilder != null) {
            throw new IllegalStateException();
        }
        int numAssociationEnds = this.associationEnds.size();
        if (numAssociationEnds != 2) {
            throw new AssertionError(numAssociationEnds);
        }
        this.associationBuilder = new AssociationImpl.AssociationBuilder((KlassParser.AssociationDeclarationContext)this.elementContext, this.getMacroElementBuilder(), this.getSourceCodeBuilder(), this.ordinal, this.getNameContext(), this.getPackageName());
        ImmutableList associationEndBuilders = this.associationEnds.collect(AntlrAssociationEnd::build).toImmutable();
        this.associationBuilder.setAssociationEndBuilders(associationEndBuilders);
        AbstractCriteria.AbstractCriteriaBuilder<?> criteriaBuilder = this.relationship.getCriteria().build();
        this.associationBuilder.setCriteriaBuilder(criteriaBuilder);
        return this.associationBuilder;
    }

    @Nonnull
    public AssociationImpl.AssociationBuilder getElementBuilder() {
        return this.associationBuilder;
    }

    @Override
    public void reportErrors(@Nonnull CompilerAnnotationHolder compilerAnnotationHolder) {
        String message;
        int numAssociationEnds = this.associationEnds.size();
        if (numAssociationEnds != 2) {
            String message2 = String.format("Association '%s' should have 2 ends. Found %d", this.getName(), numAssociationEnds);
            compilerAnnotationHolder.add("ERR_ASO_END", message2, this);
            return;
        }
        if (this.getSourceEnd().isOwned() && this.getTargetEnd().isOwned()) {
            message = String.format("Both association ends are owned in '%s'. At most one end may be owned.", this.getName());
            AntlrModifier sourceOwnedModifier = (AntlrModifier)this.getSourceEnd().getModifiers().detect(AntlrModifier::isOwned);
            AntlrModifier targetOwnedModifier = (AntlrModifier)this.getTargetEnd().getModifiers().detect(AntlrModifier::isOwned);
            compilerAnnotationHolder.add("ERR_ASO_OWN", message, (IAntlrElement)this, (ImmutableList<IAntlrElement>)Lists.immutable.with((Object)this.getTargetEnd()).newWithAll(this.getSourceEnd().getSurroundingElements()).distinct(), (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)sourceOwnedModifier.getElementContext(), (Object)targetOwnedModifier.getElementContext()));
        } else if (this.getSourceEnd().isToMany() && this.getTargetEnd().isToOne() && this.getTargetEnd().isOwned()) {
            message = String.format("Association end '%s.%s' is owned, but is on the to-one end of a many-to-one association.", this.getTargetEnd().getOwningClassifier().getName(), this.getTargetEnd().getName());
            AntlrModifier ownedModifier = (AntlrModifier)this.getTargetEnd().getModifiers().detect(AntlrModifier::isOwned);
            compilerAnnotationHolder.add("ERR_OWN_ONE", message, (IAntlrElement)ownedModifier, (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)ownedModifier.getElementContext(), (Object)this.getElementContext().associationBlock().associationBody().associationEnd(1).multiplicity()));
        } else if (this.getSourceEnd().isToOne() && this.getTargetEnd().isToMany() && this.getSourceEnd().isOwned()) {
            message = String.format("Association end '%s.%s' is owned, but is on the to-one end of a one-to-many association.", this.getSourceEnd().getOwningClassifier().getName(), this.getSourceEnd().getName());
            AntlrModifier ownedModifier = (AntlrModifier)this.getSourceEnd().getModifiers().detect(AntlrModifier::isOwned);
            compilerAnnotationHolder.add("ERR_OWN_ONE", message, (IAntlrElement)ownedModifier, (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)ownedModifier.getElementContext(), (Object)this.getElementContext().associationBlock().associationBody().associationEnd(0).multiplicity()));
        } else if (this.getSourceEnd().isToOne() && this.getTargetEnd().isToOne() && this.getSourceEnd().isToOneRequired() == this.getTargetEnd().isToOneRequired() && !this.getSourceEnd().isOwned() && !this.getTargetEnd().isOwned()) {
            message = String.format("Association '%s' is perfectly symmetrical, so foreign keys cannot be inferred. To break the symmetry, make one end owned, or make one end required and the other end optional.", this.getName());
            compilerAnnotationHolder.add("ERR_ASO_SYM", message, (IAntlrElement)this, (ImmutableList<IAntlrElement>)Lists.immutable.with((Object)this.getTargetEnd()).newWithAll(this.getSourceEnd().getSurroundingElements()).distinct(), (ImmutableList<ParserRuleContext>)Lists.immutable.with((Object)this.getSourceEnd().getMultiplicity().getElementContext(), (Object)this.getTargetEnd().getMultiplicity().getElementContext()));
        }
        if (this.getSourceEnd().getType() == AntlrClass.NOT_FOUND || this.getTargetEnd().getType() == AntlrClass.NOT_FOUND) {
            this.getSourceEnd().reportTypeNotFound(compilerAnnotationHolder);
            this.getTargetEnd().reportTypeNotFound(compilerAnnotationHolder);
            return;
        }
        if (this.getSourceEnd().getType() == AntlrClass.AMBIGUOUS || this.getTargetEnd().getType() == AntlrClass.AMBIGUOUS) {
            return;
        }
        if (this.relationship == null) {
            message = String.format("Association '%s' has no relationship", this.getName());
            compilerAnnotationHolder.add("ERR_ASO_REL", message, this);
        } else {
            this.relationship.reportErrors(compilerAnnotationHolder);
        }
    }

    public AntlrRelationship getRelationship() {
        return Objects.requireNonNull(this.relationship);
    }

    public void setRelationship(@Nonnull AntlrRelationship relationship) {
        if (this.relationship != null) {
            throw new IllegalStateException();
        }
        this.relationship = Objects.requireNonNull(relationship);
    }

    public AntlrAssociationEnd getSourceEnd() {
        return (AntlrAssociationEnd)this.associationEnds.get(0);
    }

    public AntlrAssociationEnd getTargetEnd() {
        return (AntlrAssociationEnd)this.associationEnds.get(1);
    }

    public boolean isManyToMany() {
        return this.getSourceEnd().isToMany() && this.getTargetEnd().isToMany();
    }
}

