/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.state;

import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.state.AntlrElement;
import cool.klass.model.converter.compiler.state.AntlrMultiplicityOwner;
import cool.klass.model.converter.compiler.state.IAntlrElement;
import cool.klass.model.meta.domain.api.Multiplicity;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ParserRuleContext;

public class AntlrMultiplicity
extends AntlrElement {
    private final String lowerBoundText;
    private final String upperBoundText;
    @Nullable
    private final Multiplicity multiplicity;
    @Nullable
    private final AntlrMultiplicityOwner multiplicityOwner;

    public AntlrMultiplicity(@Nonnull KlassParser.MultiplicityContext context, @Nonnull Optional<CompilationUnit> compilationUnit, @Nonnull AntlrMultiplicityOwner multiplicityOwner) {
        super((ParserRuleContext)context, compilationUnit);
        this.lowerBoundText = context.multiplicityBody().lowerBound.getText();
        this.upperBoundText = context.multiplicityBody().upperBound.getText();
        this.multiplicity = this.findMultiplicity();
        this.multiplicityOwner = Objects.requireNonNull(multiplicityOwner);
    }

    @Nullable
    private Multiplicity findMultiplicity() {
        if (this.lowerBoundText.equals("0") && this.upperBoundText.equals("1")) {
            return Multiplicity.ZERO_TO_ONE;
        }
        if (this.lowerBoundText.equals("1") && this.upperBoundText.equals("1")) {
            return Multiplicity.ONE_TO_ONE;
        }
        if (this.lowerBoundText.equals("0") && this.upperBoundText.equals("*")) {
            return Multiplicity.ZERO_TO_MANY;
        }
        if (this.lowerBoundText.equals("1") && this.upperBoundText.equals("*")) {
            return Multiplicity.ONE_TO_MANY;
        }
        return null;
    }

    @Override
    @Nonnull
    public Optional<IAntlrElement> getSurroundingElement() {
        return Optional.ofNullable(this.multiplicityOwner);
    }

    @Nonnull
    public KlassParser.MultiplicityContext getElementContext() {
        return (KlassParser.MultiplicityContext)super.getElementContext();
    }

    @Nullable
    public Multiplicity getMultiplicity() {
        return this.multiplicity;
    }

    public String getLowerBoundText() {
        return this.lowerBoundText;
    }

    public String getUpperBoundText() {
        return this.upperBoundText;
    }

    public boolean isToOne() {
        return this.multiplicity != null && this.multiplicity.isToOne();
    }

    public boolean isToMany() {
        return this.multiplicity != null && this.multiplicity.isToMany();
    }

    @Override
    public String toString() {
        return this.lowerBoundText + ".." + this.upperBoundText;
    }
}

